/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationWriter;
import org.jetbrains.coverage.org.objectweb.asm.Attribute;
import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassTooLargeException;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.FieldWriter;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodWriter;
import org.jetbrains.coverage.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ModuleWriter;
import org.jetbrains.coverage.org.objectweb.asm.RecordComponentVisitor;
import org.jetbrains.coverage.org.objectweb.asm.RecordComponentWriter;
import org.jetbrains.coverage.org.objectweb.asm.Symbol;
import org.jetbrains.coverage.org.objectweb.asm.SymbolTable;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;

public class ClassWriter
extends ClassVisitor {
    public static final int COMPUTE_MAXS = 1;
    public static final int COMPUTE_FRAMES = 2;
    private final int flags;
    private int version;
    private final SymbolTable symbolTable;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private FieldWriter firstField;
    private FieldWriter lastField;
    private MethodWriter firstMethod;
    private MethodWriter lastMethod;
    private int numberOfInnerClasses;
    private ByteVector innerClasses;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private int signatureIndex;
    private int sourceFileIndex;
    private ByteVector debugExtension;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ModuleWriter moduleWriter;
    private int nestHostClassIndex;
    private int numberOfNestMemberClasses;
    private ByteVector nestMemberClasses;
    private int numberOfPermittedSubclasses;
    private ByteVector permittedSubclasses;
    private RecordComponentWriter firstRecordComponent;
    private RecordComponentWriter lastRecordComponent;
    private Attribute firstAttribute;
    private int compute;

    /*
     * WARNING - void declaration
     */
    public ClassWriter(int flags) {
        this(null, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ClassWriter(ClassReader classReader, int flags) {
        super(589824);
        void var2_2;
        void var1_1;
        this.flags = flags;
        SymbolTable symbolTable = this.symbolTable = classReader == null ? new SymbolTable(this) : new SymbolTable(this, (ClassReader)var1_1);
        if ((flags & 2) != 0) {
            this.compute = 4;
            return;
        }
        if ((var2_2 & 1) != 0) {
            this.compute = 1;
            return;
        }
        this.compute = 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasFlags(int flags) {
        void var1_1;
        return (this.flags & flags) == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var1_1;
        void var3_3;
        this.version = version;
        this.accessFlags = access;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(version & 0xFFFF, (String)var3_3);
        if (signature != null) {
            this.signatureIndex = this.symbolTable.addConstantUtf8(signature);
        }
        int n = this.superClass = superName == null ? 0 : this.symbolTable.addConstantClass((String)superName).index;
        if (interfaces != null && interfaces.length > 0) {
            this.interfaceCount = interfaces.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.symbolTable.addConstantClass((String)interfaces[i]).index;
            }
        }
        if (this.compute == 1 && (var1_1 & 0xFFFF) >= 51) {
            this.compute = 2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void visitSource(String file, String debug) {
        if (file != null) {
            void var1_1;
            this.sourceFileIndex = this.symbolTable.addConstantUtf8((String)var1_1);
        }
        if (debug != null) {
            void var2_2;
            this.debugExtension = new ByteVector().encodeUtf8((String)var2_2, 0, Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ModuleVisitor visitModule(String name, int access, String version) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.moduleWriter = new ModuleWriter(this.symbolTable, this.symbolTable.addConstantModule((String)var1_1).index, (int)var2_2, version == null ? 0 : this.symbolTable.addConstantUtf8((String)var3_3));
        return this.moduleWriter;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitNestHost(String nestHost) {
        void var1_1;
        this.nestHostClassIndex = this.symbolTable.addConstantClass((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitOuterClass(String owner, String name, String descriptor) {
        void var1_1;
        this.enclosingClassIndex = this.symbolTable.addConstantClass((String)var1_1).index;
        if (name != null && descriptor != null) {
            void var3_3;
            void var2_2;
            this.enclosingMethodIndex = this.symbolTable.addConstantNameAndType((String)var2_2, (String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var1_1;
        if (visible) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, descriptor, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, (String)var1_1, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (visible) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, typeRef, typePath, descriptor, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, (int)var1_1, (TypePath)var2_2, (String)var3_3, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitAttribute(Attribute attribute) {
        void var1_1;
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void visitNestMember(String nestMember) {
        void var1_1;
        if (this.nestMemberClasses == null) {
            this.nestMemberClasses = new ByteVector();
        }
        ++this.numberOfNestMemberClasses;
        this.nestMemberClasses.putShort(this.symbolTable.addConstantClass((String)var1_1).index);
    }

    /*
     * WARNING - void declaration
     */
    public final void visitPermittedSubclass(String permittedSubclass) {
        void var1_1;
        if (this.permittedSubclasses == null) {
            this.permittedSubclasses = new ByteVector();
        }
        ++this.numberOfPermittedSubclasses;
        this.permittedSubclasses.putShort(this.symbolTable.addConstantClass((String)var1_1).index);
    }

    /*
     * WARNING - void declaration
     */
    public final void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.innerClasses == null) {
            this.innerClasses = new ByteVector();
        }
        Symbol nameSymbol = this.symbolTable.addConstantClass(name);
        if (nameSymbol.info == 0) {
            void var3_3;
            void var2_2;
            ++this.numberOfInnerClasses;
            this.innerClasses.putShort(nameSymbol.index);
            this.innerClasses.putShort(outerName == null ? 0 : this.symbolTable.addConstantClass((String)var2_2).index);
            this.innerClasses.putShort(innerName == null ? 0 : this.symbolTable.addConstantUtf8((String)var3_3));
            this.innerClasses.putShort(access);
            var1_1.info = this.numberOfInnerClasses;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        void var1_1;
        void var3_3;
        void var2_2;
        RecordComponentWriter recordComponentWriter = new RecordComponentWriter(this.symbolTable, name, (String)var2_2, (String)var3_3);
        if (this.firstRecordComponent == null) {
            this.firstRecordComponent = recordComponentWriter;
        } else {
            this.lastRecordComponent.delegate = recordComponentWriter;
        }
        this.lastRecordComponent = var1_1;
        return this.lastRecordComponent;
    }

    /*
     * WARNING - void declaration
     */
    public final FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        void var1_2;
        void var3_4;
        void var2_3;
        FieldWriter fieldWriter = new FieldWriter(this.symbolTable, access, (String)var2_3, (String)var3_4, signature, value);
        if (this.firstField == null) {
            this.firstField = fieldWriter;
        } else {
            this.lastField.fv = fieldWriter;
        }
        this.lastField = var1_2;
        return this.lastField;
    }

    /*
     * WARNING - void declaration
     */
    public final MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        void var1_2;
        void var3_4;
        void var2_3;
        MethodWriter methodWriter = new MethodWriter(this.symbolTable, access, (String)var2_3, (String)var3_4, signature, exceptions, this.compute);
        if (this.firstMethod == null) {
            this.firstMethod = methodWriter;
        } else {
            this.lastMethod.mv = methodWriter;
        }
        this.lastMethod = var1_2;
        return this.lastMethod;
    }

    public final void visitEnd() {
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toByteArray() {
        void var1_2;
        void var2_3;
        int size = 24 + 2 * this.interfaceCount;
        int fieldsCount = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++fieldsCount;
            size += fieldWriter.computeFieldInfoSize();
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        int methodsCount = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++methodsCount;
            size += methodWriter.computeMethodInfoSize();
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        int attributesCount = 0;
        if (this.innerClasses != null) {
            ++attributesCount;
            size += 8 + this.innerClasses.length;
            this.symbolTable.addConstantUtf8("InnerClasses");
        }
        if (this.enclosingClassIndex != 0) {
            ++attributesCount;
            size += 10;
            this.symbolTable.addConstantUtf8("EnclosingMethod");
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++attributesCount;
            size += 6;
            this.symbolTable.addConstantUtf8("Synthetic");
        }
        if (this.signatureIndex != 0) {
            ++attributesCount;
            size += 8;
            this.symbolTable.addConstantUtf8("Signature");
        }
        if (this.sourceFileIndex != 0) {
            ++attributesCount;
            size += 8;
            this.symbolTable.addConstantUtf8("SourceFile");
        }
        if (this.debugExtension != null) {
            ++attributesCount;
            size += 6 + this.debugExtension.length;
            this.symbolTable.addConstantUtf8("SourceDebugExtension");
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++attributesCount;
            size += 6;
            this.symbolTable.addConstantUtf8("Deprecated");
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++attributesCount;
            size += this.lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++attributesCount;
            size += this.lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++attributesCount;
            size += this.lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++attributesCount;
            size += this.lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        if (this.symbolTable.computeBootstrapMethodsSize() > 0) {
            ++attributesCount;
            size += this.symbolTable.computeBootstrapMethodsSize();
        }
        if (this.moduleWriter != null) {
            attributesCount += this.moduleWriter.getAttributeCount();
            size += this.moduleWriter.computeAttributesSize();
        }
        if (this.nestHostClassIndex != 0) {
            ++attributesCount;
            size += 8;
            this.symbolTable.addConstantUtf8("NestHost");
        }
        if (this.nestMemberClasses != null) {
            ++attributesCount;
            size += 8 + this.nestMemberClasses.length;
            this.symbolTable.addConstantUtf8("NestMembers");
        }
        if (this.permittedSubclasses != null) {
            ++attributesCount;
            size += 8 + this.permittedSubclasses.length;
            this.symbolTable.addConstantUtf8("PermittedSubclasses");
        }
        int recordComponentCount = 0;
        int recordSize = 0;
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
            while (recordComponentWriter != null) {
                ++recordComponentCount;
                recordSize += recordComponentWriter.computeRecordComponentInfoSize();
                recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
            }
            ++attributesCount;
            size += recordSize + 8;
            this.symbolTable.addConstantUtf8("Record");
        }
        if (this.firstAttribute != null) {
            attributesCount += this.firstAttribute.getAttributeCount();
            size += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        size += this.symbolTable.getConstantPoolLength();
        int constantPoolCount = this.symbolTable.getConstantPoolCount();
        if (constantPoolCount > 65535) {
            throw new ClassTooLargeException(this.symbolTable.getClassName(), constantPoolCount);
        }
        ByteVector result = new ByteVector(size);
        result.putInt(-889275714).putInt(this.version);
        this.symbolTable.putConstantPool(result);
        int mask22 = (this.version & 0xFFFF) < 49 ? 4096 : 0;
        result.putShort(this.accessFlags & ~mask22).putShort(this.thisClass).putShort(this.superClass);
        result.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            result.putShort(this.interfaces[i]);
        }
        result.putShort(fieldsCount);
        Object mask22 = this.firstField;
        while (mask22 != null) {
            ((FieldWriter)mask22).putFieldInfo(result);
            mask22 = (FieldWriter)((FieldWriter)mask22).fv;
        }
        result.putShort(methodsCount);
        boolean hasFrames = false;
        boolean hasAsmInstructions = false;
        mask22 = this.firstMethod;
        while (mask22 != null) {
            hasFrames |= ((MethodWriter)mask22).hasFrames();
            hasAsmInstructions |= ((MethodWriter)mask22).hasAsmInstructions();
            ((MethodWriter)mask22).putMethodInfo(result);
            mask22 = (MethodWriter)((MethodWriter)mask22).mv;
        }
        result.putShort(attributesCount);
        if (this.innerClasses != null) {
            result.putShort(this.symbolTable.addConstantUtf8("InnerClasses")).putInt(this.innerClasses.length + 2).putShort(this.numberOfInnerClasses).putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.enclosingClassIndex != 0) {
            result.putShort(this.symbolTable.addConstantUtf8("EnclosingMethod")).putInt(4).putShort(this.enclosingClassIndex).putShort(this.enclosingMethodIndex);
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            result.putShort(this.symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (this.signatureIndex != 0) {
            result.putShort(this.symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(this.signatureIndex);
        }
        if (this.sourceFileIndex != 0) {
            result.putShort(this.symbolTable.addConstantUtf8("SourceFile")).putInt(2).putShort(this.sourceFileIndex);
        }
        if (this.debugExtension != null) {
            int length = this.debugExtension.length;
            result.putShort(this.symbolTable.addConstantUtf8("SourceDebugExtension")).putInt(length).putByteArray(this.debugExtension.data, 0, length);
        }
        if ((this.accessFlags & 0x20000) != 0) {
            result.putShort(this.symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, result);
        this.symbolTable.putBootstrapMethods(result);
        if (this.moduleWriter != null) {
            this.moduleWriter.putAttributes(result);
        }
        if (this.nestHostClassIndex != 0) {
            result.putShort(this.symbolTable.addConstantUtf8("NestHost")).putInt(2).putShort(this.nestHostClassIndex);
        }
        if (this.nestMemberClasses != null) {
            result.putShort(this.symbolTable.addConstantUtf8("NestMembers")).putInt(this.nestMemberClasses.length + 2).putShort(this.numberOfNestMemberClasses).putByteArray(this.nestMemberClasses.data, 0, this.nestMemberClasses.length);
        }
        if (this.permittedSubclasses != null) {
            result.putShort(this.symbolTable.addConstantUtf8("PermittedSubclasses")).putInt(this.permittedSubclasses.length + 2).putShort(this.numberOfPermittedSubclasses).putByteArray(this.permittedSubclasses.data, 0, this.permittedSubclasses.length);
        }
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            result.putShort(this.symbolTable.addConstantUtf8("Record")).putInt(recordSize + 2).putShort(recordComponentCount);
            RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
            while (recordComponentWriter != null) {
                recordComponentWriter.putRecordComponentInfo(result);
                recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
            }
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, result);
        }
        if (var2_3 != false) {
            return this.replaceAsmInstructions(result.data, hasFrames);
        }
        return var1_2.data;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] replaceAsmInstructions(byte[] classFile, boolean hasFrames) {
        void var2_2;
        void var3_3;
        void var1_1;
        Attribute[] attributes = this.getAttributePrototypes();
        this.firstField = null;
        this.lastField = null;
        this.firstMethod = null;
        this.lastMethod = null;
        this.lastRuntimeVisibleAnnotation = null;
        this.lastRuntimeInvisibleAnnotation = null;
        this.lastRuntimeVisibleTypeAnnotation = null;
        this.lastRuntimeInvisibleTypeAnnotation = null;
        this.moduleWriter = null;
        this.nestHostClassIndex = 0;
        this.numberOfNestMemberClasses = 0;
        this.nestMemberClasses = null;
        this.numberOfPermittedSubclasses = 0;
        this.permittedSubclasses = null;
        this.firstRecordComponent = null;
        this.lastRecordComponent = null;
        this.firstAttribute = null;
        this.compute = hasFrames ? 3 : 0;
        new ClassReader((byte[])var1_1, 0, false).accept(this, (Attribute[])var3_3, (var2_2 != false ? 8 : 0) | 0x100);
        return this.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private Attribute[] getAttributePrototypes() {
        void var1_1;
        Attribute.Set attributePrototypes = new Attribute.Set();
        attributePrototypes.addAttributes(this.firstAttribute);
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.collectAttributePrototypes(attributePrototypes);
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            methodWriter.collectAttributePrototypes(attributePrototypes);
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
        while (recordComponentWriter != null) {
            recordComponentWriter.collectAttributePrototypes(attributePrototypes);
            recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
        }
        return var1_1.toArray();
    }

    /*
     * WARNING - void declaration
     */
    public int newConst(Object value) {
        void var1_1;
        return this.symbolTable.addConstant((Object)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newUTF8(String value) {
        void var1_1;
        return this.symbolTable.addConstantUtf8((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int newClass(String value) {
        void var1_1;
        return this.symbolTable.addConstantClass((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newMethodType(String methodDescriptor) {
        void var1_1;
        return this.symbolTable.addConstantMethodType((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newModule(String moduleName) {
        void var1_1;
        return this.symbolTable.addConstantModule((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newPackage(String packageName) {
        void var1_1;
        return this.symbolTable.addConstantPackage((String)var1_1).index;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public int newHandle(int tag, String owner, String name, String descriptor) {
        void var1_1;
        void var3_3;
        void var2_2;
        return this.newHandle(tag, (String)var2_2, (String)var3_3, descriptor, var1_1 == 9);
    }

    /*
     * WARNING - void declaration
     */
    public int newHandle(int tag, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantMethodHandle((int)var1_1, (String)var2_2, (String)var3_3, (String)descriptor, (boolean)isInterface).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newConstantDynamic(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantDynamic((String)var1_1, (String)var2_2, (Handle)var3_3, (Object[])bootstrapMethodArguments).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newInvokeDynamic(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantInvokeDynamic((String)var1_1, (String)var2_2, (Handle)var3_3, (Object[])bootstrapMethodArguments).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newField(String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantFieldref((String)var1_1, (String)var2_2, (String)var3_3).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newMethod(String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantMethodref((String)var1_1, (String)var2_2, (String)var3_3, (boolean)isInterface).index;
    }

    /*
     * WARNING - void declaration
     */
    public int newNameType(String name, String descriptor) {
        void var2_2;
        void var1_1;
        return this.symbolTable.addConstantNameAndType((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> class2;
        Class<?> class1;
        ClassLoader classLoader = this.getClassLoader();
        try {
            class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type1, e);
        }
        try {
            class2 = Class.forName(type2.replace('/', '.'), false, (ClassLoader)e);
        }
        catch (ClassNotFoundException e) {
            void var1_2;
            throw new TypeNotPresentException(type2, (Throwable)var1_2);
        }
        if (class1.isAssignableFrom(class2)) {
            void var1_1;
            return var1_1;
        }
        if (class2.isAssignableFrom(class1)) {
            void var2_3;
            return var2_3;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

