/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameValuePair;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrGeneratedConstructorUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ast.contributor.SyntheticKeywordConstructorContributor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/GeneratedConstructorAnnotationChecker;", "Lorg/jetbrains/plugins/groovy/annotator/checkers/CustomAnnotationChecker;", "<init>", "()V", "checkArgumentList", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotation", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/modifiers/annotation/GrAnnotation;", "Companion", "intellij.groovy.psi"})
public final class GeneratedConstructorAnnotationChecker
extends CustomAnnotationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean checkArgumentList(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        PsiNameValuePair callSuper;
        PsiAnnotationMemberValue post;
        PsiAnnotationMemberValue pre;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (!CollectionsKt.contains((Iterable)GrGeneratedConstructorUtils.getConstructorGeneratingAnnotations(), (Object)annotation.getQualifiedName())) {
            return false;
        }
        List<String> excludes = GrGeneratedConstructorUtils.getIdentifierList(annotation, "excludes");
        PsiNameValuePair includes = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"includes");
        if (includes != null && !((collection = (Collection)excludes) == null || collection.isEmpty())) {
            PsiNameValuePair psiNameValuePair = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"excludes");
            Intrinsics.checkNotNull((Object)psiNameValuePair);
            GeneratedConstructorAnnotationChecker.Companion.registerIdentifierListError(holder, (PsiElement)psiNameValuePair);
            GeneratedConstructorAnnotationChecker.Companion.registerIdentifierListError(holder, (PsiElement)includes);
        }
        PsiNameValuePair psiNameValuePair = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"pre");
        Object object = pre = psiNameValuePair != null ? psiNameValuePair.getValue() : null;
        if (pre != null && !(pre instanceof GrFunctionalExpression)) {
            GeneratedConstructorAnnotationChecker.Companion.registerClosureError(holder, (PsiElement)pre);
        }
        PsiNameValuePair psiNameValuePair2 = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"post");
        Object object2 = post = psiNameValuePair2 != null ? psiNameValuePair2.getValue() : null;
        if (post != null && !(post instanceof GrFunctionalExpression)) {
            GeneratedConstructorAnnotationChecker.Companion.registerClosureError(holder, (PsiElement)post);
        }
        if ((callSuper = AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"callSuper")) != null && pre != null && Intrinsics.areEqual((Object)GrAnnotationUtil.inferBooleanAttribute(annotation, "callSuper"), (Object)true) && Companion.isSuperCalledInPre(annotation)) {
            GeneratedConstructorAnnotationChecker.Companion.registerDuplicateSuperError(holder, (PsiElement)callSuper);
        }
        return false;
    }

    @JvmStatic
    public static final boolean isSuperCalledInPre(@NotNull PsiAnnotation annotation) {
        return Companion.isSuperCalledInPre(annotation);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/checkers/GeneratedConstructorAnnotationChecker$Companion;", "", "<init>", "()V", "isSuperCalledInPre", "", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "registerIdentifierListError", "", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "element", "Lcom/intellij/psi/PsiElement;", "registerClosureError", "registerDuplicateSuperError", "intellij.groovy.psi"})
    @SourceDebugExtension(value={"SMAP\nGeneratedConstructorAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratedConstructorAnnotationChecker.kt\norg/jetbrains/plugins/groovy/annotator/checkers/GeneratedConstructorAnnotationChecker$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isSuperCalledInPre(@NotNull PsiAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Object[] objectArray = GrAnnotationUtil.inferClosureAttribute(annotation, "pre");
            GrStatement grStatement = objectArray != null && (objectArray = objectArray.getStatements()) != null ? (GrStatement)ArraysKt.firstOrNull((Object[])objectArray) : null;
            grStatement = grStatement instanceof GrMethodCall ? (GrMethodCall)grStatement : null;
            SyntheticKeywordConstructorContributor.Companion companion = SyntheticKeywordConstructorContributor.Companion;
            GrStatement p0 = grStatement;
            boolean $i$f$isSuperCalledInPre$stub_for_inlining = false;
            boolean bl = false;
            return companion.isSyntheticConstructorCall((GrMethodCall)p0);
        }

        private final void registerIdentifierListError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("explicit.includes.and.excludes", new Object[0])).range(element).create();
        }

        private final void registerClosureError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("require.closure.as.attribute.value", new Object[0])).range(element).create();
        }

        private final void registerDuplicateSuperError(AnnotationHolder holder, PsiElement element) {
            holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("super.is.not.allowed.in.pre.with.call.super", new Object[0])).range(element).create();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

