/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.context.RealtimeObject;
import javolution.io.UTF8ByteBufferReader;
import javolution.io.UTF8ByteBufferWriter;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;

final class PerfXML
extends Javolution
implements Runnable {
    private static final int OBJECT_SIZE = 1000;
    private static final int BYTE_BUFFER_SIZE = 1400000;

    PerfXML() {
    }

    public void run() {
        int n;
        PerfXML.println("/////////////////////////////");
        PerfXML.println("// Package: javolution.xml //");
        PerfXML.println("/////////////////////////////");
        PerfXML.println("");
        PerfXML.println("-- Java(TM) Serialization --");
        PerfXML.setOutputStream(null);
        for (n = 0; n < 10; ++n) {
            this.benchmarkJavaSerialization();
        }
        PerfXML.setOutputStream(System.out);
        this.benchmarkJavaSerialization();
        PerfXML.println("");
        PerfXML.println("-- XML Serialization (I/O Stream) --");
        PerfXML.setOutputStream(null);
        for (n = 0; n < 10; ++n) {
            this.benchmarkXmlIoSerialization();
        }
        PerfXML.setOutputStream(System.out);
        this.benchmarkXmlIoSerialization();
        PerfXML.println("");
        PerfXML.println("-- XML Serialization (NIO ByteBuffer) --");
        PerfXML.setOutputStream(null);
        for (n = 0; n < 10; ++n) {
            this.benchmarkXmlNioSerialization();
        }
        PerfXML.setOutputStream(System.out);
        this.benchmarkXmlNioSerialization();
        PerfXML.println("");
    }

    private void benchmarkJavaSerialization() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1400000);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            Object object = PerfXML.newData();
            PerfXML.print("Write Time: ");
            PerfXML.startTime();
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            PerfXML.println(PerfXML.endTime(1));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            PerfXML.print("Read Time: ");
            PerfXML.startTime();
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            PerfXML.println(PerfXML.endTime(1));
            if (!object.equals(object2)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            PerfXML.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private void benchmarkXmlIoSerialization() {
        XMLBinding xMLBinding = new XMLBinding();
        xMLBinding.setAlias(String.class, "String");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1400000);
            XMLObjectWriter xMLObjectWriter = XMLObjectWriter.newInstance(byteArrayOutputStream);
            xMLObjectWriter.setBinding(xMLBinding);
            Object object = PerfXML.newData();
            PerfXML.print("Write Time: ");
            PerfXML.startTime();
            xMLObjectWriter.write(object);
            xMLObjectWriter.close();
            PerfXML.println(PerfXML.endTime(1));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            XMLObjectReader xMLObjectReader = XMLObjectReader.newInstance(byteArrayInputStream);
            xMLObjectReader.setBinding(xMLBinding);
            PerfXML.print("Read Time: ");
            PerfXML.startTime();
            Object t = xMLObjectReader.read();
            xMLObjectReader.close();
            PerfXML.println(PerfXML.endTime(1));
            if (!object.equals(t)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            PerfXML.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private void benchmarkXmlNioSerialization() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1400000);
            XMLObjectWriter xMLObjectWriter = XMLObjectWriter.newInstance(new UTF8ByteBufferWriter().setOutput(byteBuffer));
            Object object = PerfXML.newData();
            PerfXML.print("Write Time: ");
            PerfXML.startTime();
            xMLObjectWriter.write(object);
            xMLObjectWriter.close();
            PerfXML.println(PerfXML.endTime(1));
            byteBuffer.flip();
            XMLObjectReader xMLObjectReader = XMLObjectReader.newInstance(new UTF8ByteBufferReader().setInput(byteBuffer));
            PerfXML.print("Read Time: ");
            PerfXML.startTime();
            Object t = xMLObjectReader.read();
            xMLObjectReader.close();
            PerfXML.println(PerfXML.endTime(1));
            if (!object.equals(t)) {
                throw new Error("SERIALIZATION ERROR");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            PerfXML.println("NOT SUPPORTED (J2SE 1.4+ build required)");
        }
        catch (Throwable throwable) {
            throw new JavolutionError(throwable);
        }
    }

    private static Object newData() {
        FastTable<RealtimeObject> fastTable = new FastTable<RealtimeObject>(1000);
        for (int i = 0; i < 1000; ++i) {
            FastTable<String> fastTable2 = new FastTable<String>();
            fastTable2.add("This is the first String (" + i + ")");
            fastTable2.add("This is the second String (" + i + ")");
            fastTable2.add("This is the third String (" + i + ")");
            fastTable.add(fastTable2);
            fastTable.add(null);
            fastTable.add(TextBuilder.newInstance().append(Long.MAX_VALUE));
            fastTable.add(Text.valueOf(Long.MAX_VALUE, 16));
            FastMap<String, Text> fastMap = new FastMap<String, Text>();
            fastMap.setKeyComparator(FastComparator.REHASH);
            fastMap.setValueComparator(FastComparator.IDENTITY);
            fastMap.put(new String("ONE"), Text.valueOf(1));
            fastMap.put(new String("TWO"), Text.valueOf(2));
            fastMap.put(new String("THREE"), Text.valueOf(3));
            fastTable.add(fastMap);
            FastList<String> fastList = new FastList<String>();
            fastList.add("FIRST");
            fastList.add("SECOND");
            fastList.add("THIRD");
            fastList.add("<...>");
            fastTable.add(fastList);
            FastSet<String> fastSet = new FastSet<String>();
            fastSet.add("ALPHA");
            fastSet.add("BETA");
            fastSet.add("GAMMA");
            fastTable.add(fastSet);
        }
        return fastTable;
    }
}

