# Lore - Background Story

#### Seriously, spoiler alert.
CDDA tells stories using unreliable narrators and a found footage style.  Knowing too much of the lore can ruin your experience.  Don't read this unless you plan to contribute, please! All contents subject to change with project development.

### Summary

The US government discovered alternate dimensions and began secretly researching them. They developed a handful of useful technologies secondary to this development. In their explorations they obtained a sample called "XE-037", a mysterious black goo that was able to reanimate the dead and cause miraculous targeted phenotype mutations. XE-037 escaped, contaminating the groundwater and causing an enormous zombie outbreak. As this spiraled out of control, Earth became the target of a multidimensional portal attack through which the entity controlling XE-037 took over our world. Simultaneously, forces from other dimensions entered opportunistically as our dimensional fabric was destabilized. This was the Cataclysm.

Things are a bit more stable now, but nobody is left alive to appreciate that.

### Timeline

Note: Canon date of game start is in "YEAR", which equals the IRL year the game world was created +1.
Additional information can also be found in the [newspaper snippets](https://github.com/CleverRaven/Cataclysm-DDA/blob/master/data/json/snippets/newspapers.json). Related files in the directory may also be of use.

#### YEAR -35 or so
- An interdimensional traveler from an alternate earth crash lands a portal traveling vessel in the American Midwest. The traveler dies, the vessel is appropriated by the US government and starts a chain of research.  The technology is very similar to Earth tech of the 1990s, but the actual dimensional travelling technology is as-yet undeveloped, and there are examples of equivalent but divergent energy technologies: there is a simple but functional high-capacity fuel cell on board, using mostly Earth accessible designs but with a few exotic components that will take time to reverse engineer.
- NOTE: Technologies from the crashed vessel should all be related in some way to dimension folding: dimensional heuristic AI, dimensional folding for power storage, or actual portals all come from here.

#### YEAR -25 (+/- 5 years)
- Some DARPA researchers successfully open unstable portals to nearby subdimensions, but never for very long.
- A handful of senior DARPA researchers begin drawing in small amounts of rare metals and isotopes through micro-portals, helping their research to fund itself.  The few aware of this practice keep it quiet, building shell accounts that grow into shell companies.

#### YEAR -20 (+/- 5 years)
- Advances in reverse engineering and some tests of portal tech lead to improved synthesis of fuel cells from the dimensional craft.  These cells are still bulky but enable a lot of new technologies to be imagined.  They use radioactive plutonium as a catalyst in the fuel reaction, earning the nickname "plutonium fuel cells".  Due to the risk of radioactivity, they are not widely adopted outside of experimental use.
- A stable portal is opened, and a creature from the netherum breaks through, destroying a large portion of a DARPA lab. The facility auto-destruct is engaged and the event disguised as a mine collapse.  DARPA's ability to continue portal research is hampered by red tape.  Those depending financially on portals begin working harder on their shell companies, setting up secret research labs to continue working on portal tech outside DARPA's interference.
- Research into pilotable robot exoskeletons results in the first large production robotic suit for cargo handling.  It remains prohibitively expensive for most applications.  These suits use a simplified fuel cell design from the dimensional craft, but not all the raw materials needed have yet been synthesized, so the efficiency is much lower.

#### YEAR -15 (+/- 5 years)
- Artificial intelligence using dimensional probability heuristics is developed. This is an AI that can simulate deductive reasoning by scanning several adjacent realities to create a realistic estimation of the outcome of an action, quite analogous to human deductive reasoning. In a small scale this is surprisingly efficient. These technologies are novel but were derived from concepts laid out in the dimensional craft.

#### YEAR -8
- Melchior is developed. It is a useful research assistant using dimensional heuristics but nowhere near as intelligent as hoped, due to the prohibitive power requirements of anticipating more than a few minutes ahead in time. Its inability to plan in the long term is seen as a crippling defect, but it remains an overall success.
- **June**: The first powered exoskeletons are OK'd for military use, in limited test deployments.  Although incredibly powerful against small arms fire, these "tank suits" are too large, expensive, and heavy to gain any advantages from their humanoid shape.  They do not see full scale production.

#### YEAR -7
*Big Picture*: Some government elements begin to notice that a few shell corporations have sprung up with access to DARPA-level technology.  They are hastily silenced and/or brought into the fold.
- **February**: An extraterrestrial visitor, frozen in ice, is retrieved by a Japanese whaling boat, and hastily recovered by their government and research agencies. This is the first contact between mi-go and humans. Existence of the aliens is heard in rumours and leaked photos on the internet, until a well-known Redditor posts a 'making of' video that shows detailed information of how she constructed the model alien for an art exhibit. The photos continue to circulate but are relegated to places online where people don't believe in Snopes.

#### YEAR -6
*Big Picture*: The first eyebot drones are deployed to assist in police work. This is one of the first public displays of new AI systems using dimensional probability heuristics, with the actual DPH being managed by a central mainframe. From a public perspective the dimensional aspect is kept concealed and people are told it is an example of machine learning. Even engineers working on the technology have no idea how it really works (not far off of current deep machine learning really, but better).
- **May**: A mi-go scout arrives in orbit in response to the awakened signal of the mi-go in the ice. It does not make immediate contact with humans.

#### YEAR -4
- **July**: The first military grade heavy power armors are released for field testing.  Unlike the tank suits, these are light and small enough to allow close quarters maneuvering in urban environments, and remain almost impervious to all but the heaviest of conventional weaponry.  Development on smaller, less expensive suits becomes a priority.
- **August**: Problems with China begin to brew as US intelligence suspects that China has access to portal technology, and may be ahead of the US in terms of exploiting and stabilizing portals.  Key DARPA researchers push the military to allow them to restart full portal research projects.

#### YEAR -3
*Big Picture*: A space-race like portal development push grows between the US and China.  It is unclear if China ever had full portal technology or not, but the US is convinced the risk is significant enough to require rapid steps to overtake them.
- **January**: US reopens portal research, considering it a safer proposition with Melchior's assistance, and potentially a good way to get ahead of China.
- **July**: Researchers publish results regarding portal stability that help to explain the unexpectedly large portal of 9 years ago. Polydimensional topography has numerous stable planes, and the energy required to make portals to certain areas is much lower. Early researchers hadn't known about this, and put far too much energy into a portal to an energetically accessible location, creating a much bigger portal than intended. This knowledge allows much safer exploration of micro portals.
- **November**: A research remote probe sent to an adjacent dimension brings back an unidentified biocontaminant, which is captured for analysis but inadvertently destroyed by standard safety procedures. The Blob becomes aware of our existence.

#### Year -2
- **February**: Immediately following Chinese New Year, China announces the opening a functional large-scale fusion reactor.  DARPA researchers are convinced that it is actually a false front for a reactor powered by isotopes obtained through portal travel.
- **May**: XEDRA (Xenophysical Energy Defense Research Agency) is formed to focus research into transdimensional phenomena. Publically they are masked as DARPA researchers, and other more mundane groups. They are given an enormous budget, considered by the US government to be equivalent to NASA in the current cold war. Certain close allies to the US join the effort, sending top minds and resources to XEDRA facilities across North America.
- **August**: A XEDRA facility in the Northwest reports a major sample stolen. Counterintelligence identifies China as the most likely culprit, and backtraces the theft to hypothesize that significant XEDRA research data was compromised. New protocols are put in place, including advanced robotic security managed by Melchior.  These automated turrets use a prototype AI that isn't yet ready for this type of service, and the humans involved in monitoring their results express severe concerns about the technology being used at all.
- **September**: XEDRA is broken into several connected but distinct agencies. In several of these agencies, desperate to catch up for time now lost by presumed stolen research, reasonable safety protocols are dropped in favour of Melchior predictions of immediate repercussions. This has the obvious (especially in hindsight) flaw that anything that does not have immediate repercussions will be missed: there are few lab explosions, but the Blob is able to leverage this weakness.
- **November 3**: The first manned research expedition to another dimension - rather, a between-space nicknamed "the netherum" by sci-fi obsessed researchers - is launched. Based on reports of strange, hard-to-comprehend geometry, researchers begin using terms from the works of classic horror writers to describe creatures found there.
- **December 18**: Sample XE-037 is brought back to Earth from the netherum. It is about thirty grams of blob matter. Standard decontamination protocols are observed. However, standard protocols do not take into account the possibility of malicious, intelligent molecular-scale contaminants. Microscopic particles of XE-037 migrate from the contamination filters onto the skin of scientists and escape containment. Soon after, the Blob enters the groundwater and begins to spread at extremely low concentrations.

#### Year -1
- **July**: Several smaller powered exoskeletons, including both the private defence contractor Rivtech's version and a US government one, are released for field use.
- **November**: Laser weapons powered by new energy technology are made widely available to military procurement, albeit still in small numbers.

#### Year 0 (the current IRL year +1)
- **January**: The blob reaches satisfactory global-level groundwater saturation and makes the decision to commence the concentration and replication phase.
For the next few weeks there is a gradual rise in violent crime, and occasional reports of strange mutations and weird animal sightings in the wild, but little attention is paid.
- **February**: First reports of people rising from the dead, XEDRA immediately makes correct assumptions about what's up as they've been experimenting on the blob and recognize its effects. The US government assumes it's a controllable outbreak and tries to squelch reports to avoid classified information getting out. A very successful counterintelligence campaign makes YouTube reports of zombies and ferals into a high-quality prank that has caught on among the meme community. After all, any time a video comes out, an undoctored version surfaces not long after.
- **March**: Nations that are already unstable start to see riots, as passive blob infection causes people to become more violent - some outright feral. A few small wars break out. Thanks to word spreading via the internet, people around the world generally realize something is amiss, but the US government and other allied international intelligence agencies continue to work hard on squashing it. At first it's not hard, because the places it's happening are places where the tipping point was reached sooner.
- **March 30**: A soon-to-be famous YouTube video surfaces, of a screaming young mother violently killing what appears to be her own child amidst a riot in Minneapolis. For most survivors, this will be where they remember it becoming clear that things were really seriously wrong.
- **April 1**: Attempts to keep it under wraps become unsustainable as violent outbursts become common in developed nations. Government changes the spin to "chinese mind control agents". Upper ranking members of government also experience psychosis leading to some truly weird circumstances, like Rhode Island declaring secession from the US and war on the government.
- **April 10**: A national state of emergency in the US is finally declared as the government realizes control is impossible.
At this point riots are widespread and the police forces are unable to keep it under control. Military forces are deployed but the blob psychosis means their response is irrationally violent and they do not follow the correct protocol.
On top of that, those less affected by the blob psychosis are simply overwhelmed by masses of rioters and with hordes of now risen undead mixed in.
- **April 15**: Just as government resources are strained to their absolute breaking point (globally, not just in the US), the portal storms begin. The blob exercises a shred of effort for the first time since it entered our dimension, and bends reality so that the access to energy to create dimensional rifts is far easier. Gates to the netherum open spontaneously, allowing rampaging beasts of indescribable form to add their involvement to the already rampant chaos. Amidst the violence, the blob sends in a collection of its Lieutenants, alien zombies that have been evolving and growing for centuries or millenia. They begin organizing the burgeoning zombie hordes in tactically important locations.
- **April 16**: In response to portal storms, the government nukes as many lab facilities as it can, pinning the attacks on China. With much of the command chain mentally influenced by the blob, military and police responses to the rioting, zombie hordes, and now extradimensional monsters and alien zombie armies are worse than suboptimal and in most cases actively harmful. Similar responses are seen in other countries. Things spiral out of control quickly now, with each passing day seeing rapidly mounting casualties as the people still in their right minds are largely killed off and turned to zombies.
- **April 25**: A low-ranking US government official manages to get access to the emergency broadcast system, and sends out a final message. "The government has fallen. No help is coming, you're on your own." There is no total consensus, but among survivors, many consider this to be the "day the world ended".
- **April 30**: Canonical date of game start.
