/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.PDIClassLoader;
import org.pentaho.di.core.config.ConfigManager;
import org.pentaho.di.core.config.KettleConfig;
import org.pentaho.di.core.exception.KettleConfigException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepLoaderException;
import org.pentaho.di.core.plugins.PluginLoader;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.i18n.LoaderInputStreamProvider;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobPlugin;
import org.pentaho.di.job.JobPluginMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryLoader
implements LoaderInputStreamProvider {
    private static JobEntryLoader jobEntryLoader = null;
    private List<JobPlugin> pluginList = new ArrayList<JobPlugin>();
    private Hashtable<String, URLClassLoader> classLoaders = new Hashtable();
    private boolean initialized = false;

    private JobEntryLoader() {
    }

    public static final JobEntryLoader getInstance() {
        if (jobEntryLoader != null) {
            return jobEntryLoader;
        }
        jobEntryLoader = new JobEntryLoader();
        return jobEntryLoader;
    }

    public boolean read() throws KettleException {
        this.readNatives();
        this.readPlugins();
        this.initialized = true;
        return true;
    }

    public static final void init() throws KettleException {
        JobEntryLoader loader = JobEntryLoader.getInstance();
        loader.readNatives();
        loader.readPlugins();
        loader.initialized = true;
    }

    public boolean readNatives() {
        try {
            ConfigManager<?> jobsAnntCfg = KettleConfig.getInstance().getManager("jobs-annotation-config");
            Collection<JobPluginMeta> jobs = jobsAnntCfg.loadAs(JobPluginMeta.class);
            ConfigManager<?> jobsCfg = KettleConfig.getInstance().getManager("jobs-xml-config");
            Collection<JobPluginMeta> cjobs = jobsCfg.loadAs(JobPluginMeta.class);
            jobs.addAll(cjobs);
            for (JobPluginMeta job : jobs) {
                if (job.getType() != JobEntryType.NONE) {
                    this.pluginList.add(new JobPlugin(1, job.getId(), job.getType(), job.getTooltipDesc(), null, null, job.getImageFileName(), job.getClassName().getName(), job.getCategory()));
                    continue;
                }
                if (Const.isEmpty((String)job.getName())) continue;
                this.pluginList.add(new JobPlugin(2, job.getId(), job.getName(), job.getTooltipDesc(), null, null, job.getImageFileName(), job.getClassName().getName(), job.getCategory()));
            }
        }
        catch (KettleConfigException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean readPlugins() {
        try {
            PluginLoader loader = PluginLoader.getInstance();
            loader.load("plugins-config");
            this.pluginList.addAll(loader.getDefinedPlugins(JobPlugin.class));
            return true;
        }
        catch (KettleConfigException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JobEntryInterface getJobEntryClass(String desc) throws KettleStepLoaderException {
        JobPlugin jp = this.findJobEntriesWithDescription(desc);
        return this.getJobEntryClass(jp);
    }

    public Class<?> loadClass(JobPlugin sp, String className) throws KettleStepLoaderException {
        try {
            switch (sp.getType()) {
                case 1: {
                    return Class.forName(className);
                }
                case 2: {
                    ClassLoader cl = this.getClassLoader(sp);
                    return cl.loadClass(className);
                }
            }
            throw new KettleStepLoaderException("Unknown plugin type : " + sp.getType());
        }
        catch (Exception e) {
            throw new KettleStepLoaderException((Throwable)e);
        }
    }

    public Class<?> loadClass(String desc, String className) throws KettleStepLoaderException {
        try {
            return this.loadClass(this.findJobEntriesWithDescription(desc), className);
        }
        catch (Exception e) {
            throw new KettleStepLoaderException((Throwable)e);
        }
    }

    public Class<?> loadClassByID(String id, String className) throws KettleStepLoaderException {
        try {
            return this.loadClass(this.findJobEntriesWithID(id), className);
        }
        catch (Exception e) {
            throw new KettleStepLoaderException((Throwable)e);
        }
    }

    public JobEntryInterface getJobEntryClass(JobPlugin sp) throws KettleStepLoaderException {
        if (sp != null) {
            try {
                Class<?> cl = null;
                switch (sp.getType()) {
                    case 1: {
                        cl = Class.forName(sp.getClassname());
                        break;
                    }
                    case 2: {
                        ClassLoader ucl = this.getClassLoader(sp);
                        cl = ucl.loadClass(sp.getClassname());
                        break;
                    }
                    default: {
                        throw new KettleStepLoaderException("Unknown plugin type : " + sp.getType());
                    }
                }
                JobEntryInterface res = (JobEntryInterface)cl.newInstance();
                if (sp.getType() == 2) {
                    res.setPluginID((String)sp.getID());
                }
                res.setDescription(sp.getDescription());
                res.setName((String)sp.getID());
                res.setConfigId((String)sp.getID());
                if (res.getJobEntryType() == null) {
                    res.setJobEntryType(sp.getJobType());
                }
                return res;
            }
            catch (ClassNotFoundException e) {
                throw new KettleStepLoaderException("Class not found", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new KettleStepLoaderException("Unable to instantiate class", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new KettleStepLoaderException("Illegal access to class", (Throwable)e);
            }
            catch (Throwable e) {
                throw new KettleStepLoaderException("Unexpected error loading class", e);
            }
        }
        throw new KettleStepLoaderException("No valid step/plugin specified (plugin=null).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(JobPlugin sp) throws FileSystemException, MalformedURLException {
        String[] jarfiles = sp.getJarfiles();
        ArrayList<URL> classpath = new ArrayList<URL>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver((ResourceLoader)new FileSystemResourceLoader());
        if (jarfiles != null) {
            for (int i = 0; i < jarfiles.length; ++i) {
                try {
                    Resource[] paths;
                    for (Resource path : paths = resolver.getResources(jarfiles[i])) {
                        classpath.add(path.getURL());
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        URL[] urls = classpath.toArray(new URL[0]);
        ClassLoader classLoader = this.getClass().getClassLoader();
        URLClassLoader ucl = this.classLoaders.get(sp.getID());
        if (ucl == null) {
            Hashtable<String, URLClassLoader> hashtable = this.classLoaders;
            synchronized (hashtable) {
                ucl = new PDIClassLoader(urls, classLoader);
                this.classLoaders.put((String)sp.getID(), ucl);
            }
        }
        return ucl;
    }

    public int nrJobEntriesWithType(int type) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            ++nr;
        }
        return nr;
    }

    public JobPlugin getJobEntryWithType(int type, int index) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            if (nr == index) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public JobPlugin findJobPluginWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (!((String)sp.getID()).equalsIgnoreCase(stepid)) continue;
            return sp;
        }
        return null;
    }

    public JobPlugin[] getJobEntriesWithType(int type) {
        int nr = this.nrJobEntriesWithType(type);
        JobPlugin[] steps = new JobPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            JobPlugin sp;
            steps[i] = sp = this.getJobEntryWithType(type, i);
        }
        return steps;
    }

    public JobPlugin findJobEntriesWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (!((String)sp.getID()).equalsIgnoreCase(stepid)) continue;
            return sp;
        }
        return null;
    }

    public JobPlugin findJobEntriesWithClassName(String cn) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (!sp.getClassname().equalsIgnoreCase(cn)) continue;
            return sp;
        }
        return null;
    }

    public JobPlugin findJobEntriesWithDescription(String description) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = this.pluginList.get(i);
            if (!sp.getDescription().equalsIgnoreCase(description) && !((String)sp.getID()).equalsIgnoreCase(description)) continue;
            return sp;
        }
        return null;
    }

    public String getJobEntryID(JobEntryInterface jei) {
        for (int i = 0; i < this.nrJobEntriesWithType(0); ++i) {
            JobPlugin sp = this.getJobEntryWithType(0, i);
            if (!jei.getClass().getName().equals(sp.getClassname())) continue;
            return (String)sp.getID();
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public InputStream getInputStreamForFile(String filename) {
        JobPlugin[] jobplugins;
        for (JobPlugin jobPlugin : jobplugins = this.getJobEntriesWithType(2)) {
            try {
                String[] jarfiles = jobPlugin.getJarfiles();
                if (jarfiles == null) continue;
                for (int j = 0; j < jarfiles.length; ++j) {
                    InputStream inputStream;
                    JarFile jarFile = new JarFile(jarfiles[j]);
                    JarEntry jarEntry = filename.startsWith("/") ? jarFile.getJarEntry(filename.substring(1)) : jarFile.getJarEntry(filename);
                    if (jarEntry == null || (inputStream = jarFile.getInputStream(jarEntry)) == null) continue;
                    return inputStream;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public String[] getPluginPackages() {
        ArrayList<String> list = new ArrayList<String>();
        for (JobPlugin stepPlugin : this.pluginList) {
            int lastIndex;
            String className = stepPlugin.getClassname();
            String packageName = className.substring(0, lastIndex = className.lastIndexOf("."));
            if (list.contains(packageName)) continue;
            list.add(packageName);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public String[] getCategories(int type) {
        return this.getCategories(type, LanguageChoice.getInstance().getDefaultLocale().toString().toLowerCase());
    }

    public String[] getCategories(int type, String locale) {
        Hashtable<String, String> cat = new Hashtable<String, String>();
        for (int i = 0; i < this.nrJobEntriesWithType(type); ++i) {
            JobPlugin sp = this.getJobEntryWithType(type, i);
            if (sp == null) continue;
            cat.put(sp.getCategory(locale), sp.getCategory(locale));
        }
        Enumeration keys = cat.keys();
        String[] retval = new String[cat.size()];
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = (String)keys.nextElement();
            ++i;
        }
        for (int a = 0; a < retval.length; ++a) {
            for (int b = 0; b < retval.length - 1; ++b) {
                int idx2;
                int idx1 = Const.indexOfString((String)retval[b], (String[])JobEntryBase.category_order);
                if (idx1 <= (idx2 = Const.indexOfString((String)retval[b + 1], (String[])JobEntryBase.category_order))) continue;
                String dummy = retval[b];
                retval[b] = retval[b + 1];
                retval[b + 1] = dummy;
            }
        }
        return retval;
    }

    public List<Object[]> getPluginInformation() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (JobPlugin plugin : this.pluginList) {
            list.add(plugin.getPluginInformation());
        }
        return list;
    }
}

