/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CertificateStatusRequestExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.CertificateStatusRequestExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.CertificateStatusRequestExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusRequestExtensionHandler
extends ExtensionHandler<CertificateStatusRequestExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateStatusRequestExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public CertificateStatusRequestExtensionParser getParser(byte[] message, int pointer) {
        return new CertificateStatusRequestExtensionParser(pointer, message);
    }

    public CertificateStatusRequestExtensionPreparator getPreparator(CertificateStatusRequestExtensionMessage message) {
        return new CertificateStatusRequestExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public CertificateStatusRequestExtensionSerializer getSerializer(CertificateStatusRequestExtensionMessage message) {
        return new CertificateStatusRequestExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(CertificateStatusRequestExtensionMessage message) {
        if (this.context.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.context.setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType.getCertificateStatusRequestType((Integer)message.getCertificateStatusRequestType().getValue()));
            LOGGER.debug("Adjusted the Certificate Status Request Type in the TLSContext to " + (Object)((Object)this.context.getCertificateStatusRequestExtensionRequestType()));
            this.context.setCertificateStatusRequestExtensionRequestExtension((byte[])message.getRequestExtension().getValue());
            LOGGER.debug("Adjusted the Certificate Status Request Request Extension to " + ArrayConverter.bytesToHexString((byte[])this.context.getCertificateStatusRequestExtensionRequestExtension()));
            this.context.setCertificateStatusRequestExtensionResponderIDList((byte[])message.getResponderIDList().getValue());
            LOGGER.debug("Adjusted the Certificate Status Request Responder ID List to " + ArrayConverter.bytesToHexString((byte[])this.context.getCertificateStatusRequestExtensionResponderIDList()));
        }
    }
}

