/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.security.RuleBasedAuthorizationPlugin;
import org.apache.solr.security.hadoop.RequestContinuesRecorderAuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosFilter
extends AuthenticationFilter {
    private final CoreContainer coreContainer;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public KerberosFilter(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public void init(FilterConfig conf) throws ServletException {
        super.init(conf);
    }

    protected void initializeAuthHandler(String authHandlerClassName, FilterConfig filterConfig) throws ServletException {
        super.initializeAuthHandler(authHandlerClassName, filterConfig);
        AuthenticationHandler authHandler = this.getAuthenticationHandler();
        super.initializeAuthHandler(RequestContinuesRecorderAuthenticationHandler.class.getName(), filterConfig);
        RequestContinuesRecorderAuthenticationHandler newAuthHandler = (RequestContinuesRecorderAuthenticationHandler)this.getAuthenticationHandler();
        newAuthHandler.setAuthHandler(authHandler);
    }

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request = this.substituteOriginalUserRequest(request);
        super.doFilter(filterChain, request, response);
    }

    private HttpServletRequest substituteOriginalUserRequest(HttpServletRequest request) {
        final HttpServletRequest originalRequest = request;
        AuthorizationPlugin authzPlugin = this.coreContainer.getAuthorizationPlugin();
        if (authzPlugin instanceof RuleBasedAuthorizationPlugin) {
            RuleBasedAuthorizationPlugin ruleBased = (RuleBasedAuthorizationPlugin)authzPlugin;
            if (request.getHeader("originalUserPrincipal") != null && ruleBased.doesUserHavePermission(request.getUserPrincipal(), PermissionNameProvider.Name.ALL)) {
                request = new HttpServletRequestWrapper((HttpServletRequest)request){

                    public Principal getUserPrincipal() {
                        final String originalUserPrincipal = originalRequest.getHeader("originalUserPrincipal");
                        if (log.isInfoEnabled()) {
                            log.info("Substituting user principal from {} to {}.", (Object)originalRequest.getUserPrincipal(), (Object)originalUserPrincipal);
                        }
                        return new Principal(){

                            @Override
                            public String getName() {
                                return originalUserPrincipal;
                            }

                            @Override
                            public String toString() {
                                return originalUserPrincipal;
                            }
                        };
                    }
                };
            }
        }
        return request;
    }
}

