/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.rest;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.transport.LTRStatsAction;
import org.opensearch.ltr.transport.LTRStatsRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;

public class RestStatsLTRAction
extends BaseRestHandler {
    private static final String NAME = "learning_to_rank_stats";
    private final LTRStats ltrStats;

    public RestStatsLTRAction(LTRStats ltrStats) {
        this.ltrStats = ltrStats;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_plugins/_ltr", "/{nodeId}/stats/"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_opendistro/_ltr", "/{nodeId}/stats/")), new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_plugins/_ltr", "/{nodeId}/stats/{stat}"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_opendistro/_ltr", "/{nodeId}/stats/{stat}")), new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_plugins/_ltr", "/stats/"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_opendistro/_ltr", "/stats/")), new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_plugins/_ltr", "/stats/{stat}"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s%s", "/_opendistro/_ltr", "/stats/{stat}")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        LTRStatsRequest ltrStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)LTRStatsAction.INSTANCE, (ActionRequest)ltrStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private LTRStatsRequest getRequest(RestRequest request) {
        LTRStatsRequest ltrStatsRequest = new LTRStatsRequest(this.splitCommaSeparatedParam(request, "nodeId"));
        ltrStatsRequest.timeout(request.param("timeout"));
        List<String> requestedStats = List.of(this.splitCommaSeparatedParam(request, "stat"));
        Set<String> validStats = this.ltrStats.getStats().keySet();
        if (this.isAllStatsRequested(requestedStats)) {
            ltrStatsRequest.addAll(validStats);
        } else {
            ltrStatsRequest.addAll(this.getStatsToBeRetrieved(request, validStats, requestedStats));
        }
        return ltrStatsRequest;
    }

    private Set<String> getStatsToBeRetrieved(RestRequest request, Set<String> validStats, List<String> requestedStats) {
        if (requestedStats.contains("_all")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Request %s contains both %s and individual stats", request.path(), "_all"));
        }
        Set invalidStats = requestedStats.stream().filter(s -> !validStats.contains(s)).collect(Collectors.toSet());
        if (!invalidStats.isEmpty()) {
            throw new IllegalArgumentException(this.unrecognized(request, invalidStats, new HashSet<String>(requestedStats), "stat"));
        }
        return new HashSet<String>(requestedStats);
    }

    private boolean isAllStatsRequested(List<String> requestedStats) {
        return requestedStats.isEmpty() || requestedStats.size() == 1 && requestedStats.contains("_all");
    }

    private String[] splitCommaSeparatedParam(RestRequest request, String paramName) {
        String param = request.param(paramName);
        if (param == null) {
            return new String[0];
        }
        return param.split(",");
    }
}

