/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.LtrQueryContext;
import com.o19s.es.ltr.feature.Feature;
import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.feature.store.PrecompiledExpressionFeature;
import com.o19s.es.ltr.feature.store.PrecompiledTemplateFeature;
import com.o19s.es.ltr.feature.store.ScriptFeature;
import com.o19s.es.ltr.feature.store.StorableElement;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.ScriptQueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;

public class StoredFeature
implements Feature,
Accountable,
StorableElement {
    private static final long BASE_RAM_USED = RamUsageEstimator.shallowSizeOfInstance(StoredFeature.class);
    private static final String DEFAULT_TEMPLATE_LANGUAGE = "mustache";
    public static final String TYPE = "feature";
    private final String name;
    private final List<String> queryParams;
    private final String templateLanguage;
    private final String template;
    private final boolean templateAsString;
    private static final ObjectParser<ParsingState, Void> PARSER;
    private static final ParseField NAME;
    private static final ParseField PARAMS;
    private static final ParseField TEMPLATE_LANGUAGE;
    public static final ParseField TEMPLATE;

    public StoredFeature(String name, List<String> params, String templateLanguage, String template, boolean storedAsString) {
        this.name = Objects.requireNonNull(name);
        this.queryParams = Objects.requireNonNull(params);
        this.templateLanguage = Objects.requireNonNull(templateLanguage);
        this.template = Objects.requireNonNull(template);
        this.templateAsString = storedAsString;
    }

    public StoredFeature(StreamInput input) throws IOException {
        this.name = input.readString();
        this.queryParams = input.readList(StreamInput::readString);
        this.templateLanguage = input.readString();
        this.template = input.readString();
        this.templateAsString = input.readBoolean();
    }

    public StoredFeature(String name, List<String> params, String templateLanguage, String template) {
        this(name, params, templateLanguage, template, true);
    }

    public StoredFeature(String name, List<String> params, String templateLanguage, XContentBuilder template) {
        this(name, params, templateLanguage, Objects.requireNonNull(template).toString(), false);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.queryParams);
        out.writeString(this.templateLanguage);
        out.writeString(this.template);
        out.writeBoolean(this.templateAsString);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field(PARAMS.getPreferredName(), this.queryParams);
        builder.field(TEMPLATE_LANGUAGE.getPreferredName(), this.templateLanguage);
        if (this.templateAsString) {
            builder.field(TEMPLATE.getPreferredName(), this.template);
        } else {
            builder.field(TEMPLATE.getPreferredName());
            XContentParser parser = MediaTypeRegistry.xContent((CharSequence)this.template).xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.template);
            builder.copyCurrentStructure(parser);
        }
        builder.endObject();
        return builder;
    }

    public static StoredFeature parse(XContentParser parser) {
        return StoredFeature.parse(parser, null);
    }

    public static StoredFeature parse(XContentParser parser, String name) {
        try {
            ParsingState state = (ParsingState)PARSER.apply(parser, null);
            state.resolveName(parser, name);
            if (state.queryParams == null) {
                state.queryParams = Collections.emptyList();
            }
            if (state.template == null) {
                throw new ParsingException(parser.getTokenLocation(), "Field [template] is mandatory", new Object[0]);
            }
            if (state.template instanceof String) {
                return new StoredFeature(state.getName(), Collections.unmodifiableList(state.queryParams), state.templateLanguage, (String)state.template);
            }
            assert (state.template instanceof XContentBuilder);
            return new StoredFeature(state.getName(), Collections.unmodifiableList(state.queryParams), state.templateLanguage, (XContentBuilder)state.template);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
    }

    @Override
    public Feature optimize() {
        switch (this.templateLanguage) {
            case "mustache": {
                return PrecompiledTemplateFeature.compile(this);
            }
            case "derived_expression": {
                return PrecompiledExpressionFeature.compile(this);
            }
            case "script_feature": {
                return ScriptFeature.compile(this);
            }
        }
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public Query doToQuery(LtrQueryContext context, FeatureSet set, Map<String, Object> params) {
        List missingParams = this.queryParams.stream().filter(x -> !params.containsKey(x)).collect(Collectors.toList());
        if (!missingParams.isEmpty()) {
            String names = missingParams.stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("Missing required param(s): [" + names + "]");
        }
        assert (!DEFAULT_TEMPLATE_LANGUAGE.equals(this.templateLanguage));
        ScriptQueryBuilder builder = new ScriptQueryBuilder(new Script(ScriptType.INLINE, this.templateLanguage, this.template, params));
        try {
            return builder.toQuery(context.getQueryShardContext());
        }
        catch (IOException | IllegalArgumentException | ParsingException e) {
            throw new QueryShardException(context.getQueryShardContext(), "Cannot create query while parsing feature [" + this.name + "]", e, new Object[0]);
        }
    }

    private XContentParser createParser(Object source, NamedXContentRegistry registry) throws IOException {
        if (source instanceof String) {
            return MediaTypeRegistry.xContent((CharSequence)((String)source)).xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (String)source);
        }
        if (source instanceof BytesReference) {
            BytesRef ref = ((BytesReference)source).toBytesRef();
            return MediaTypeRegistry.xContent((byte[])ref.bytes, (int)ref.offset, (int)ref.length).xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, ref.bytes, ref.offset, ref.length);
        }
        if (source instanceof byte[]) {
            return MediaTypeRegistry.xContent((byte[])((byte[])source)).xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (byte[])source);
        }
        throw new IllegalArgumentException("Template engine returned an unsupported object type [" + source.getClass().getCanonicalName() + "]");
    }

    Collection<String> queryParams() {
        return this.queryParams;
    }

    String templateLanguage() {
        return this.templateLanguage;
    }

    String template() {
        return this.template;
    }

    boolean templateAsString() {
        return this.templateAsString;
    }

    public long ramBytesUsed() {
        return BASE_RAM_USED + (long)(2 * this.name.length()) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.queryParams.stream().mapToLong(x -> 2 * x.length() + RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER).sum() + (long)(2 * this.templateLanguage.length()) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)(2 * this.template.length()) + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoredFeature)) {
            return false;
        }
        StoredFeature feature = (StoredFeature)o;
        if (this.templateAsString != feature.templateAsString) {
            return false;
        }
        if (!this.name.equals(feature.name)) {
            return false;
        }
        if (!this.queryParams.equals(feature.queryParams)) {
            return false;
        }
        if (!this.templateLanguage.equals(feature.templateLanguage)) {
            return false;
        }
        return this.template.equals(feature.template);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.queryParams.hashCode();
        result = 31 * result + this.templateLanguage.hashCode();
        result = 31 * result + this.template.hashCode();
        result = 31 * result + (this.templateAsString ? 1 : 0);
        return result;
    }

    static {
        NAME = new ParseField("name", new String[0]);
        PARAMS = new ParseField("params", new String[0]);
        TEMPLATE_LANGUAGE = new ParseField("template_language", new String[0]);
        TEMPLATE = new ParseField("template", new String[0]);
        PARSER = new ObjectParser(TYPE, () -> new ParsingState());
        PARSER.declareString(StorableElement.StorableElementParserState::setName, NAME);
        PARSER.declareStringArray(ParsingState::setQueryParams, PARAMS);
        PARSER.declareString(ParsingState::setTemplateLanguage, TEMPLATE_LANGUAGE);
        PARSER.declareField(ParsingState::setTemplate, (parser, value) -> {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentBuilder xContentBuilder;
                block9: {
                    XContentBuilder builder = XContentType.JSON.contentBuilder();
                    try {
                        xContentBuilder = builder.copyCurrentStructure(parser);
                        if (builder == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (builder != null) {
                                try {
                                    builder.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new ParsingException(parser.getTokenLocation(), "Could not parse inline template", (Throwable)e, new Object[0]);
                        }
                    }
                    builder.close();
                }
                return xContentBuilder;
            }
            return parser.text();
        }, TEMPLATE, ObjectParser.ValueType.OBJECT_OR_STRING);
    }

    private static class ParsingState
    extends StorableElement.StorableElementParserState {
        private List<String> queryParams;
        private String templateLanguage = "mustache";
        private Object template;

        private ParsingState() {
        }

        void setQueryParams(List<String> queryParams) {
            this.queryParams = queryParams;
        }

        void setTemplateLanguage(String templateLanguage) {
            this.templateLanguage = templateLanguage;
        }

        void setTemplate(Object template) {
            assert (template instanceof String || template instanceof XContentBuilder);
            this.template = template;
        }
    }
}

