/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.ClearCachesAction;
import com.o19s.es.ltr.feature.store.index.Caches;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeRequest;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClearCachesAction
extends TransportNodesAction<ClearCachesAction.ClearCachesNodesRequest, ClearCachesAction.ClearCachesNodesResponse, ClearCachesNodeRequest, ClearCachesAction.ClearCachesNodeResponse> {
    private final Caches caches;

    @Inject
    public TransportClearCachesAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Caches caches) {
        super("cluster:admin/ltr/caches", threadPool, clusterService, transportService, actionFilters, ClearCachesAction.ClearCachesNodesRequest::new, ClearCachesNodeRequest::new, "management", ClearCachesAction.ClearCachesNodeResponse.class);
        this.caches = caches;
    }

    protected ClearCachesAction.ClearCachesNodesResponse newResponse(ClearCachesAction.ClearCachesNodesRequest request, List<ClearCachesAction.ClearCachesNodeResponse> responses, List<FailedNodeException> failures) {
        return new ClearCachesAction.ClearCachesNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ClearCachesNodeRequest newNodeRequest(ClearCachesAction.ClearCachesNodesRequest request) {
        return new ClearCachesNodeRequest(request);
    }

    protected ClearCachesAction.ClearCachesNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return null;
    }

    protected ClearCachesAction.ClearCachesNodeResponse nodeOperation(ClearCachesNodeRequest request) {
        ClearCachesAction.ClearCachesNodesRequest r = request.request;
        switch (r.getOperation()) {
            case ClearStore: {
                this.caches.evict(r.getStore());
                break;
            }
            case ClearFeature: {
                this.caches.evictFeature(r.getStore(), r.getName());
                break;
            }
            case ClearFeatureSet: {
                this.caches.evictFeatureSet(r.getStore(), r.getName());
                break;
            }
            case ClearModel: {
                this.caches.evictModel(r.getStore(), r.getName());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported operation [" + String.valueOf((Object)r.getOperation()) + "]");
            }
        }
        return new ClearCachesAction.ClearCachesNodeResponse(this.clusterService.localNode());
    }

    public static class ClearCachesNodeRequest
    extends BaseNodeRequest {
        private ClearCachesAction.ClearCachesNodesRequest request;

        public ClearCachesNodeRequest() {
        }

        public ClearCachesNodeRequest(ClearCachesAction.ClearCachesNodesRequest req) {
            this.request = req;
        }

        ClearCachesNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClearCachesAction.ClearCachesNodesRequest(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

