/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.feature.store.index.Caches;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class CachesStatsAction
extends ActionType<CachesStatsNodesResponse> {
    public static final String NAME = "cluster:admin/ltr/caches/stats";
    public static final CachesStatsAction INSTANCE = new CachesStatsAction();

    protected CachesStatsAction() {
        super(NAME, CachesStatsNodesResponse::new);
    }

    public static class CachesStatsActionBuilder
    extends ActionRequestBuilder<CachesStatsNodesRequest, CachesStatsNodesResponse> {
        public CachesStatsActionBuilder(OpenSearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new CachesStatsNodesRequest());
        }
    }

    public static class StatDetails
    implements Writeable,
    ToXContent {
        private Stat total;
        private Stat features;
        private Stat featuresets;
        private Stat models;

        StatDetails() {
            this.empty();
        }

        public StatDetails(Caches.PerStoreStats stats) {
            this.total = new Stat(stats.totalRam(), stats.totalCount());
            this.features = new Stat(stats.featureRam(), stats.featureCount());
            this.featuresets = new Stat(stats.featureSetRam(), stats.featureSetCount());
            this.models = new Stat(stats.modelRam(), stats.modelCount());
        }

        StatDetails(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        public void readFrom(StreamInput in) throws IOException {
            this.total = new Stat(in);
            this.features = new Stat(in);
            this.featuresets = new Stat(in);
            this.models = new Stat(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.total.writeTo(out);
            this.features.writeTo(out);
            this.featuresets.writeTo(out);
            this.models.writeTo(out);
        }

        public void empty() {
            this.total = new Stat(0L, 0);
            this.features = new Stat(0L, 0);
            this.featuresets = new Stat(0L, 0);
            this.models = new Stat(0L, 0);
        }

        public static StatDetails sum(StatDetails one, StatDetails two) {
            if (one != null && two != null) {
                one.doSum(two);
                return one;
            }
            if (one != null) {
                return one;
            }
            if (two != null) {
                return two;
            }
            return null;
        }

        public void doSum(StatDetails other) {
            this.total.sum(other.total);
            this.features.sum(other.features);
            this.featuresets.sum(other.featuresets);
            this.models.sum(other.models);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("total", (ToXContent)this.total).field("features", (ToXContent)this.features).field("featuresets", (ToXContent)this.featuresets).field("models", (ToXContent)this.models).endObject();
        }

        public Stat getTotal() {
            return this.total;
        }

        public Stat getFeatures() {
            return this.features;
        }

        public Stat getFeaturesets() {
            return this.featuresets;
        }

        public Stat getModels() {
            return this.models;
        }

        public static class Stat
        implements Writeable,
        ToXContent {
            private long ram;
            private int count;

            public Stat(StreamInput in) throws IOException {
                this.ram = in.readVLong();
                this.count = in.readVInt();
            }

            public Stat(long ram, int count) {
                this.ram = ram;
                this.count = count;
            }

            public void sum(Stat other) {
                this.ram += other.ram;
                this.count += other.count;
            }

            public long getRam() {
                return this.ram;
            }

            public int getCount() {
                return this.count;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeVLong(this.ram);
                out.writeVInt(this.count);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.startObject().field("ram", this.ram).field("count", this.count).endObject();
            }
        }
    }

    public static class CachesStatsNodeResponse
    extends BaseNodeResponse {
        private StatDetails allStores;
        private Map<String, StatDetails> byStore;

        CachesStatsNodeResponse(DiscoveryNode node) {
            super(node);
            this.empty();
        }

        CachesStatsNodeResponse(StreamInput in) throws IOException {
            super(in);
            this.allStores = new StatDetails(in);
            this.byStore = in.readMap(StreamInput::readString, StatDetails::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.allStores.writeTo(out);
            out.writeMap(this.byStore, StreamOutput::writeString, (o, s) -> s.writeTo(o));
        }

        public void empty() {
            this.allStores = new StatDetails();
            this.byStore = new HashMap<String, StatDetails>();
        }

        public CachesStatsNodeResponse initFromCaches(Caches caches) {
            this.allStores = new StatDetails();
            this.byStore = new HashMap<String, StatDetails>();
            caches.perStoreStatsStream().forEach(en -> {
                StatDetails details = new StatDetails((Caches.PerStoreStats)en.getValue());
                this.allStores.doSum(details);
                this.byStore.compute((String)en.getKey(), (k, v) -> StatDetails.sum(v, details));
            });
            return this;
        }

        public StatDetails getAllStores() {
            return this.allStores;
        }
    }

    public static class CachesStatsNodesResponse
    extends BaseNodesResponse<CachesStatsNodeResponse>
    implements ToXContent {
        private StatDetails allStores;
        private Map<String, StatDetails> byStore;

        public CachesStatsNodesResponse(StreamInput in) throws IOException {
            super(in);
            this.allStores = new StatDetails(in);
            this.byStore = in.readMap(StreamInput::readString, StatDetails::new);
        }

        public CachesStatsNodesResponse(ClusterName clusterName, List<CachesStatsNodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
            this.allStores = new StatDetails();
            this.byStore = new HashMap<String, StatDetails>();
            nodes.forEach(n -> {
                this.allStores.doSum(n.allStores);
                n.byStore.forEach((k, v) -> this.byStore.merge((String)k, (StatDetails)v, StatDetails::sum));
            });
        }

        protected List<CachesStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(CachesStatsNodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<CachesStatsNodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.allStores.writeTo(out);
            out.writeMap(this.byStore, StreamOutput::writeString, (o, s) -> s.writeTo(o));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("all", (ToXContent)this.allStores);
            builder.startObject("stores");
            for (Map.Entry<String, StatDetails> entry : this.byStore.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
            builder.startObject("nodes");
            for (CachesStatsNodeResponse resp : super.getNodes()) {
                builder.startObject(resp.getNode().getId());
                builder.field("name", resp.getNode().getName());
                builder.field("hostname", resp.getNode().getHostName());
                builder.field("stats", (ToXContent)resp.allStores);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public StatDetails getAll() {
            return this.allStores;
        }
    }

    public static class CachesStatsNodesRequest
    extends BaseNodesRequest<CachesStatsNodesRequest> {
        public CachesStatsNodesRequest(StreamInput in) throws IOException {
            super(in);
        }

        public CachesStatsNodesRequest() {
            super((String[])null);
        }
    }
}

