/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class ListOffsetsApplicationEvent
extends CompletableApplicationEvent<Map<TopicPartition, OffsetAndTimestamp>> {
    private final Map<TopicPartition, Long> timestampsToSearch;
    private final boolean requireTimestamps;

    public ListOffsetsApplicationEvent(Map<TopicPartition, Long> timestampToSearch, boolean requireTimestamps) {
        super(ApplicationEvent.Type.LIST_OFFSETS);
        this.timestampsToSearch = Collections.unmodifiableMap(timestampToSearch);
        this.requireTimestamps = requireTimestamps;
    }

    public Map<TopicPartition, OffsetAndTimestamp> emptyResult() {
        HashMap<TopicPartition, OffsetAndTimestamp> offsetsByTimes = new HashMap<TopicPartition, OffsetAndTimestamp>(this.timestampsToSearch.size());
        for (Map.Entry<TopicPartition, Long> entry : this.timestampsToSearch.entrySet()) {
            offsetsByTimes.put(entry.getKey(), null);
        }
        return offsetsByTimes;
    }

    public Map<TopicPartition, Long> timestampsToSearch() {
        return this.timestampsToSearch;
    }

    public boolean requireTimestamps() {
        return this.requireTimestamps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListOffsetsApplicationEvent that = (ListOffsetsApplicationEvent)o;
        if (this.requireTimestamps != that.requireTimestamps) {
            return false;
        }
        return this.timestampsToSearch.equals(that.timestampsToSearch);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.timestampsToSearch.hashCode();
        result = 31 * result + (this.requireTimestamps ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.toStringBase() + ", timestampsToSearch=" + this.timestampsToSearch + ", requireTimestamps=" + this.requireTimestamps + '}';
    }
}

