/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.modifiers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.securityanalytics.rules.exceptions.SigmaModifierError;
import org.opensearch.securityanalytics.rules.modifiers.SigmaAllModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaBase64Modifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaBase64OffsetModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaCIDRModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaContainsModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaEndswithModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaGreaterThanEqualModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaGreaterThanModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaLessThanEqualModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaLessThanModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaRegularExpressionModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaStartswithModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaWideModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaWindowsDashModifier;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;

public class SigmaModifierFacade {
    private Map<String, Class<? extends SigmaModifier>> modifierMap = new HashMap<String, Class<? extends SigmaModifier>>();
    private static SigmaModifierFacade modifierFacade;

    public SigmaModifierFacade() {
        this.modifierMap.put("contains", SigmaContainsModifier.class);
        this.modifierMap.put("startswith", SigmaStartswithModifier.class);
        this.modifierMap.put("endswith", SigmaEndswithModifier.class);
        this.modifierMap.put("base64", SigmaBase64Modifier.class);
        this.modifierMap.put("base64offset", SigmaBase64OffsetModifier.class);
        this.modifierMap.put("wide", SigmaWideModifier.class);
        this.modifierMap.put("windash", SigmaWindowsDashModifier.class);
        this.modifierMap.put("re", SigmaRegularExpressionModifier.class);
        this.modifierMap.put("cidr", SigmaCIDRModifier.class);
        this.modifierMap.put("all", SigmaAllModifier.class);
        this.modifierMap.put("lt", SigmaLessThanModifier.class);
        this.modifierMap.put("lte", SigmaLessThanEqualModifier.class);
        this.modifierMap.put("gt", SigmaGreaterThanModifier.class);
        this.modifierMap.put("gte", SigmaGreaterThanEqualModifier.class);
    }

    public static SigmaModifier sigmaModifier(Class<? extends SigmaModifier> clazz, SigmaDetectionItem detectionItem, List<Class<? extends SigmaModifier>> appliedModifiers) throws SigmaModifierError {
        if (modifierFacade == null) {
            modifierFacade = new SigmaModifierFacade();
        }
        if (clazz.equals(SigmaContainsModifier.class)) {
            return new SigmaContainsModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaStartswithModifier.class)) {
            return new SigmaStartswithModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaEndswithModifier.class)) {
            return new SigmaEndswithModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaBase64Modifier.class)) {
            return new SigmaBase64Modifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaBase64OffsetModifier.class)) {
            return new SigmaBase64OffsetModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaWideModifier.class)) {
            return new SigmaWideModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaWindowsDashModifier.class)) {
            return new SigmaWindowsDashModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaRegularExpressionModifier.class)) {
            return new SigmaRegularExpressionModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaCIDRModifier.class)) {
            return new SigmaCIDRModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaAllModifier.class)) {
            return new SigmaAllModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaLessThanModifier.class)) {
            return new SigmaLessThanModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaLessThanEqualModifier.class)) {
            return new SigmaLessThanEqualModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaGreaterThanModifier.class)) {
            return new SigmaGreaterThanModifier(detectionItem, appliedModifiers);
        }
        if (clazz.equals(SigmaGreaterThanEqualModifier.class)) {
            return new SigmaGreaterThanEqualModifier(detectionItem, appliedModifiers);
        }
        throw new SigmaModifierError("modifier not found-" + clazz.getName());
    }

    public static Map<String, String> reverseModifierMapping() {
        if (modifierFacade == null) {
            modifierFacade = new SigmaModifierFacade();
        }
        HashMap<String, String> reverseModifierMap = new HashMap<String, String>();
        for (Map.Entry<String, Class<? extends SigmaModifier>> modifier : SigmaModifierFacade.modifierFacade.modifierMap.entrySet()) {
            reverseModifierMap.put(modifier.getValue().getName(), modifier.getKey());
        }
        return reverseModifierMap;
    }

    public static Class<? extends SigmaModifier> getModifier(String modifier) {
        if (modifierFacade == null) {
            modifierFacade = new SigmaModifierFacade();
        }
        return SigmaModifierFacade.modifierFacade.modifierMap.get(modifier);
    }
}

