/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model.threatintel;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.threatintel.BaseEntity;
import org.opensearch.securityanalytics.util.XContentUtils;

public class ThreatIntelAlert
extends BaseEntity {
    public static final String ALERT_ID_FIELD = "id";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final String ALERT_VERSION_FIELD = "version";
    public static final String USER_FIELD = "user";
    public static final String TRIGGER_NAME_FIELD = "trigger_name";
    public static final String TRIGGER_ID_FIELD = "trigger_id";
    public static final String MONITOR_ID_FIELD = "monitor_id";
    public static final String MONITOR_NAME_FIELD = "monitor_name";
    public static final String STATE_FIELD = "state";
    public static final String START_TIME_FIELD = "start_time";
    public static final String END_TIME_FIELD = "end_time";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    public static final String ERROR_MESSAGE_FIELD = "error_message";
    public static final String SEVERITY_FIELD = "severity";
    public static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    public static final String IOC_VALUE_FIELD = "ioc_value";
    public static final String IOC_TYPE_FIELD = "ioc_type";
    public static final String FINDING_IDS_FIELD = "finding_ids";
    public static final String SEQ_NO_FIELD = "seq_no";
    public static final String PRIMARY_TERM_FIELD = "primary_term";
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    public static final long NO_SCHEMA_VERSION = 0L;
    private final String id;
    private final long version;
    private final long schemaVersion;
    private final long seqNo;
    private final long primaryTerm;
    private final User user;
    private final String triggerName;
    private final String triggerId;
    private final String monitorId;
    private final String monitorName;
    private final Alert.State state;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant acknowledgedTime;
    private final Instant lastUpdatedTime;
    private final String errorMessage;
    private final String severity;
    private final String iocValue;
    private final String iocType;
    private final List<ActionExecutionResult> actionExecutionResults;
    private List<String> findingIds;

    public ThreatIntelAlert(String id, long version, long schemaVersion, User user, String triggerId, String triggerName, String monitorId, String monitorName, Alert.State state, Instant startTime, Instant endTime, Instant lastUpdatedTime, Instant acknowledgedTime, String errorMessage, String severity, String iocValue, String iocType, List<ActionExecutionResult> actionExecutionResults, List<String> findingIds) {
        this.id = id != null ? id : NO_ID;
        this.version = version != 0L ? version : 1L;
        this.schemaVersion = schemaVersion;
        this.seqNo = -2L;
        this.primaryTerm = 0L;
        this.user = user;
        this.triggerId = triggerId;
        this.triggerName = triggerName;
        this.monitorId = monitorId;
        this.monitorName = monitorName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.iocValue = iocValue;
        this.iocType = iocType;
        this.actionExecutionResults = actionExecutionResults;
        this.lastUpdatedTime = lastUpdatedTime;
        this.findingIds = findingIds;
    }

    public ThreatIntelAlert(String id, long version, long schemaVersion, long seqNo, long primaryTerm, User user, String triggerId, String triggerName, String monitorId, String monitorName, Alert.State state, Instant startTime, Instant endTime, Instant lastUpdatedTime, Instant acknowledgedTime, String errorMessage, String severity, String iocValue, String iocType, List<ActionExecutionResult> actionExecutionResults, List<String> findingIds) {
        this.id = id != null ? id : NO_ID;
        this.version = version != 0L ? version : 1L;
        this.schemaVersion = schemaVersion;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.user = user;
        this.triggerId = triggerId;
        this.triggerName = triggerName;
        this.monitorId = monitorId;
        this.monitorName = monitorName;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.iocValue = iocValue;
        this.iocType = iocType;
        this.actionExecutionResults = actionExecutionResults;
        this.lastUpdatedTime = lastUpdatedTime;
        this.findingIds = findingIds;
    }

    public ThreatIntelAlert(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.version = sin.readLong();
        this.schemaVersion = sin.readLong();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.user = sin.readBoolean() ? new User(sin) : null;
        this.triggerId = sin.readString();
        this.triggerName = sin.readString();
        this.monitorId = sin.readString();
        this.monitorName = sin.readString();
        this.state = (Alert.State)sin.readEnum(Alert.State.class);
        this.startTime = sin.readInstant();
        this.endTime = sin.readOptionalInstant();
        this.acknowledgedTime = sin.readOptionalInstant();
        this.errorMessage = sin.readOptionalString();
        this.severity = sin.readString();
        this.actionExecutionResults = sin.readList(ActionExecutionResult::new);
        this.lastUpdatedTime = sin.readOptionalInstant();
        this.iocType = sin.readString();
        this.iocValue = sin.readString();
        this.findingIds = sin.readStringList();
    }

    public ThreatIntelAlert(ThreatIntelAlert currentAlert, List<String> findingIds) {
        this.findingIds = findingIds;
        this.id = currentAlert.id;
        this.version = currentAlert.version;
        this.schemaVersion = currentAlert.schemaVersion;
        this.seqNo = currentAlert.seqNo;
        this.primaryTerm = currentAlert.primaryTerm;
        this.user = currentAlert.user;
        this.triggerId = currentAlert.triggerId;
        this.triggerName = currentAlert.triggerName;
        this.monitorId = currentAlert.monitorId;
        this.monitorName = currentAlert.monitorName;
        this.state = currentAlert.state;
        this.startTime = currentAlert.startTime;
        this.endTime = currentAlert.endTime;
        this.acknowledgedTime = currentAlert.acknowledgedTime;
        this.errorMessage = currentAlert.errorMessage;
        this.severity = currentAlert.severity;
        this.iocValue = currentAlert.iocValue;
        this.iocType = currentAlert.iocType;
        this.actionExecutionResults = currentAlert.actionExecutionResults;
        this.lastUpdatedTime = Instant.now();
    }

    public static ThreatIntelAlert updateStatus(ThreatIntelAlert currentAlert, Alert.State newState) {
        return new ThreatIntelAlert(currentAlert.id, currentAlert.version, currentAlert.schemaVersion, currentAlert.seqNo, currentAlert.primaryTerm, currentAlert.user, currentAlert.triggerId, currentAlert.triggerName, currentAlert.monitorId, currentAlert.monitorName, newState, currentAlert.startTime, newState.equals((Object)Alert.State.COMPLETED) ? Instant.now() : currentAlert.endTime, Instant.now(), newState.equals((Object)Alert.State.ACKNOWLEDGED) ? Instant.now() : currentAlert.endTime, currentAlert.errorMessage, currentAlert.severity, currentAlert.iocValue, currentAlert.iocType, currentAlert.actionExecutionResults, currentAlert.getFindingIds());
    }

    public boolean isAcknowledged() {
        return this.state == Alert.State.ACKNOWLEDGED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeLong(this.schemaVersion);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
        out.writeString(this.triggerId);
        out.writeString(this.triggerName);
        out.writeString(this.monitorId);
        out.writeString(this.monitorName);
        out.writeEnum((Enum)this.state);
        out.writeInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        out.writeOptionalInstant(this.acknowledgedTime);
        out.writeOptionalString(this.errorMessage);
        out.writeString(this.severity);
        out.writeCollection(this.actionExecutionResults);
        out.writeOptionalInstant(this.lastUpdatedTime);
        out.writeString(this.iocType);
        out.writeString(this.iocValue);
        out.writeStringCollection(this.findingIds);
    }

    public static ThreatIntelAlert parse(XContentParser xcp, long version, long seqNo, long primaryTerm) throws IOException {
        String id = NO_ID;
        long schemaVersion = 0L;
        User user = null;
        String triggerId = null;
        String triggerName = null;
        String monitorId = null;
        String monitorName = null;
        Alert.State state = null;
        Instant startTime = null;
        String severity = null;
        Instant endTime = null;
        Instant acknowledgedTime = null;
        Instant lastUpdatedTime = null;
        String errorMessage = null;
        ArrayList<ActionExecutionResult> actionExecutionResults = new ArrayList<ActionExecutionResult>();
        String iocValue = null;
        String iocType = null;
        ArrayList<String> findingIds = new ArrayList<String>();
        block46: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block46;
                }
                case "id": {
                    id = xcp.text();
                    continue block46;
                }
                case "ioc_value": {
                    iocValue = xcp.textOrNull();
                    continue block46;
                }
                case "ioc_type": {
                    iocType = xcp.textOrNull();
                    continue block46;
                }
                case "version": {
                    version = xcp.longValue();
                    continue block46;
                }
                case "schema_version": {
                    schemaVersion = xcp.intValue();
                    continue block46;
                }
                case "seq_no": {
                    seqNo = xcp.longValue();
                    continue block46;
                }
                case "primary_term": {
                    primaryTerm = xcp.longValue();
                    continue block46;
                }
                case "trigger_id": {
                    triggerId = xcp.text();
                    continue block46;
                }
                case "trigger_name": {
                    triggerName = xcp.text();
                    continue block46;
                }
                case "monitor_id": {
                    monitorId = xcp.text();
                    continue block46;
                }
                case "monitor_name": {
                    monitorName = xcp.text();
                    continue block46;
                }
                case "state": {
                    state = Alert.State.valueOf((String)xcp.text());
                    continue block46;
                }
                case "error_message": {
                    errorMessage = xcp.textOrNull();
                    continue block46;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block46;
                }
                case "action_execution_results": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        actionExecutionResults.add(ActionExecutionResult.parse((XContentParser)xcp));
                    }
                    continue block46;
                }
                case "start_time": {
                    startTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "end_time": {
                    endTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "acknowledged_time": {
                    acknowledgedTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "last_updated_time": {
                    lastUpdatedTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "finding_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        findingIds.add(xcp.text());
                    }
                    break;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelAlert(id, version, schemaVersion, seqNo, primaryTerm, user, triggerId, triggerName, monitorId, monitorName, state, startTime, endTime, acknowledgedTime, lastUpdatedTime, errorMessage, severity, iocValue, iocType, actionExecutionResults, findingIds);
    }

    public static ThreatIntelAlert parse(XContentParser xcp, long version) throws IOException {
        String id = NO_ID;
        long schemaVersion = 0L;
        long seqNo = -2L;
        long primaryTerm = 0L;
        User user = null;
        String triggerId = null;
        String triggerName = null;
        String monitorId = null;
        String monitorName = null;
        Alert.State state = null;
        Instant startTime = null;
        String severity = null;
        Instant endTime = null;
        Instant acknowledgedTime = null;
        Instant lastUpdatedTime = null;
        String errorMessage = null;
        ArrayList<ActionExecutionResult> actionExecutionResults = new ArrayList<ActionExecutionResult>();
        String iocValue = null;
        String iocType = null;
        ArrayList<String> findingIds = new ArrayList<String>();
        block46: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block46;
                }
                case "id": {
                    id = xcp.text();
                    continue block46;
                }
                case "ioc_value": {
                    iocValue = xcp.textOrNull();
                    continue block46;
                }
                case "ioc_type": {
                    iocType = xcp.textOrNull();
                    continue block46;
                }
                case "version": {
                    version = xcp.longValue();
                    continue block46;
                }
                case "schema_version": {
                    schemaVersion = xcp.intValue();
                    continue block46;
                }
                case "seq_no": {
                    seqNo = xcp.longValue();
                    continue block46;
                }
                case "primary_term": {
                    primaryTerm = xcp.longValue();
                    continue block46;
                }
                case "trigger_id": {
                    triggerId = xcp.text();
                    continue block46;
                }
                case "trigger_name": {
                    triggerName = xcp.text();
                    continue block46;
                }
                case "monitor_id": {
                    monitorId = xcp.text();
                    continue block46;
                }
                case "monitor_name": {
                    monitorName = xcp.text();
                    continue block46;
                }
                case "state": {
                    state = Alert.State.valueOf((String)xcp.text());
                    continue block46;
                }
                case "error_message": {
                    errorMessage = xcp.textOrNull();
                    continue block46;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block46;
                }
                case "action_execution_results": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        actionExecutionResults.add(ActionExecutionResult.parse((XContentParser)xcp));
                    }
                    continue block46;
                }
                case "start_time": {
                    startTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "end_time": {
                    endTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "acknowledged_time": {
                    acknowledgedTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "last_updated_time": {
                    lastUpdatedTime = XContentUtils.getInstant(xcp);
                    continue block46;
                }
                case "finding_ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        findingIds.add(xcp.text());
                    }
                    break;
                }
            }
            xcp.skipChildren();
        }
        return new ThreatIntelAlert(id, version, schemaVersion, seqNo, primaryTerm, user, triggerId, triggerName, monitorId, monitorName, state, startTime, endTime, acknowledgedTime, lastUpdatedTime, errorMessage, severity, iocValue, iocType, actionExecutionResults, findingIds);
    }

    public static Alert readFrom(StreamInput sin) throws IOException {
        return new Alert(sin);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public XContentBuilder toXContentWithUser(XContentBuilder builder) throws IOException {
        return this.createXContentBuilder(builder, false);
    }

    private XContentBuilder createXContentBuilder(XContentBuilder builder, boolean secure) throws IOException {
        builder.startObject().field(ALERT_ID_FIELD, this.id).field(ALERT_VERSION_FIELD, this.version).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(SEQ_NO_FIELD, this.seqNo).field(PRIMARY_TERM_FIELD, this.primaryTerm).field(TRIGGER_NAME_FIELD, this.triggerName).field(TRIGGER_ID_FIELD, this.triggerId).field(MONITOR_ID_FIELD, this.monitorId).field(MONITOR_NAME_FIELD, this.monitorName).field(STATE_FIELD, (Object)this.state).field(ERROR_MESSAGE_FIELD, this.errorMessage).field(IOC_VALUE_FIELD, this.iocValue).field(IOC_TYPE_FIELD, this.iocType).field(SEVERITY_FIELD, this.severity).field(ACTION_EXECUTION_RESULTS_FIELD, (Object)this.actionExecutionResults.toArray()).field(FINDING_IDS_FIELD, (Object)this.findingIds.toArray(new String[0]));
        XContentUtils.buildInstantAsField(builder, this.acknowledgedTime, ACKNOWLEDGED_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.lastUpdatedTime, LAST_UPDATED_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.startTime, START_TIME_FIELD);
        XContentUtils.buildInstantAsField(builder, this.endTime, END_TIME_FIELD);
        if (!secure) {
            if (this.user == null) {
                builder.nullField(USER_FIELD);
            } else {
                builder.field(USER_FIELD, (ToXContent)this.user);
            }
        }
        return builder.endObject();
    }

    public Map<String, Object> asTemplateArg() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(ACKNOWLEDGED_TIME_FIELD, this.acknowledgedTime != null ? Long.valueOf(this.acknowledgedTime.toEpochMilli()) : null);
        map.put(ALERT_ID_FIELD, this.id);
        map.put(ALERT_VERSION_FIELD, this.version);
        map.put(END_TIME_FIELD, this.endTime != null ? Long.valueOf(this.endTime.toEpochMilli()) : null);
        map.put(ERROR_MESSAGE_FIELD, this.errorMessage);
        map.put(SEVERITY_FIELD, this.severity);
        map.put(START_TIME_FIELD, this.startTime.toEpochMilli());
        map.put(STATE_FIELD, this.state.toString());
        map.put(TRIGGER_ID_FIELD, this.triggerId);
        map.put(TRIGGER_NAME_FIELD, this.triggerName);
        map.put(FINDING_IDS_FIELD, this.findingIds);
        map.put(LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime);
        map.put(IOC_TYPE_FIELD, this.iocType);
        map.put(IOC_VALUE_FIELD, this.iocValue);
        return map;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public User getUser() {
        return this.user;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public Alert.State getState() {
        return this.state;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Instant getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<ActionExecutionResult> getActionExecutionResults() {
        return this.actionExecutionResults;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getIocValue() {
        return this.iocValue;
    }

    public String getIocType() {
        return this.iocType;
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public String getMonitorId() {
        return this.monitorId;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }
}

