/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.logtype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.Streams;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.logtype.BuiltinLogTypeLoader;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.FieldMappingDoc;
import org.opensearch.securityanalytics.model.LogType;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class LogTypeService {
    private static final Logger logger = LogManager.getLogger(LogTypeService.class);
    public static final String LOG_TYPE_INDEX = ".opensearch-sap-log-types-config";
    public static final String LOG_TYPE_INDEX_MAPPING_FILE = "mappings/log_type_config_mapping.json";
    public static final String LOG_TYPE_MAPPING_VERSION_META_FIELD = "schema_version";
    public static final int MAX_LOG_TYPE_COUNT = 100;
    private static volatile boolean isConfigIndexInitialized;
    private final Client client;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private BuiltinLogTypeLoader builtinLogTypeLoader;
    private String defaultSchemaField;
    public int logTypeMappingVersion;

    @Inject
    public LogTypeService(Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry, BuiltinLogTypeLoader builtinLogTypeLoader) {
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.builtinLogTypeLoader = builtinLogTypeLoader;
        this.defaultSchemaField = (String)SecurityAnalyticsSettings.DEFAULT_MAPPING_SCHEMA.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.DEFAULT_MAPPING_SCHEMA, newDefaultSchema -> {
            this.defaultSchemaField = newDefaultSchema;
        });
        this.setLogTypeMappingVersion();
    }

    public void getAllLogTypes(ActionListener<List<String>> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(e -> {
            SearchRequest searchRequest = new SearchRequest(new String[]{LOG_TYPE_INDEX});
            searchRequest.source(new SearchSourceBuilder().aggregation((AggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("logTypes").field("log_types")).size(100)));
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            this.client.search(searchRequest, ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, searchResponse) -> {
                ArrayList<String> logTypes = new ArrayList<String>();
                Terms termsAgg = (Terms)searchResponse.getAggregations().get("logTypes");
                for (Terms.Bucket bucket : termsAgg.getBuckets()) {
                    logTypes.add(bucket.getKeyAsString());
                }
                delegatedListener.onResponse(logTypes);
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getAllLogTypesMetadata(ActionListener<List<String>> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(e -> {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{LOG_TYPE_INDEX});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference("_primary");
            this.client.search(searchRequest, ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, searchResponse) -> {
                SearchHit[] hits;
                ArrayList<String> logTypes = new ArrayList<String>();
                for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                    Map source = hit.getSourceAsMap();
                    logTypes.add(source.get("name").toString());
                }
                delegatedListener.onResponse(logTypes);
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void doesLogTypeExist(String logType, ActionListener<Boolean> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(e -> {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"name", (Object)logType));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{LOG_TYPE_INDEX});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference("_primary");
            this.client.search(searchRequest, ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, searchResponse) -> {
                SearchHit[] hits = searchResponse.getHits().getHits();
                delegatedListener.onResponse((Object)(hits.length > 0 ? 1 : 0));
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void searchLogTypes(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(e -> {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
            if (request.source().query() != null) {
                queryBuilder.must(request.source().query());
            }
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{LOG_TYPE_INDEX});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference("_primary");
            this.client.search(searchRequest, ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, searchResponse) -> delegatedListener.onResponse(searchResponse)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void doIndexFieldMappings(List<FieldMappingDoc> fieldMappingDocs, ActionListener<Void> listener) {
        if (fieldMappingDocs.isEmpty()) {
            listener.onResponse(null);
        }
        this.getAllFieldMappings((ActionListener<List<FieldMappingDoc>>)ActionListener.wrap(existingFieldMappings -> {
            List<FieldMappingDoc> mergedFieldMappings = this.mergeFieldMappings((List<FieldMappingDoc>)existingFieldMappings, fieldMappingDocs);
            BulkRequest bulkRequest = new BulkRequest();
            mergedFieldMappings.stream().filter(e -> e.isDirty()).forEach(fieldMappingDoc -> {
                IndexRequest indexRequest = new IndexRequest(LOG_TYPE_INDEX);
                try {
                    indexRequest.id(fieldMappingDoc.getId() == null ? this.generateFieldMappingDocId((FieldMappingDoc)fieldMappingDoc) : fieldMappingDoc.getId());
                    indexRequest.source(fieldMappingDoc.toXContent(XContentFactory.jsonBuilder(), null));
                    indexRequest.opType(DocWriteRequest.OpType.INDEX);
                    bulkRequest.add(indexRequest);
                    bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                }
                catch (IOException ex) {
                    logger.error("Failed converting FieldMappingDoc to XContent!", (Throwable)ex);
                }
            });
            logger.info("Indexing [" + bulkRequest.numberOfActions() + "] fieldMappingDocs");
            this.client.bulk(bulkRequest, ActionListener.delegateFailure((ActionListener)listener, (l, r) -> {
                if (r.hasFailures()) {
                    logger.error("FieldMappingDoc Bulk Index had failures:\n ", (Object)r.buildFailureMessage());
                    listener.onFailure((Exception)new IllegalStateException(r.buildFailureMessage()));
                } else {
                    logger.info("Loaded [" + r.getItems().length + "] field mapping docs successfully!");
                    listener.onResponse(null);
                }
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void doIndexLogTypeMetadata(final ActionListener<Void> listener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.fetchSource(false);
        searchSourceBuilder.size(0);
        searchSourceBuilder.trackTotalHits(true);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{LOG_TYPE_INDEX});
        searchRequest.source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                if (response.isTimedOut()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                }
                if (response.getHits().getHits().length > 0) {
                    listener.onResponse(null);
                } else {
                    try {
                        List<CustomLogType> customLogTypes = LogTypeService.this.builtinLogTypeLoader.loadBuiltinLogTypesMetadata();
                        BulkRequest bulkRequest = new BulkRequest();
                        for (CustomLogType customLogType : customLogTypes) {
                            IndexRequest indexRequest = new IndexRequest(LogTypeService.LOG_TYPE_INDEX).id(customLogType.getName());
                            indexRequest.source(customLogType.toXContent(XContentFactory.jsonBuilder(), null));
                            indexRequest.opType(DocWriteRequest.OpType.INDEX);
                            bulkRequest.add(indexRequest);
                        }
                        if (bulkRequest.numberOfActions() > 0) {
                            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                            logger.info("Indexing [" + bulkRequest.numberOfActions() + "] customLogTypes");
                            LogTypeService.this.client.bulk(bulkRequest, ActionListener.delegateFailure((ActionListener)listener, (l, r) -> {
                                if (r.hasFailures()) {
                                    logger.error("Custom LogType Bulk Index had failures:\n ", (Object)r.buildFailureMessage());
                                    listener.onFailure((Exception)new IllegalStateException(r.buildFailureMessage()));
                                } else {
                                    logger.info("Loaded [" + r.getItems().length + "] customLogType docs successfully!");
                                    listener.onResponse(null);
                                }
                            }));
                        } else {
                            listener.onResponse(null);
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        listener.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private String generateFieldMappingDocId(FieldMappingDoc fieldMappingDoc) {
        String generatedId = fieldMappingDoc.getRawField() + "|";
        if (fieldMappingDoc.getSchemaFields().containsKey(this.defaultSchemaField)) {
            generatedId = generatedId + fieldMappingDoc.getSchemaFields().get(this.defaultSchemaField);
        }
        return generatedId;
    }

    public void indexFieldMappings(List<FieldMappingDoc> fieldMappingDocs, ActionListener<Void> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(e -> this.doIndexFieldMappings(fieldMappingDocs, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private List<FieldMappingDoc> mergeFieldMappings(List<FieldMappingDoc> existingFieldMappings, List<FieldMappingDoc> fieldMappingDocs) {
        ArrayList newFieldMappings = new ArrayList();
        fieldMappingDocs.forEach(newFieldMapping -> {
            Optional<Object> foundFieldMappingDoc = Optional.empty();
            for (FieldMappingDoc existingFieldMapping : existingFieldMappings) {
                String ecsIdField;
                if (existingFieldMapping.getRawField().equals(newFieldMapping.getRawField())) {
                    if ((existingFieldMapping.get(this.defaultSchemaField) == null || newFieldMapping.get(this.defaultSchemaField) == null || !existingFieldMapping.get(this.defaultSchemaField).equals(newFieldMapping.get(this.defaultSchemaField))) && (existingFieldMapping.get(this.defaultSchemaField) != null || newFieldMapping.get(this.defaultSchemaField) != null)) continue;
                    foundFieldMappingDoc = Optional.of(existingFieldMapping);
                    continue;
                }
                String id = existingFieldMapping.getId();
                int indexOfPipe = id.indexOf("|");
                if (indexOfPipe == -1 || !(ecsIdField = id.substring(indexOfPipe + 1)).equals(newFieldMapping.getRawField()) || !existingFieldMapping.getLogTypes().containsAll(newFieldMapping.getLogTypes())) continue;
                foundFieldMappingDoc = Optional.of(existingFieldMapping);
            }
            if (foundFieldMappingDoc.isEmpty()) {
                newFieldMapping.setIsDirty(true);
                newFieldMappings.add(newFieldMapping);
            } else {
                ((FieldMappingDoc)foundFieldMappingDoc.get()).getSchemaFields().putAll(newFieldMapping.getSchemaFields());
                ((FieldMappingDoc)foundFieldMappingDoc.get()).getLogTypes().addAll(newFieldMapping.getLogTypes());
                ((FieldMappingDoc)foundFieldMappingDoc.get()).setIsDirty(true);
            }
        });
        existingFieldMappings.addAll(newFieldMappings);
        return existingFieldMappings;
    }

    public void getAllFieldMappings(ActionListener<List<FieldMappingDoc>> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{LOG_TYPE_INDEX});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"source"))).size(10000));
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, ActionListener.delegateFailure(listener, (delegatedListener, searchResponse) -> {
            ArrayList<FieldMappingDoc> fieldMappingDocs = new ArrayList<FieldMappingDoc>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try {
                    fieldMappingDocs.add(FieldMappingDoc.parse(hit, this.xContentRegistry));
                }
                catch (IOException e) {
                    logger.error("Failed parsing FieldMapping document", (Throwable)e);
                    delegatedListener.onFailure((Exception)e);
                    return;
                }
            }
            delegatedListener.onResponse(fieldMappingDocs);
        }));
    }

    public void getFieldMappingsByLogType(String logType, ActionListener<List<FieldMappingDoc>> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(() -> this.getFieldMappingsByLogTypes(List.of(logType), listener)));
    }

    public void getFieldMappingsByLogTypes(List<String> logTypes, ActionListener<List<FieldMappingDoc>> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{LOG_TYPE_INDEX});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termsQuery((String)"log_types", (String[])logTypes.toArray(new String[0]))).size(10000));
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, ActionListener.delegateFailure(listener, (delegatedListener, searchResponse) -> {
            ArrayList<FieldMappingDoc> fieldMappingDocs = new ArrayList<FieldMappingDoc>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                try {
                    fieldMappingDocs.add(FieldMappingDoc.parse(hit, this.xContentRegistry));
                }
                catch (IOException e) {
                    logger.error("Failed parsing FieldMapping document", (Throwable)e);
                    delegatedListener.onFailure((Exception)e);
                    return;
                }
            }
            delegatedListener.onResponse(fieldMappingDocs);
        }));
    }

    public void ensureConfigIndexIsInitialized(final ActionListener<Void> listener) {
        ClusterState state = this.clusterService.state();
        if (!state.routingTable().hasIndex(LOG_TYPE_INDEX)) {
            isConfigIndexInitialized = false;
            Settings indexSettings = Settings.builder().put("index.hidden", true).put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-20").build();
            CreateIndexRequest createIndexRequest = new CreateIndexRequest();
            createIndexRequest.settings(this.logTypeIndexSettings());
            createIndexRequest.index(LOG_TYPE_INDEX);
            createIndexRequest.mapping(this.logTypeIndexMapping());
            createIndexRequest.settings(indexSettings);
            createIndexRequest.cause("auto(sap-logtype api)");
            this.client.admin().indices().create(createIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse result) {
                    LogTypeService.this.loadBuiltinLogTypes((ActionListener<Void>)ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, unused) -> {
                        isConfigIndexInitialized = true;
                        LogTypeService.this.doIndexLogTypeMetadata((ActionListener<Void>)listener);
                    }));
                }

                public void onFailure(Exception e) {
                    isConfigIndexInitialized = false;
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                        LogTypeService.this.loadBuiltinLogTypes((ActionListener<Void>)ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, unused) -> {
                            isConfigIndexInitialized = true;
                            LogTypeService.this.doIndexLogTypeMetadata((ActionListener<Void>)listener);
                        }));
                    } else {
                        logger.error("Failed creating LOG_TYPE_INDEX", (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            IndexMetadata metadata = state.getMetadata().index(LOG_TYPE_INDEX);
            if (this.getConfigIndexMappingVersion(metadata) < this.logTypeMappingVersion) {
                this.client.admin().indices().preparePutMapping(new String[]{LOG_TYPE_INDEX}).setSource(this.logTypeIndexMapping(), (MediaType)XContentType.JSON).execute(ActionListener.delegateFailure(listener, (l, r) -> this.loadBuiltinLogTypes((ActionListener<Void>)ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, unused) -> {
                    isConfigIndexInitialized = true;
                    this.doIndexLogTypeMetadata(listener);
                }))));
            } else {
                if (isConfigIndexInitialized) {
                    this.doIndexLogTypeMetadata(listener);
                    return;
                }
                this.loadBuiltinLogTypes((ActionListener<Void>)ActionListener.delegateFailure(listener, (delegatedListener, unused) -> {
                    isConfigIndexInitialized = true;
                    this.doIndexLogTypeMetadata(listener);
                }));
            }
        }
    }

    public void loadBuiltinLogTypes(ActionListener<Void> listener) {
        logger.info("Loading builtin types!");
        List<LogType> logTypes = this.builtinLogTypeLoader.getAllLogTypes();
        if (logTypes == null || logTypes.size() == 0) {
            logger.error("Failed loading builtin log types from disk!");
            listener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalStateException("Failed loading builtin log types from disk!")));
            return;
        }
        List<FieldMappingDoc> fieldMappingDocs = this.createFieldMappingDocs(logTypes);
        logger.info("Indexing [" + fieldMappingDocs.size() + "] fieldMappingDocs from logTypes: " + logTypes.size());
        this.doIndexFieldMappings(fieldMappingDocs, listener);
    }

    private List<FieldMappingDoc> createFieldMappingDocs(List<LogType> logTypes) {
        HashMap fieldMappingMap = new HashMap();
        logTypes.stream().filter(e -> e.getMappings() != null).forEach(logType -> logType.getMappings().forEach(mapping -> {
            String key = mapping.getRawField() + "|" + mapping.getEcs();
            FieldMappingDoc existingDoc = (FieldMappingDoc)fieldMappingMap.get(key);
            if (existingDoc == null) {
                HashMap<String, String> schemaFields = new HashMap<String, String>();
                if (mapping.getEcs() != null) {
                    schemaFields.put("ecs", mapping.getEcs());
                }
                if (mapping.getOcsf() != null) {
                    schemaFields.put("ocsf", mapping.getOcsf());
                }
                if (mapping.getOcsf11() != null) {
                    schemaFields.put("ocsf11", mapping.getOcsf11());
                }
                fieldMappingMap.put(key, new FieldMappingDoc(mapping.getRawField(), schemaFields, Sets.newHashSet((Object[])new String[]{logType.getName()})));
            } else {
                existingDoc.getSchemaFields().put("ocsf", mapping.getOcsf());
                existingDoc.getSchemaFields().put("ocsf11", mapping.getOcsf11());
                existingDoc.getLogTypes().add(logType.getName());
            }
        }));
        return fieldMappingMap.values().stream().collect(Collectors.toList());
    }

    public String logTypeIndexMapping() {
        String string;
        block8: {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(LOG_TYPE_INDEX_MAPPING_FILE);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Streams.copy((InputStream)is, (OutputStream)out);
                string = out.toString(StandardCharsets.UTF_8.name());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error(() -> new ParameterizedMessage("failed to load log-type-index mapping file [{}]", (Object)LOG_TYPE_INDEX_MAPPING_FILE), (Throwable)e);
                    throw new IllegalStateException("failed to load log-type-index mapping file [mappings/log_type_config_mapping.json]", e);
                }
            }
            is.close();
        }
        return string;
    }

    private Settings logTypeIndexSettings() {
        return Settings.builder().put(IndexMetadata.INDEX_HIDDEN_SETTING.getKey(), "true").build();
    }

    private int getConfigIndexMappingVersion(IndexMetadata metadata) {
        MappingMetadata mappingMetadata = metadata.mapping();
        if (mappingMetadata == null) {
            return 0;
        }
        Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
        if (meta == null || !meta.containsKey(LOG_TYPE_MAPPING_VERSION_META_FIELD)) {
            return 1;
        }
        return (Integer)meta.get(LOG_TYPE_MAPPING_VERSION_META_FIELD);
    }

    public List<LogType> getAllBuiltinLogTypes() {
        return this.builtinLogTypeLoader.getAllLogTypes();
    }

    public void getRuleFieldMappings(ActionListener<Map<String, Map<String, String>>> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(() -> this.getAllFieldMappings((ActionListener<List<FieldMappingDoc>>)ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, fieldMappingDocs) -> {
            HashMap mappings = new HashMap();
            for (FieldMappingDoc fieldMappingDoc : fieldMappingDocs) {
                Set<String> logTypes = fieldMappingDoc.getLogTypes();
                if (logTypes == null) continue;
                for (String logType : logTypes) {
                    Map<String, String> mappingsByLogTypes = mappings.containsKey(logType) ? (Map)mappings.get(logType) : new HashMap();
                    mappingsByLogTypes.put(fieldMappingDoc.getRawField(), fieldMappingDoc.getSchemaFields().get(this.defaultSchemaField));
                    mappings.put(logType, mappingsByLogTypes);
                }
            }
            delegatedListener.onResponse(mappings);
        }))));
    }

    public void getRuleFieldMappings(String logType, ActionListener<Map<String, String>> listener) {
        if (this.builtinLogTypeLoader.logTypeExists(logType)) {
            LogType lt = this.builtinLogTypeLoader.getLogTypeByName(logType);
            if (lt.getMappings() == null) {
                listener.onResponse(Map.of());
            } else {
                listener.onResponse(lt.getMappings().stream().collect(Collectors.toMap(LogType.Mapping::getRawField, LogType.Mapping::getEcs)));
            }
            return;
        }
        this.getFieldMappingsByLogType(logType, (ActionListener<List<FieldMappingDoc>>)ActionListener.delegateFailure(listener, (delegatedListener, fieldMappingDocs) -> {
            HashMap ruleFieldMappings = new HashMap(fieldMappingDocs.size());
            fieldMappingDocs.forEach(e -> ruleFieldMappings.put(e.getRawField(), e.getSchemaFields().get(this.defaultSchemaField)));
            delegatedListener.onResponse(ruleFieldMappings);
        }));
    }

    public List<LogType.IocFields> getIocFieldsList(String logType) {
        LogType logTypeByName = this.builtinLogTypeLoader.getLogTypeByName(logType);
        if (logTypeByName == null) {
            return Collections.emptyList();
        }
        return logTypeByName.getIocFieldsList();
    }

    public void getRuleFieldMappingsAllSchemas(String logType, ActionListener<List<LogType.Mapping>> listener) {
        if (this.builtinLogTypeLoader.logTypeExists(logType)) {
            LogType lt = this.builtinLogTypeLoader.getLogTypeByName(logType);
            if (lt.getMappings() == null) {
                listener.onResponse(List.of());
            } else {
                listener.onResponse(lt.getMappings());
            }
            return;
        }
        this.getFieldMappingsByLogType(logType, (ActionListener<List<FieldMappingDoc>>)ActionListener.delegateFailure(listener, (delegatedListener, fieldMappingDocs) -> {
            ArrayList ruleFieldMappings = new ArrayList();
            fieldMappingDocs.forEach(e -> ruleFieldMappings.add(new LogType.Mapping(e.getRawField(), e.getSchemaFields().get("ecs"), e.getSchemaFields().get("ocsf"), e.getSchemaFields().get("ocsf11"))));
            delegatedListener.onResponse(ruleFieldMappings);
        }));
    }

    public void getRequiredFields(String logType, ActionListener<List<LogType.Mapping>> listener) {
        this.getFieldMappingsByLogType(logType, (ActionListener<List<FieldMappingDoc>>)ActionListener.delegateFailure(listener, (delegatedListener, fieldMappingDocs) -> {
            ArrayList requiredFields = new ArrayList();
            fieldMappingDocs.forEach(e -> {
                LogType.Mapping requiredField = new LogType.Mapping(e.getRawField(), e.getSchemaFields().get(this.defaultSchemaField), e.getSchemaFields().get("ocsf"), e.getSchemaFields().get("ocsf11"));
                requiredFields.add(requiredField);
            });
            delegatedListener.onResponse(requiredFields);
        }));
    }

    public void getRequiredFieldsForAllLogTypes(ActionListener<Map<String, Set<String>>> listener) {
        this.ensureConfigIndexIsInitialized((ActionListener<Void>)ActionListener.wrap(() -> this.getAllFieldMappings((ActionListener<List<FieldMappingDoc>>)ActionListener.delegateFailure((ActionListener)listener, (delegatedListener, fieldMappingDocs) -> {
            HashMap requiredFieldsMap = new HashMap();
            fieldMappingDocs.forEach(e -> {
                e.getLogTypes().forEach(logType -> {
                    if (!requiredFieldsMap.containsKey(logType)) {
                        requiredFieldsMap.put(logType, new HashSet());
                    }
                });
                String requiredField = e.getSchemaFields().get(this.defaultSchemaField);
                if (requiredField == null) {
                    requiredField = e.getRawField();
                }
                String _requiredField = requiredField;
                e.getLogTypes().forEach(logType -> ((Set)requiredFieldsMap.get(logType)).add(_requiredField));
            });
            delegatedListener.onResponse(requiredFieldsMap);
        }))));
    }

    public Map<String, String> getRuleFieldMappingsForBuiltinLogType(String builtinLogType) {
        if (!this.builtinLogTypeLoader.logTypeExists(builtinLogType)) {
            return null;
        }
        LogType lt = this.builtinLogTypeLoader.getLogTypeByName(builtinLogType);
        if (lt.getMappings() == null) {
            return Map.of();
        }
        return lt.getMappings().stream().collect(Collectors.toMap(LogType.Mapping::getRawField, LogType.Mapping::getEcs));
    }

    public String getDefaultSchemaField() {
        return this.defaultSchemaField;
    }

    public void setLogTypeMappingVersion() {
        Map logTypeConfigAsMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)this.logTypeIndexMapping(), (boolean)false);
        this.logTypeMappingVersion = (Integer)((Map)logTypeConfigAsMap.get("_meta")).get(LOG_TYPE_MAPPING_VERSION_META_FIELD);
    }
}

