/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.undeploy;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.CommonValue;

public class MLUndeployModelNodesRequest
extends BaseNodesRequest<MLUndeployModelNodesRequest> {
    private String[] modelIds;
    private String tenantId;

    public MLUndeployModelNodesRequest(StreamInput in) throws IOException {
        super(in);
        Version streamInputVersion = in.getVersion();
        this.modelIds = in.readOptionalStringArray();
        this.tenantId = streamInputVersion.onOrAfter(CommonValue.VERSION_2_19_0) ? in.readOptionalString() : null;
    }

    public MLUndeployModelNodesRequest(String[] nodeIds, String[] modelIds) {
        super(nodeIds);
        this.modelIds = modelIds;
    }

    public MLUndeployModelNodesRequest(DiscoveryNode ... nodes) {
        super(nodes);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version streamOutputVersion = out.getVersion();
        out.writeOptionalStringArray(this.modelIds);
        if (streamOutputVersion.onOrAfter(CommonValue.VERSION_2_19_0)) {
            out.writeOptionalString(this.tenantId);
        }
    }

    @Generated
    public String[] getModelIds() {
        return this.modelIds;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}

