/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EventListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sparkproject.jetty.http.HostPortHttpField;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.QuotedCSV;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.handler.HandlerWrapper;
import org.sparkproject.jetty.util.IncludeExcludeSet;
import org.sparkproject.jetty.util.InetAddressSet;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedOperation;
import org.sparkproject.jetty.util.annotation.Name;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;
import org.sparkproject.jetty.util.thread.Locker;

public class ThreadLimitHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ThreadLimitHandler.class);
    private static final String REMOTE = "o.e.j.s.h.TLH.REMOTE";
    private static final String PERMIT = "o.e.j.s.h.TLH.PASS";
    private final boolean _rfc7239;
    private final String _forwardedHeader;
    private final IncludeExcludeSet<String, InetAddress> _includeExcludeSet = new IncludeExcludeSet(InetAddressSet.class);
    private final ConcurrentHashMap<String, Remote> _remotes = new ConcurrentHashMap();
    private volatile boolean _enabled;
    private int _threadLimit = 10;

    public ThreadLimitHandler() {
        this(null, false);
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader) {
        this(forwardedHeader, HttpHeader.FORWARDED.is(forwardedHeader));
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader, @Name(value="rfc7239") boolean rfc7239) {
        this._rfc7239 = rfc7239;
        this._forwardedHeader = forwardedHeader;
        this._enabled = true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet), new Object[0]);
    }

    @ManagedAttribute(value="true if this handler is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet), new Object[0]);
    }

    @ManagedAttribute(value="The maximum threads that can be dispatched per remote IP")
    public int getThreadLimit() {
        return this._threadLimit;
    }

    public void setThreadLimit(int threadLimit) {
        if (threadLimit <= 0) {
            throw new IllegalArgumentException("limit must be >0");
        }
        this._threadLimit = threadLimit;
    }

    @ManagedOperation(value="Include IP in thread limits")
    public void include(String inetAddressPattern) {
        this._includeExcludeSet.include(inetAddressPattern);
    }

    @ManagedOperation(value="Exclude IP from thread limits")
    public void exclude(String inetAddressPattern) {
        this._includeExcludeSet.exclude(inetAddressPattern);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this._enabled) {
            super.handle(target, baseRequest, request, response);
        } else {
            final Remote remote = this.getRemote(baseRequest);
            if (remote == null) {
                super.handle(target, baseRequest, request, response);
            } else {
                request.getServletContext().addListener((EventListener)new ServletRequestListener(){

                    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
                    }

                    public void requestDestroyed(ServletRequestEvent sre) {
                        ThreadLimitHandler.this._remotes.computeIfPresent(remote._ip, (k, v) -> ((Remote)v)._referenceCounter.release() ? null : v);
                    }
                });
                try (Closeable permit = (Closeable)baseRequest.getAttribute(PERMIT);){
                    if (permit != null) {
                        baseRequest.removeAttribute(PERMIT);
                    } else {
                        CompletableFuture<Closeable> futurePermit = remote.acquire();
                        if (futurePermit.isDone()) {
                            permit = futurePermit.get();
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Threadlimited {} {}", remote, target);
                            }
                            AsyncContext async = baseRequest.startAsync();
                            async.setTimeout(0L);
                            futurePermit.thenAccept(c -> {
                                baseRequest.setAttribute(PERMIT, c);
                                async.dispatch();
                            });
                            return;
                        }
                    }
                    super.handle(target, baseRequest, request, response);
                }
            }
        }
    }

    protected int getThreadLimit(String ip) {
        if (!this._includeExcludeSet.isEmpty()) {
            try {
                if (!this._includeExcludeSet.test(InetAddress.getByName(ip))) {
                    LOG.debug("excluded {}", ip);
                    return 0;
                }
            }
            catch (Exception e) {
                LOG.ignore(e);
            }
        }
        return this._threadLimit;
    }

    protected Remote getRemote(Request baseRequest) {
        Remote remote = (Remote)baseRequest.getAttribute(REMOTE);
        if (remote != null) {
            return remote;
        }
        String ip = this.getRemoteIP(baseRequest);
        LOG.debug("ip={}", ip);
        if (ip == null) {
            return null;
        }
        int limit = this.getThreadLimit(ip);
        if (limit <= 0) {
            return null;
        }
        remote = this._remotes.compute(ip, (k, v) -> {
            if (v != null) {
                ((Remote)v)._referenceCounter.retain();
                return v;
            }
            return new Remote((String)k, limit);
        });
        baseRequest.setAttribute(REMOTE, remote);
        return remote;
    }

    protected String getRemoteIP(Request baseRequest) {
        InetSocketAddress inetAddr;
        if (this._forwardedHeader != null && !this._forwardedHeader.isEmpty()) {
            String remote;
            String string = remote = this._rfc7239 ? this.getForwarded(baseRequest) : this.getXForwardedFor(baseRequest);
            if (remote != null && !remote.isEmpty()) {
                return remote;
            }
        }
        if ((inetAddr = baseRequest.getHttpChannel().getRemoteAddress()) != null && inetAddr.getAddress() != null) {
            return inetAddr.getAddress().getHostAddress();
        }
        return null;
    }

    private String getForwarded(Request request) {
        RFC7239 rfc7239 = new RFC7239();
        HttpFields httpFields = request.getHttpFields();
        for (HttpField field : httpFields) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            rfc7239.addValue(field.getValue());
        }
        if (rfc7239.getFor() != null) {
            return new HostPortHttpField(rfc7239.getFor()).getHost();
        }
        return null;
    }

    private String getXForwardedFor(Request request) {
        String forwardedFor = null;
        HttpFields httpFields = request.getHttpFields();
        for (HttpField field : httpFields) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            forwardedFor = field.getValue();
        }
        if (forwardedFor == null || forwardedFor.isEmpty()) {
            return null;
        }
        int comma = forwardedFor.lastIndexOf(44);
        return comma >= 0 ? forwardedFor.substring(comma + 1).trim() : forwardedFor;
    }

    int getRemoteCount() {
        return this._remotes.size();
    }

    private static class ReferenceCounter {
        private final AtomicInteger references = new AtomicInteger(1);

        private ReferenceCounter() {
        }

        public void retain() {
            if (this.references.getAndUpdate(c -> c == 0 ? 0 : c + 1) == 0) {
                throw new IllegalStateException("released " + this);
            }
        }

        public boolean release() {
            int ref = this.references.updateAndGet(c -> {
                if (c == 0) {
                    throw new IllegalStateException("already released " + this);
                }
                return c - 1;
            });
            return ref == 0;
        }
    }

    private final class RFC7239
    extends QuotedCSV {
        String _for;

        private RFC7239() {
            super(false, new String[0]);
        }

        String getFor() {
            return this._for;
        }

        protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
            String name;
            if (valueLength == 0 && paramValue > paramName && "for".equalsIgnoreCase(name = StringUtil.asciiToLowerCase(buffer.substring(paramName, paramValue - 1)))) {
                String value = buffer.substring(paramValue);
                this._for = "unknown".equalsIgnoreCase(value) ? null : value;
            }
        }
    }

    private final class Remote
    implements Closeable {
        private final String _ip;
        private final int _limit;
        private final Locker _locker = new Locker();
        private final ReferenceCounter _referenceCounter = new ReferenceCounter();
        private int _permits;
        private Deque<CompletableFuture<Closeable>> _queue = new ArrayDeque<CompletableFuture<Closeable>>();
        private final CompletableFuture<Closeable> _permitted = CompletableFuture.completedFuture(this);

        public Remote(String ip, int limit) {
            this._ip = ip;
            this._limit = limit;
        }

        public CompletableFuture<Closeable> acquire() {
            try (Locker.Lock lock = this._locker.lock();){
                if (this._permits < this._limit) {
                    ++this._permits;
                    CompletableFuture<Closeable> completableFuture = this._permitted;
                    return completableFuture;
                }
                CompletableFuture<Closeable> pass = new CompletableFuture<Closeable>();
                this._queue.addLast(pass);
                CompletableFuture<Closeable> completableFuture = pass;
                return completableFuture;
            }
        }

        @Override
        public void close() throws IOException {
            block7: {
                try (Locker.Lock lock = this._locker.lock();){
                    CompletableFuture<Closeable> permit;
                    --this._permits;
                    do {
                        if ((permit = this._queue.pollFirst()) != null) continue;
                        break block7;
                    } while (!permit.complete(this));
                    ++this._permits;
                }
            }
        }

        public String toString() {
            try (Locker.Lock lock = this._locker.lock();){
                String string = String.format("R[ip=%s,p=%d,l=%d,q=%d]", this._ip, this._permits, this._limit, this._queue.size());
                return string;
            }
        }
    }
}

