/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.rerank;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.neuralsearch.processor.rerank.RerankType;
import org.opensearch.neuralsearch.processor.rerank.context.ContextSourceFetcher;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public abstract class RerankProcessor
implements SearchResponseProcessor {
    public static final String TYPE = "rerank";
    protected final RerankType subType;
    private final String description;
    private final String tag;
    private final boolean ignoreFailure;
    protected List<ContextSourceFetcher> contextSourceFetchers;
    protected static final List<RerankType> processorsWithNoContext = List.of(RerankType.BY_FIELD);

    public void generateRerankingContext(SearchRequest searchRequest, SearchResponse searchResponse, ActionListener<Map<String, Object>> listener) {
        if (!RerankProcessor.processorRequiresContext(this.subType)) {
            listener.onResponse(Map.of());
        }
        ConcurrentHashMap overallContext = new ConcurrentHashMap();
        AtomicInteger successfulContexts = new AtomicInteger(this.contextSourceFetchers.size());
        for (ContextSourceFetcher csf : this.contextSourceFetchers) {
            csf.fetchContext(searchRequest, searchResponse, (ActionListener<Map<String, Object>>)ActionListener.wrap(context -> {
                overallContext.putAll(context);
                if (successfulContexts.decrementAndGet() == 0) {
                    listener.onResponse((Object)overallContext);
                }
            }, e -> listener.onFailure(e)));
        }
    }

    public String getType() {
        return TYPE;
    }

    public abstract void rerank(SearchResponse var1, Map<String, Object> var2, ActionListener<SearchResponse> var3);

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        throw new UnsupportedOperationException("Use asyncProcessResponse unless you can guarantee to not deadlock yourself");
    }

    public void processResponseAsync(SearchRequest request, SearchResponse response, PipelineProcessingContext ctx, ActionListener<SearchResponse> responseListener) {
        try {
            this.generateRerankingContext(request, response, (ActionListener<Map<String, Object>>)ActionListener.wrap(context -> this.rerank(response, (Map<String, Object>)context, responseListener), e -> responseListener.onFailure(e)));
        }
        catch (Exception e2) {
            responseListener.onFailure(e2);
        }
    }

    public static boolean processorRequiresContext(RerankType subType) {
        return !processorsWithNoContext.contains((Object)subType);
    }

    @Generated
    public RerankProcessor(RerankType subType, String description, String tag, boolean ignoreFailure, List<ContextSourceFetcher> contextSourceFetchers) {
        this.subType = subType;
        this.description = description;
        this.tag = tag;
        this.ignoreFailure = ignoreFailure;
        this.contextSourceFetchers = contextSourceFetchers;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }
}

