/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class UpdateIndexStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(UpdateIndexStep.class);
    private final Client client;
    public static final String NAME = "update_index";

    public UpdateIndexStep(Client client) {
        this.client = client;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        PlainActionFuture updateIndexFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("index_name", "configurations");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            String indexName = (String)inputs.get("index_name");
            String configurations = (String)inputs.get("configurations");
            byte[] byteArr = configurations.getBytes(StandardCharsets.UTF_8);
            BytesArray configurationsBytes = new BytesArray(byteArr);
            UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{indexName});
            if (configurations.isEmpty()) {
                String errorMessage = "Failed to update index settings for index " + indexName + ", index configuration is not given";
                throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
            }
            Map sourceAsMap = (Map)XContentHelper.convertToMap((BytesReference)configurationsBytes, (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
            if (!sourceAsMap.containsKey("settings")) {
                String errorMessage = "Failed to update index settings for index " + indexName + ", settings are not found in the index configuration";
                throw new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST);
            }
            Map updatedSettings = (Map)sourceAsMap.get("settings");
            HashMap<String, Object> flattenedSettings = new HashMap<String, Object>();
            if (updatedSettings.containsKey("index")) {
                ParseUtils.flattenSettings("", updatedSettings, flattenedSettings);
            } else {
                flattenedSettings.putAll(ParseUtils.prependIndexToSettings(updatedSettings));
            }
            HashMap filteredSettings = new HashMap();
            GetSettingsRequest getSettingsRequest = new GetSettingsRequest();
            getSettingsRequest.indices(new String[]{indexName});
            getSettingsRequest.includeDefaults(true);
            this.client.admin().indices().getSettings(getSettingsRequest, ActionListener.wrap(response -> {
                HashMap indexToSettings = new HashMap(response.getIndexToSettings());
                Settings currentIndexSettings = (Settings)indexToSettings.get(indexName);
                for (Map.Entry e : flattenedSettings.entrySet()) {
                    String val = e.getValue().toString();
                    if (val.equals(currentIndexSettings.get((String)e.getKey()))) continue;
                    filteredSettings.put((String)e.getKey(), e.getValue());
                }
                updateSettingsRequest.settings(filteredSettings);
                if (updateSettingsRequest.settings().size() == 0) {
                    String errorMessage = "Failed to update index settings for index " + indexName + ", no settings have been updated";
                    updateIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, RestStatus.BAD_REQUEST)));
                } else {
                    this.client.admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(acknowledgedResponse -> {
                        String resourceName = WorkflowResources.getResourceByWorkflowStep(this.getName());
                        logger.info("Updated index settings for index {}", (Object)indexName);
                        updateIndexFuture.onResponse((Object)new WorkflowData(Map.of(resourceName, indexName), currentNodeInputs.getWorkflowId(), currentNodeId));
                    }, ex -> {
                        Exception e = WorkflowStepException.getSafeException(ex);
                        String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed to update the index settings for index {}", (Object)indexName).getFormattedMessage() : e.getMessage();
                        logger.error(errorMessage, (Throwable)e);
                        updateIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                    }));
                }
            }, ex -> {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed to retrieve the index settings for index {}", (Object)indexName).getFormattedMessage() : e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                updateIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }));
        }
        catch (Exception e) {
            updateIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(e.getMessage(), ExceptionsHelper.status((Throwable)e))));
        }
        return updateIndexFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

