/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.rest.RestRequest;

public class TenantAwareHelper {
    public static boolean validateTenantId(boolean isMultiTenancyEnabled, String tenantId, ActionListener<?> listener) {
        if (isMultiTenancyEnabled && tenantId == null) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("No permission to access this resource", RestStatus.FORBIDDEN)));
            return false;
        }
        return true;
    }

    public static boolean validateTenantResource(boolean isMultiTenancyEnabled, String tenantIdFromRequest, String tenantIdFromResource, ActionListener<?> listener) {
        if (isMultiTenancyEnabled && !Objects.equals(tenantIdFromRequest, tenantIdFromResource)) {
            listener.onFailure((Exception)((Object)new FlowFrameworkException("No permission to access this resource", RestStatus.FORBIDDEN)));
            return false;
        }
        return true;
    }

    public static String getTenantID(Boolean isMultiTenancyEnabled, RestRequest restRequest) {
        if (!isMultiTenancyEnabled.booleanValue()) {
            return null;
        }
        Map headers = restRequest.getHeaders();
        List tenantIdList = (List)headers.get("x-tenant-id");
        if (tenantIdList == null || tenantIdList.isEmpty()) {
            throw new FlowFrameworkException("Tenant ID header is missing or has no value", RestStatus.FORBIDDEN);
        }
        String tenantId = (String)tenantIdList.get(0);
        if (tenantId == null) {
            throw new FlowFrameworkException("Tenant ID can't be null", RestStatus.FORBIDDEN);
        }
        return tenantId;
    }
}

