/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs;

import java.io.IOException;
import java.time.Instant;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.ml.jobs.MLBatchTaskUpdateJobParameter;
import org.opensearch.ml.jobs.MLBatchTaskUpdateJobRunner;

public class MLBatchTaskUpdateExtension
implements JobSchedulerExtension {
    public String getJobType() {
        return "checkBatchJobTaskStatus";
    }

    public ScheduledJobRunner getJobRunner() {
        return MLBatchTaskUpdateJobRunner.getJobRunnerInstance();
    }

    public ScheduledJobParser getJobParser() {
        return (parser, id, jobDocVersion) -> {
            MLBatchTaskUpdateJobParameter jobParameter = new MLBatchTaskUpdateJobParameter();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            block18: while (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
                String fieldName = parser.currentName();
                parser.nextToken();
                switch (fieldName) {
                    case "name": {
                        jobParameter.setJobName(parser.text());
                        continue block18;
                    }
                    case "enabled": {
                        jobParameter.setEnabled(parser.booleanValue());
                        continue block18;
                    }
                    case "enabled_time": {
                        jobParameter.setEnabledTime(this.parseInstantValue(parser));
                        continue block18;
                    }
                    case "last_update_time": {
                        jobParameter.setLastUpdateTime(this.parseInstantValue(parser));
                        continue block18;
                    }
                    case "schedule": {
                        jobParameter.setSchedule(ScheduleParser.parse((XContentParser)parser));
                        continue block18;
                    }
                    case "lock_duration_seconds": {
                        jobParameter.setLockDurationSeconds(parser.longValue());
                        continue block18;
                    }
                    case "jitter": {
                        jobParameter.setJitter(parser.doubleValue());
                        continue block18;
                    }
                }
                XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
            }
            return jobParameter;
        };
    }

    private Instant parseInstantValue(XContentParser parser) throws IOException {
        if (XContentParser.Token.VALUE_NULL.equals((Object)parser.currentToken())) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
        return null;
    }

    public String getJobIndex() {
        return ".ml_commons_task_polling_job";
    }
}

