/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportRegisterAgentAction
extends HandledTransportAction<ActionRequest, MLRegisterAgentResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterAgentAction.class);
    MLIndicesHandler mlIndicesHandler;
    Client client;
    SdkClient sdkClient;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterAgentAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, MLIndicesHandler mlIndicesHandler, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/agents/register", transportService, actionFilters, MLRegisterAgentRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterAgentResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        MLRegisterAgentRequest registerAgentRequest = MLRegisterAgentRequest.fromActionRequest((ActionRequest)request);
        MLAgent mlAgent = registerAgentRequest.getMlAgent();
        this.registerAgent(mlAgent, listener);
    }

    private void registerAgent(MLAgent agent, ActionListener<MLRegisterAgentResponse> listener) {
        Instant now = Instant.now();
        boolean isHiddenAgent = RestActionUtils.isSuperAdminUser(this.clusterService, this.client);
        MLAgent mlAgent = agent.toBuilder().createdTime(now).lastUpdateTime(now).isHidden(Boolean.valueOf(isHiddenAgent)).build();
        String tenantId = agent.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, listener)) {
            return;
        }
        this.mlIndicesHandler.initMLAgentIndex(ActionListener.wrap(result -> {
            if (result.booleanValue()) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-agent")).tenantId(tenantId)).dataObject((ToXContentObject)mlAgent).build()).whenComplete((r, throwable) -> {
                        context.restore();
                        if (throwable != null) {
                            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            log.error("Failed to index ML agent", (Throwable)cause);
                            listener.onFailure(cause);
                        } else {
                            try {
                                IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)r.parser());
                                log.info("Agent creation result: {}, Agent id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                                MLRegisterAgentResponse response = new MLRegisterAgentResponse(r.id());
                                listener.onResponse((Object)response);
                            }
                            catch (Exception e) {
                                listener.onFailure(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Failed to index ML agent", (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                log.error("Failed to create ML agent index");
                listener.onFailure((Exception)new OpenSearchException("Failed to create ML agent index", new Object[0]));
            }
        }, e -> {
            log.error("Failed to create ML agent index", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

