/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.id.AsynchronousSearchId;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchProgressListener;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchTimeoutWrapper;
import org.opensearch.search.asynchronous.listener.PrioritizedActionListener;
import org.opensearch.search.asynchronous.request.GetAsynchronousSearchRequest;
import org.opensearch.search.asynchronous.response.AsynchronousSearchResponse;
import org.opensearch.search.asynchronous.service.AsynchronousSearchService;
import org.opensearch.search.asynchronous.transport.TransportAsynchronousSearchRoutingAction;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetAsynchronousSearchAction
extends TransportAsynchronousSearchRoutingAction<GetAsynchronousSearchRequest, AsynchronousSearchResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetAsynchronousSearchAction.class);
    private final ThreadPool threadPool;
    private final AsynchronousSearchService asynchronousSearchService;

    @Inject
    public TransportGetAsynchronousSearchAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AsynchronousSearchService asynchronousSearchService, Client client) {
        super(transportService, clusterService, threadPool, client, "cluster:admin/opendistro/asynchronous_search/get", actionFilters, asynchronousSearchService, GetAsynchronousSearchRequest::new, AsynchronousSearchResponse::new);
        this.threadPool = threadPool;
        this.asynchronousSearchService = asynchronousSearchService;
    }

    @Override
    public void handleRequest(AsynchronousSearchId asynchronousSearchId, GetAsynchronousSearchRequest request, ActionListener<AsynchronousSearchResponse> listener, User user) {
        try {
            boolean updateNeeded;
            boolean bl = updateNeeded = request.getKeepAlive() != null;
            if (updateNeeded) {
                this.asynchronousSearchService.updateKeepAliveAndGetContext(request.getId(), request.getKeepAlive(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<AsynchronousSearchContext>)ActionListener.wrap(context -> this.handleWaitForCompletion((AsynchronousSearchContext)context, request, listener), e -> {
                    logger.debug(() -> new ParameterizedMessage("Unable to update and get asynchronous search request [{}]", (Object)asynchronousSearchId), (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                this.asynchronousSearchService.findContext(request.getId(), asynchronousSearchId.getAsynchronousSearchContextId(), user, (ActionListener<AsynchronousSearchContext>)ActionListener.wrap(context -> this.handleWaitForCompletion((AsynchronousSearchContext)context, request, listener), e -> {
                    logger.debug(() -> new ParameterizedMessage("Unable to get asynchronous search [{}]", (Object)asynchronousSearchId), (Throwable)e);
                    listener.onFailure(e);
                }));
            }
        }
        catch (Exception e2) {
            logger.error(() -> new ParameterizedMessage("Unable to update and get asynchronous search [{}]", (Object)request.getId()), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private void handleWaitForCompletion(AsynchronousSearchContext context, GetAsynchronousSearchRequest request, ActionListener<AsynchronousSearchResponse> listener) {
        if (context.isRunning() && request.getWaitForCompletionTimeout() != null) {
            logger.debug("Context is running for asynchronous search id [{}]", (Object)context.getAsynchronousSearchId());
            AsynchronousSearchProgressListener progressActionListener = context.getAsynchronousSearchProgressListener();
            assert (progressActionListener != null) : "progress listener cannot be null";
            PrioritizedActionListener<AsynchronousSearchResponse> wrappedListener = AsynchronousSearchTimeoutWrapper.wrapScheduledTimeout(this.threadPool, request.getWaitForCompletionTimeout(), "opensearch_asynchronous_search_generic", listener, actionListener -> {
                progressActionListener.searchProgressActionListener().removeListener((ActionListener<AsynchronousSearchResponse>)actionListener);
                listener.onResponse((Object)context.getAsynchronousSearchResponse());
            });
            progressActionListener.searchProgressActionListener().addOrExecuteListener(wrappedListener);
        } else {
            logger.debug("Context is not running for asynchronous search id [{}]", (Object)context.getAsynchronousSearchId());
            listener.onResponse((Object)context.getAsynchronousSearchResponse());
        }
    }
}

