/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.rest.AbstractAnomalyDetectorAction;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.model.ConfigValidationIssue;
import org.opensearch.timeseries.rest.RestValidateAction;
import org.opensearch.timeseries.transport.ValidateConfigRequest;

public class RestValidateAnomalyDetectorAction
extends AbstractAnomalyDetectorAction {
    private static final String VALIDATE_ANOMALY_DETECTOR_ACTION = "validate_anomaly_detector_action";
    private RestValidateAction validateAction;

    public RestValidateAnomalyDetectorAction(Settings settings, ClusterService clusterService) {
        super(settings, clusterService);
        this.validateAction = new RestValidateAction(AnalysisType.AD, this.maxSingleEntityDetectors, this.maxMultiEntityDetectors, this.maxAnomalyFeatures, this.maxCategoricalFields, this.requestTimeout);
    }

    public String getName() {
        return VALIDATE_ANOMALY_DETECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s", "/_plugins/_anomaly_detection/detectors", "_validate")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "_validate", "type")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String typesStr = request.param("type");
        return channel -> {
            try {
                ValidateConfigRequest validateAnomalyDetectorRequest = this.validateAction.prepareRequest(request, client, typesStr);
                client.execute((ActionType)ValidateAnomalyDetectorAction.INSTANCE, (ActionRequest)validateAnomalyDetectorRequest, (ActionListener)new RestToXContentListener(channel));
            }
            catch (Exception ex) {
                if (ex instanceof ValidationException) {
                    ValidationException adException = (ValidationException)ex;
                    ConfigValidationIssue issue = new ConfigValidationIssue(adException.getAspect(), adException.getType(), adException.getMessage());
                    this.validateAction.sendValidationParseResponse(issue, (RestChannel)channel);
                }
                throw ex;
            }
        };
    }
}

