/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.cursor;

import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.opensearch.OpenSearchException;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.cursor.CursorType;
import org.opensearch.sql.legacy.cursor.DefaultCursor;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.executor.Format;
import org.opensearch.sql.legacy.executor.cursor.CursorRestExecutor;
import org.opensearch.sql.legacy.executor.format.Protocol;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.pit.PointInTimeHandlerImpl;
import org.opensearch.sql.legacy.rewriter.matchtoterm.VerificationException;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;

public class CursorResultExecutor
implements CursorRestExecutor {
    private String cursorId;
    private Format format;
    private static final Logger LOG = LogManager.getLogger(CursorResultExecutor.class);

    public CursorResultExecutor(String cursorId, Format format) {
        this.cursorId = cursorId;
        this.format = format;
    }

    @Override
    public void execute(Client client, Map<String, String> params, RestChannel channel) throws Exception {
        try {
            String formattedResponse = this.execute(client, params);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", formattedResponse));
        }
        catch (IllegalArgumentException | JSONException e) {
            Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
            LOG.error("Error parsing the cursor", e);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "application/json; charset=UTF-8", ErrorMessageFactory.createErrorMessage((Throwable)new IllegalArgumentException("Malformed cursor: unable to extract cursor information"), (int)RestStatus.BAD_REQUEST.getStatus()).toString()));
        }
        catch (OpenSearchException e) {
            int status = e.status().getStatus();
            if (status > 399 && status < 500) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_CUS).increment();
            } else if (status > 499) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
            }
            LOG.error("Error completing cursor request", (Throwable)e);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)((Object)e)));
        }
    }

    @Override
    public String execute(Client client, Map<String, String> params) throws Exception {
        String[] splittedCursor = this.cursorId.split(":", 2);
        if (splittedCursor.length != 2) {
            throw new VerificationException("Not able to parse invalid cursor");
        }
        String type = splittedCursor[0];
        CursorType cursorType = CursorType.getById(type);
        switch (cursorType) {
            case DEFAULT: {
                DefaultCursor defaultCursor = DefaultCursor.from(splittedCursor[1]);
                return this.handleDefaultCursorRequest(client, defaultCursor);
            }
        }
        throw new VerificationException("Unsupported cursor type [" + type + "]");
    }

    private String handleDefaultCursorRequest(Client client, DefaultCursor cursor) {
        LocalClusterState clusterState = LocalClusterState.state();
        TimeValue paginationTimeout = (TimeValue)clusterState.getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        SearchResponse scrollResponse = null;
        if (((Boolean)clusterState.getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
            String pitId = cursor.getPitId();
            SearchSourceBuilder source = cursor.getSearchSourceBuilder();
            source.searchAfter(cursor.getSortFields());
            source.pointInTimeBuilder(new PointInTimeBuilder(pitId));
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.source(source);
            scrollResponse = (SearchResponse)client.search(searchRequest).actionGet();
        } else {
            String previousScrollId = cursor.getScrollId();
            scrollResponse = (SearchResponse)client.prepareSearchScroll(previousScrollId).setScroll(paginationTimeout).get();
        }
        SearchHits searchHits = scrollResponse.getHits();
        SearchHit[] searchHitArray = searchHits.getHits();
        String newScrollId = scrollResponse.getScrollId();
        String newPitId = scrollResponse.pointInTimeId();
        int rowsLeft = (int)cursor.getRowsLeft();
        int fetch = cursor.getFetchSize();
        if (rowsLeft < fetch && rowsLeft < searchHitArray.length) {
            SearchHit[] newSearchHits = Arrays.copyOf(searchHitArray, rowsLeft);
            searchHits = new SearchHits(newSearchHits, searchHits.getTotalHits(), searchHits.getMaxScore());
        }
        if ((rowsLeft -= fetch) <= 0) {
            ClearScrollResponse clearScrollResponse;
            if (newScrollId != null && !(clearScrollResponse = (ClearScrollResponse)client.prepareClearScroll().addScrollId(newScrollId).get()).isSucceeded()) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.info("Error closing the cursor context {} ", (Object)newScrollId);
            }
            if (newPitId != null) {
                PointInTimeHandlerImpl pit = new PointInTimeHandlerImpl(client, newPitId);
                try {
                    pit.delete();
                }
                catch (RuntimeException e) {
                    Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                    LOG.info("Error deleting point in time {} ", (Object)newPitId);
                }
            }
        }
        cursor.setRowsLeft(rowsLeft);
        if (((Boolean)clusterState.getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
            cursor.setPitId(newPitId);
            cursor.setSearchSourceBuilder(cursor.getSearchSourceBuilder());
            cursor.setSortFields(scrollResponse.getHits().getAt(scrollResponse.getHits().getHits().length - 1).getSortValues());
        } else {
            cursor.setScrollId(newScrollId);
        }
        Protocol protocol = new Protocol(client, searchHits, this.format.name().toLowerCase(), cursor);
        return protocol.cursorFormat();
    }
}

