/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.util.LogWrapper;

public class DenylistLatch {
    private final Semaphore internalSemaphore;
    private final int count;
    private final long timeout;
    private final List<HandlerTask> handlerTasks;

    public DenylistLatch(int count, long timeout) {
        this.handlerTasks = new ArrayList<HandlerTask>(count);
        this.count = count;
        this.timeout = timeout;
        this.internalSemaphore = new Semaphore(count);
        this.internalSemaphore.drainPermits();
    }

    public void countDown() {
        this.internalSemaphore.release();
    }

    public void addToDenylistCheck(HandlerTask task) {
        this.handlerTasks.add(task);
    }

    public void awaitAndDenylistCheck() {
        try {
            while (!this.internalSemaphore.tryAcquire(this.count, this.timeout, TimeUnit.MILLISECONDS)) {
                for (HandlerTask currentTask : this.handlerTasks) {
                    currentTask.checkForDenylist();
                }
            }
        }
        catch (InterruptedException e) {
            LogWrapper.getLogger().log(2, "Event Task Processing Interrupted. Events may not be received in proper order.");
        }
    }
}

