/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Timer;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.openide.util.Mutex;

public final class ResultsModel
extends AbstractListModel
implements ActionListener {
    private static ResultsModel instance;
    private List<PopupItem> results;
    private Timer fireTimer;
    static final int COALESCE_TIME = 200;
    private Map<RepositoryImpl, Set<IssueImpl>> issuesCached = new HashMap<RepositoryImpl, Set<IssueImpl>>();

    private ResultsModel() {
    }

    public static ResultsModel getInstance() {
        if (instance == null) {
            instance = new ResultsModel();
        }
        return instance;
    }

    void setContent(final List<PopupItem> results) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ResultsModel.this.results = results;
                ResultsModel.this.maybeFireChanges();
            }
        });
    }

    synchronized void cacheIssues(RepositoryImpl repo, Collection<IssueImpl> issues) {
        HashSet<IssueImpl> s = new HashSet<IssueImpl>();
        for (IssueImpl issue : issues) {
            assert (issue != null);
            s.add(issue);
        }
        this.issuesCached.put(repo, s);
    }

    synchronized Collection<IssueImpl> getCachedIssues(RepositoryImpl repo) {
        Set<IssueImpl> s;
        if (this.issuesCached != null && (s = this.issuesCached.get(repo)) != null) {
            return s;
        }
        return Collections.emptyList();
    }

    @Override
    public int getSize() {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (this.results == null) {
            return null;
        }
        return this.results.get(index);
    }

    private void maybeFireChanges() {
        if (this.fireTimer == null) {
            this.fireTimer = new Timer(200, this);
        }
        if (!this.fireTimer.isRunning()) {
            this.fireTimer.start();
        } else {
            this.fireTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireTimer.stop();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

