/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Feature implements Api
{
    LOOM("Loom", "loom"),
    PANAMA("Panama", "panama"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Feature(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Feature getDefault() {
        return NONE;
    }

    @Override
    public Feature getNotFound() {
        return NOT_FOUND;
    }

    public Feature[] getAll() {
        return Feature.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static Feature fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "loom": 
            case "LOOM": 
            case "Loom": {
                return LOOM;
            }
            case "panama": 
            case "PANAMA": 
            case "Panama": {
                return PANAMA;
            }
        }
        return NOT_FOUND;
    }

    public static List<Feature> getAsList() {
        return Arrays.asList(Feature.values());
    }
}

