/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.cdi.CdiUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class WebsocketUserManager {
    private static final int ESTIMATED_USER_CHANNELS_PER_APPLICATION = 1;
    private static final int ESTIMATED_USER_CHANNELS_PER_SESSION = 1;
    private static final int ESTIMATED_SESSIONS_PER_USER = 2;
    private static final int ESTIMATED_CHANNELS_IDS_PER_USER = 2;
    private final ConcurrentMap<String, ConcurrentMap<String, Set<String>>> userChannels = new ConcurrentHashMap<String, ConcurrentMap<String, Set<String>>>();
    private final ConcurrentMap<Serializable, Set<String>> applicationUsers = new ConcurrentHashMap<Serializable, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(Serializable user, String userId) {
        ConcurrentMap<Serializable, Set<String>> concurrentMap = this.applicationUsers;
        synchronized (concurrentMap) {
            if (!this.applicationUsers.containsKey(user)) {
                this.applicationUsers.putIfAbsent(user, Collections.synchronizedSet(new HashSet(2)));
            }
            ((Set)this.applicationUsers.get(user)).add(userId);
        }
    }

    protected void addChannelId(String userId, String channel, String channelId) {
        ConcurrentMap channelIds;
        if (!this.userChannels.containsKey(userId)) {
            this.userChannels.putIfAbsent(userId, new ConcurrentHashMap(1));
        }
        if (!(channelIds = (ConcurrentMap)this.userChannels.get(userId)).containsKey(channel)) {
            channelIds.putIfAbsent(channel, Collections.synchronizedSet(new HashSet(1)));
        }
        ((Set)channelIds.get(channel)).add(channelId);
    }

    protected Serializable getUser(String channel, String channelId) {
        for (Map.Entry applicationUser : this.applicationUsers.entrySet()) {
            for (String userId : (Set)applicationUser.getValue()) {
                if (!this.getApplicationUserChannelIds(userId, channel).contains(channelId)) continue;
                return (Serializable)applicationUser.getKey();
            }
        }
        return null;
    }

    protected Set<String> getChannelIds(Serializable user, String channel) {
        HashSet<String> channelIds = new HashSet<String>(2);
        Set userIds = (Set)this.applicationUsers.get(user);
        if (userIds != null) {
            for (String userId : userIds) {
                channelIds.addAll(this.getApplicationUserChannelIds(userId, channel));
            }
        }
        return channelIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(Serializable user, String userId) {
        this.userChannels.remove(userId);
        ConcurrentMap<Serializable, Set<String>> concurrentMap = this.applicationUsers;
        synchronized (concurrentMap) {
            Set userIds = (Set)this.applicationUsers.get(user);
            userIds.remove(userId);
            if (userIds.isEmpty()) {
                this.applicationUsers.remove(user);
            }
        }
    }

    static ConcurrentMap<String, ConcurrentMap<String, Set<String>>> getUserChannels() {
        return CdiUtils.getBeanInstance(WebsocketUserManager.class, (boolean)true).userChannels;
    }

    private Set<String> getApplicationUserChannelIds(String userId, String channel) {
        Set channelIds;
        Map channels = (Map)this.userChannels.get(userId);
        if (channels != null && (channelIds = (Set)channels.get(channel)) != null) {
            return channelIds;
        }
        return Collections.emptySet();
    }
}

