/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.Demuxer;
import org.netbeans.modules.docker.Endpoint;
import org.netbeans.modules.docker.StreamItem;
import org.netbeans.modules.docker.StreamResult;

public class MuxedStreamResult
implements StreamResult {
    private static final Logger LOGGER = Logger.getLogger(MuxedStreamResult.class.getName());
    private final Endpoint s;
    private final Charset charset;
    private final OutputStream outputStream;
    private final Demuxer demultiplexer;
    private final InputStream stdOut;
    private final InputStream stdErr;
    private StreamItem last = StreamItem.EMPTY;

    public MuxedStreamResult(Endpoint s, Charset charset, InputStream is) throws IOException {
        this.s = s;
        this.charset = charset;
        this.outputStream = s.getOutputStream();
        this.demultiplexer = new Demuxer(is == null ? s.getInputStream() : is);
        this.stdOut = new ResultInputStream(false);
        this.stdErr = new ResultInputStream(true);
    }

    @Override
    public OutputStream getStdIn() {
        return this.outputStream;
    }

    @Override
    public InputStream getStdOut() {
        return this.stdOut;
    }

    @Override
    public InputStream getStdErr() {
        return this.stdErr;
    }

    @Override
    public boolean hasTty() {
        return false;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void close() {
        try {
            this.s.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
    }

    private class ResultInputStream
    extends InputStream {
        private final boolean error;

        public ResultInputStream(boolean error) {
            this.error = error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) {
            MuxedStreamResult muxedStreamResult = MuxedStreamResult.this;
            synchronized (muxedStreamResult) {
                int size = this.fetchData();
                if (size <= 0) {
                    return size;
                }
                int limit = Math.min(len, MuxedStreamResult.this.last.getData().remaining());
                MuxedStreamResult.this.last.getData().get(b, off, limit);
                return limit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            MuxedStreamResult muxedStreamResult = MuxedStreamResult.this;
            synchronized (muxedStreamResult) {
                int size = this.fetchData();
                if (size <= 0) {
                    return size;
                }
                return MuxedStreamResult.this.last.getData().get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int fetchData() {
            MuxedStreamResult muxedStreamResult = MuxedStreamResult.this;
            synchronized (muxedStreamResult) {
                try {
                    if (MuxedStreamResult.this.last == null) {
                        int n = -1;
                        return n;
                    }
                    while (!MuxedStreamResult.this.last.getData().hasRemaining()) {
                        MuxedStreamResult.this.last = MuxedStreamResult.this.demultiplexer.fetch();
                        if (MuxedStreamResult.this.last != null) continue;
                        int n = -1;
                        return n;
                    }
                }
                finally {
                    MuxedStreamResult.this.notifyAll();
                }
                try {
                    while (MuxedStreamResult.this.last != null && MuxedStreamResult.this.last.isError() != this.error) {
                        MuxedStreamResult.this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (MuxedStreamResult.this.last == null) {
                    return -1;
                }
                return MuxedStreamResult.this.last.getData().remaining();
            }
        }
    }
}

