/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.project.RunOptionsModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JShellOptions
extends JPanel
implements ItemListener {
    private RunOptionsModel model;
    private Project project;
    private boolean updating = false;
    private ButtonGroup buttonGroup1;
    private JCheckBox checkEnable;
    private JPanel classLoaderOptions;
    private JTextField className;
    private JRadioButton loaderClass;
    private JRadioButton loaderGet;
    private JRadioButton loaderSystem;
    private JTextField methodName;

    public JShellOptions(RunOptionsModel model, Project project) {
        this.model = model;
        this.project = project;
        this.initComponents();
        this.updateValues();
        this.enableDisable();
        this.loaderClass.addItemListener(this);
        this.loaderSystem.addItemListener(this);
        this.loaderGet.addItemListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.checkEnable = new JCheckBox();
        this.classLoaderOptions = new JPanel();
        this.loaderSystem = new JRadioButton();
        this.loaderClass = new JRadioButton();
        this.loaderGet = new JRadioButton();
        this.methodName = new JTextField();
        this.className = new JTextField();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkEnable, (String)NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.checkEnable.text"));
        this.checkEnable.setBorder(null);
        this.checkEnable.setLabel(NbBundle.getMessage(JShellOptions.class, (String)"CHECK_EnableJShell"));
        this.checkEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JShellOptions.this.checkEnableActionPerformed(evt);
            }
        });
        this.add((Component)this.checkEnable, new GridBagConstraints());
        this.classLoaderOptions.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.classLoaderOptions.border.title")));
        this.buttonGroup1.add(this.loaderSystem);
        this.loaderSystem.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.loaderSystem, (String)NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.loaderSystem.text"));
        this.buttonGroup1.add(this.loaderClass);
        Mnemonics.setLocalizedText((AbstractButton)this.loaderClass, (String)NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.loaderClass.text"));
        this.buttonGroup1.add(this.loaderGet);
        Mnemonics.setLocalizedText((AbstractButton)this.loaderGet, (String)NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.loaderGet.text"));
        this.methodName.setText(NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.methodName.text"));
        this.methodName.setEnabled(false);
        this.className.setText(NbBundle.getMessage(JShellOptions.class, (String)"JShellOptions.className.text"));
        this.className.setEnabled(false);
        GroupLayout classLoaderOptionsLayout = new GroupLayout(this.classLoaderOptions);
        this.classLoaderOptions.setLayout(classLoaderOptionsLayout);
        classLoaderOptionsLayout.setHorizontalGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(classLoaderOptionsLayout.createSequentialGroup().addContainerGap().addGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loaderSystem).addGroup(classLoaderOptionsLayout.createSequentialGroup().addGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loaderGet).addComponent(this.loaderClass)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.className, -1, 230, Short.MAX_VALUE).addComponent(this.methodName)))).addContainerGap(21, Short.MAX_VALUE)));
        classLoaderOptionsLayout.setVerticalGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(classLoaderOptionsLayout.createSequentialGroup().addContainerGap().addComponent(this.loaderSystem).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loaderClass).addComponent(this.className, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(classLoaderOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loaderGet).addComponent(this.methodName, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 9;
        gridBagConstraints.ipady = 21;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 20, 0);
        this.add((Component)this.classLoaderOptions, gridBagConstraints);
    }

    private void checkEnableActionPerformed(ActionEvent evt) {
        boolean enable = this.checkEnable.isSelected();
        this.model.setJshellEnabled(enable);
        this.enableDisable();
    }

    private void updateValues() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        RunOptionsModel.LoaderPolicy pol = this.model.getPolicy();
        String cn = this.model.getLoadClassName();
        Object eval = this.model.getFieldName();
        if (cn == null) {
            pol = RunOptionsModel.LoaderPolicy.SYSTEM;
        } else if (eval != null) {
            eval = cn + "." + (String)eval;
        } else {
            eval = this.model.getMethodName();
            if (eval != null) {
                eval = cn + "." + (String)eval + "()";
            }
        }
        if (pol == RunOptionsModel.LoaderPolicy.EVAL && eval == null) {
            pol = RunOptionsModel.LoaderPolicy.CLASS;
        }
        switch (pol) {
            case CLASS: {
                this.className.setText(cn);
                this.loaderClass.setSelected(true);
                break;
            }
            case EVAL: {
                this.loaderGet.setSelected(true);
                break;
            }
            case SYSTEM: {
                this.loaderSystem.setSelected(true);
            }
        }
        this.updating = false;
        this.enableDisable();
    }

    private void enableDisable() {
        if (this.model.isJshellEnabled()) {
            this.classLoaderOptions.setVisible(true);
            switch (this.model.getPolicy()) {
                case CLASS: {
                    this.className.setEnabled(true);
                    this.methodName.setEnabled(false);
                    break;
                }
                case SYSTEM: {
                    this.className.setEnabled(false);
                    this.methodName.setEnabled(false);
                    break;
                }
                case EVAL: {
                    this.className.setEnabled(false);
                    this.methodName.setEnabled(true);
                }
            }
        } else {
            this.classLoaderOptions.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        RunOptionsModel.LoaderPolicy pol;
        if (this.loaderSystem.isSelected()) {
            pol = RunOptionsModel.LoaderPolicy.SYSTEM;
        } else if (this.loaderClass.isSelected()) {
            pol = RunOptionsModel.LoaderPolicy.CLASS;
        } else if (this.loaderGet.isSelected()) {
            pol = RunOptionsModel.LoaderPolicy.EVAL;
        } else {
            return;
        }
        this.model.setPolicy(pol);
        this.enableDisable();
    }
}

