/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.EstimatedPatchingTime;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaintenanceRun
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeScheduled")
    private final Date timeScheduled;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="targetResourceType")
    private final TargetResourceType targetResourceType;
    @JsonProperty(value="targetResourceId")
    private final String targetResourceId;
    @JsonProperty(value="maintenanceType")
    private final MaintenanceType maintenanceType;
    @JsonProperty(value="patchId")
    private final String patchId;
    @JsonProperty(value="maintenanceSubtype")
    private final MaintenanceSubtype maintenanceSubtype;
    @JsonProperty(value="peerMaintenanceRunId")
    private final String peerMaintenanceRunId;
    @JsonProperty(value="patchingMode")
    private final PatchingMode patchingMode;
    @JsonProperty(value="patchFailureCount")
    private final Integer patchFailureCount;
    @JsonProperty(value="targetDbServerVersion")
    private final String targetDbServerVersion;
    @JsonProperty(value="targetStorageServerVersion")
    private final String targetStorageServerVersion;
    @JsonProperty(value="isCustomActionTimeoutEnabled")
    private final Boolean isCustomActionTimeoutEnabled;
    @JsonProperty(value="customActionTimeoutInMins")
    private final Integer customActionTimeoutInMins;
    @JsonProperty(value="currentCustomActionTimeoutInMins")
    private final Integer currentCustomActionTimeoutInMins;
    @JsonProperty(value="patchingStatus")
    private final PatchingStatus patchingStatus;
    @JsonProperty(value="patchingStartTime")
    private final Date patchingStartTime;
    @JsonProperty(value="patchingEndTime")
    private final Date patchingEndTime;
    @JsonProperty(value="estimatedPatchingTime")
    private final EstimatedPatchingTime estimatedPatchingTime;
    @JsonProperty(value="currentPatchingComponent")
    private final String currentPatchingComponent;
    @JsonProperty(value="estimatedComponentPatchingStartTime")
    private final Date estimatedComponentPatchingStartTime;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "lifecycleState", "lifecycleDetails", "timeScheduled", "timeStarted", "timeEnded", "targetResourceType", "targetResourceId", "maintenanceType", "patchId", "maintenanceSubtype", "peerMaintenanceRunId", "patchingMode", "patchFailureCount", "targetDbServerVersion", "targetStorageServerVersion", "isCustomActionTimeoutEnabled", "customActionTimeoutInMins", "currentCustomActionTimeoutInMins", "patchingStatus", "patchingStartTime", "patchingEndTime", "estimatedPatchingTime", "currentPatchingComponent", "estimatedComponentPatchingStartTime"})
    public MaintenanceRun(String id, String compartmentId, String displayName, String description, LifecycleState lifecycleState, String lifecycleDetails, Date timeScheduled, Date timeStarted, Date timeEnded, TargetResourceType targetResourceType, String targetResourceId, MaintenanceType maintenanceType, String patchId, MaintenanceSubtype maintenanceSubtype, String peerMaintenanceRunId, PatchingMode patchingMode, Integer patchFailureCount, String targetDbServerVersion, String targetStorageServerVersion, Boolean isCustomActionTimeoutEnabled, Integer customActionTimeoutInMins, Integer currentCustomActionTimeoutInMins, PatchingStatus patchingStatus, Date patchingStartTime, Date patchingEndTime, EstimatedPatchingTime estimatedPatchingTime, String currentPatchingComponent, Date estimatedComponentPatchingStartTime) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeScheduled = timeScheduled;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.targetResourceType = targetResourceType;
        this.targetResourceId = targetResourceId;
        this.maintenanceType = maintenanceType;
        this.patchId = patchId;
        this.maintenanceSubtype = maintenanceSubtype;
        this.peerMaintenanceRunId = peerMaintenanceRunId;
        this.patchingMode = patchingMode;
        this.patchFailureCount = patchFailureCount;
        this.targetDbServerVersion = targetDbServerVersion;
        this.targetStorageServerVersion = targetStorageServerVersion;
        this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
        this.customActionTimeoutInMins = customActionTimeoutInMins;
        this.currentCustomActionTimeoutInMins = currentCustomActionTimeoutInMins;
        this.patchingStatus = patchingStatus;
        this.patchingStartTime = patchingStartTime;
        this.patchingEndTime = patchingEndTime;
        this.estimatedPatchingTime = estimatedPatchingTime;
        this.currentPatchingComponent = currentPatchingComponent;
        this.estimatedComponentPatchingStartTime = estimatedComponentPatchingStartTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeScheduled() {
        return this.timeScheduled;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public MaintenanceType getMaintenanceType() {
        return this.maintenanceType;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public MaintenanceSubtype getMaintenanceSubtype() {
        return this.maintenanceSubtype;
    }

    public String getPeerMaintenanceRunId() {
        return this.peerMaintenanceRunId;
    }

    public PatchingMode getPatchingMode() {
        return this.patchingMode;
    }

    public Integer getPatchFailureCount() {
        return this.patchFailureCount;
    }

    public String getTargetDbServerVersion() {
        return this.targetDbServerVersion;
    }

    public String getTargetStorageServerVersion() {
        return this.targetStorageServerVersion;
    }

    public Boolean getIsCustomActionTimeoutEnabled() {
        return this.isCustomActionTimeoutEnabled;
    }

    public Integer getCustomActionTimeoutInMins() {
        return this.customActionTimeoutInMins;
    }

    public Integer getCurrentCustomActionTimeoutInMins() {
        return this.currentCustomActionTimeoutInMins;
    }

    public PatchingStatus getPatchingStatus() {
        return this.patchingStatus;
    }

    public Date getPatchingStartTime() {
        return this.patchingStartTime;
    }

    public Date getPatchingEndTime() {
        return this.patchingEndTime;
    }

    public EstimatedPatchingTime getEstimatedPatchingTime() {
        return this.estimatedPatchingTime;
    }

    public String getCurrentPatchingComponent() {
        return this.currentPatchingComponent;
    }

    public Date getEstimatedComponentPatchingStartTime() {
        return this.estimatedComponentPatchingStartTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaintenanceRun(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeScheduled=").append(String.valueOf(this.timeScheduled));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", targetResourceType=").append(String.valueOf((Object)this.targetResourceType));
        sb.append(", targetResourceId=").append(String.valueOf(this.targetResourceId));
        sb.append(", maintenanceType=").append(String.valueOf((Object)this.maintenanceType));
        sb.append(", patchId=").append(String.valueOf(this.patchId));
        sb.append(", maintenanceSubtype=").append(String.valueOf((Object)this.maintenanceSubtype));
        sb.append(", peerMaintenanceRunId=").append(String.valueOf(this.peerMaintenanceRunId));
        sb.append(", patchingMode=").append(String.valueOf((Object)this.patchingMode));
        sb.append(", patchFailureCount=").append(String.valueOf(this.patchFailureCount));
        sb.append(", targetDbServerVersion=").append(String.valueOf(this.targetDbServerVersion));
        sb.append(", targetStorageServerVersion=").append(String.valueOf(this.targetStorageServerVersion));
        sb.append(", isCustomActionTimeoutEnabled=").append(String.valueOf(this.isCustomActionTimeoutEnabled));
        sb.append(", customActionTimeoutInMins=").append(String.valueOf(this.customActionTimeoutInMins));
        sb.append(", currentCustomActionTimeoutInMins=").append(String.valueOf(this.currentCustomActionTimeoutInMins));
        sb.append(", patchingStatus=").append(String.valueOf((Object)this.patchingStatus));
        sb.append(", patchingStartTime=").append(String.valueOf(this.patchingStartTime));
        sb.append(", patchingEndTime=").append(String.valueOf(this.patchingEndTime));
        sb.append(", estimatedPatchingTime=").append(String.valueOf((Object)this.estimatedPatchingTime));
        sb.append(", currentPatchingComponent=").append(String.valueOf(this.currentPatchingComponent));
        sb.append(", estimatedComponentPatchingStartTime=").append(String.valueOf(this.estimatedComponentPatchingStartTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenanceRun)) {
            return false;
        }
        MaintenanceRun other = (MaintenanceRun)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeScheduled, other.timeScheduled) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals((Object)this.targetResourceType, (Object)other.targetResourceType) && Objects.equals(this.targetResourceId, other.targetResourceId) && Objects.equals((Object)this.maintenanceType, (Object)other.maintenanceType) && Objects.equals(this.patchId, other.patchId) && Objects.equals((Object)this.maintenanceSubtype, (Object)other.maintenanceSubtype) && Objects.equals(this.peerMaintenanceRunId, other.peerMaintenanceRunId) && Objects.equals((Object)this.patchingMode, (Object)other.patchingMode) && Objects.equals(this.patchFailureCount, other.patchFailureCount) && Objects.equals(this.targetDbServerVersion, other.targetDbServerVersion) && Objects.equals(this.targetStorageServerVersion, other.targetStorageServerVersion) && Objects.equals(this.isCustomActionTimeoutEnabled, other.isCustomActionTimeoutEnabled) && Objects.equals(this.customActionTimeoutInMins, other.customActionTimeoutInMins) && Objects.equals(this.currentCustomActionTimeoutInMins, other.currentCustomActionTimeoutInMins) && Objects.equals((Object)this.patchingStatus, (Object)other.patchingStatus) && Objects.equals(this.patchingStartTime, other.patchingStartTime) && Objects.equals(this.patchingEndTime, other.patchingEndTime) && Objects.equals((Object)this.estimatedPatchingTime, (Object)other.estimatedPatchingTime) && Objects.equals(this.currentPatchingComponent, other.currentPatchingComponent) && Objects.equals(this.estimatedComponentPatchingStartTime, other.estimatedComponentPatchingStartTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeScheduled == null ? 43 : this.timeScheduled.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.targetResourceType == null ? 43 : this.targetResourceType.hashCode());
        result = result * 59 + (this.targetResourceId == null ? 43 : this.targetResourceId.hashCode());
        result = result * 59 + (this.maintenanceType == null ? 43 : this.maintenanceType.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.maintenanceSubtype == null ? 43 : this.maintenanceSubtype.hashCode());
        result = result * 59 + (this.peerMaintenanceRunId == null ? 43 : this.peerMaintenanceRunId.hashCode());
        result = result * 59 + (this.patchingMode == null ? 43 : this.patchingMode.hashCode());
        result = result * 59 + (this.patchFailureCount == null ? 43 : this.patchFailureCount.hashCode());
        result = result * 59 + (this.targetDbServerVersion == null ? 43 : this.targetDbServerVersion.hashCode());
        result = result * 59 + (this.targetStorageServerVersion == null ? 43 : this.targetStorageServerVersion.hashCode());
        result = result * 59 + (this.isCustomActionTimeoutEnabled == null ? 43 : this.isCustomActionTimeoutEnabled.hashCode());
        result = result * 59 + (this.customActionTimeoutInMins == null ? 43 : this.customActionTimeoutInMins.hashCode());
        result = result * 59 + (this.currentCustomActionTimeoutInMins == null ? 43 : this.currentCustomActionTimeoutInMins.hashCode());
        result = result * 59 + (this.patchingStatus == null ? 43 : this.patchingStatus.hashCode());
        result = result * 59 + (this.patchingStartTime == null ? 43 : this.patchingStartTime.hashCode());
        result = result * 59 + (this.patchingEndTime == null ? 43 : this.patchingEndTime.hashCode());
        result = result * 59 + (this.estimatedPatchingTime == null ? 43 : this.estimatedPatchingTime.hashCode());
        result = result * 59 + (this.currentPatchingComponent == null ? 43 : this.currentPatchingComponent.hashCode());
        result = result * 59 + (this.estimatedComponentPatchingStartTime == null ? 43 : this.estimatedComponentPatchingStartTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchingStatus implements BmcEnum
    {
        Patching("PATCHING"),
        Waiting("WAITING"),
        Scheduled("SCHEDULED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchingStatus> map;

        private PatchingStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchingStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchingStatus.class);
            map = new HashMap<String, PatchingStatus>();
            for (PatchingStatus v : PatchingStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PatchingMode implements BmcEnum
    {
        Rolling("ROLLING"),
        Nonrolling("NONROLLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PatchingMode> map;

        private PatchingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PatchingMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PatchingMode.class);
            map = new HashMap<String, PatchingMode>();
            for (PatchingMode v : PatchingMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MaintenanceSubtype implements BmcEnum
    {
        Quarterly("QUARTERLY"),
        Hardware("HARDWARE"),
        Critical("CRITICAL"),
        Infrastructure("INFRASTRUCTURE"),
        Database("DATABASE"),
        Oneoff("ONEOFF"),
        SecurityMonthly("SECURITY_MONTHLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceSubtype> map;

        private MaintenanceSubtype(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceSubtype create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceSubtype', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceSubtype.class);
            map = new HashMap<String, MaintenanceSubtype>();
            for (MaintenanceSubtype v : MaintenanceSubtype.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MaintenanceType implements BmcEnum
    {
        Planned("PLANNED"),
        Unplanned("UNPLANNED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MaintenanceType> map;

        private MaintenanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MaintenanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MaintenanceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MaintenanceType.class);
            map = new HashMap<String, MaintenanceType>();
            for (MaintenanceType v : MaintenanceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TargetResourceType implements BmcEnum
    {
        AutonomousExadataInfrastructure("AUTONOMOUS_EXADATA_INFRASTRUCTURE"),
        AutonomousContainerDatabase("AUTONOMOUS_CONTAINER_DATABASE"),
        ExadataDbSystem("EXADATA_DB_SYSTEM"),
        CloudExadataInfrastructure("CLOUD_EXADATA_INFRASTRUCTURE"),
        ExaccInfrastructure("EXACC_INFRASTRUCTURE"),
        AutonomousVmCluster("AUTONOMOUS_VM_CLUSTER"),
        AutonomousDatabase("AUTONOMOUS_DATABASE"),
        CloudAutonomousVmCluster("CLOUD_AUTONOMOUS_VM_CLUSTER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TargetResourceType> map;

        private TargetResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TargetResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TargetResourceType.class);
            map = new HashMap<String, TargetResourceType>();
            for (TargetResourceType v : TargetResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Scheduled("SCHEDULED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Skipped("SKIPPED"),
        Failed("FAILED"),
        Updating("UPDATING"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeScheduled")
        private Date timeScheduled;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="targetResourceType")
        private TargetResourceType targetResourceType;
        @JsonProperty(value="targetResourceId")
        private String targetResourceId;
        @JsonProperty(value="maintenanceType")
        private MaintenanceType maintenanceType;
        @JsonProperty(value="patchId")
        private String patchId;
        @JsonProperty(value="maintenanceSubtype")
        private MaintenanceSubtype maintenanceSubtype;
        @JsonProperty(value="peerMaintenanceRunId")
        private String peerMaintenanceRunId;
        @JsonProperty(value="patchingMode")
        private PatchingMode patchingMode;
        @JsonProperty(value="patchFailureCount")
        private Integer patchFailureCount;
        @JsonProperty(value="targetDbServerVersion")
        private String targetDbServerVersion;
        @JsonProperty(value="targetStorageServerVersion")
        private String targetStorageServerVersion;
        @JsonProperty(value="isCustomActionTimeoutEnabled")
        private Boolean isCustomActionTimeoutEnabled;
        @JsonProperty(value="customActionTimeoutInMins")
        private Integer customActionTimeoutInMins;
        @JsonProperty(value="currentCustomActionTimeoutInMins")
        private Integer currentCustomActionTimeoutInMins;
        @JsonProperty(value="patchingStatus")
        private PatchingStatus patchingStatus;
        @JsonProperty(value="patchingStartTime")
        private Date patchingStartTime;
        @JsonProperty(value="patchingEndTime")
        private Date patchingEndTime;
        @JsonProperty(value="estimatedPatchingTime")
        private EstimatedPatchingTime estimatedPatchingTime;
        @JsonProperty(value="currentPatchingComponent")
        private String currentPatchingComponent;
        @JsonProperty(value="estimatedComponentPatchingStartTime")
        private Date estimatedComponentPatchingStartTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeScheduled(Date timeScheduled) {
            this.timeScheduled = timeScheduled;
            this.__explicitlySet__.add("timeScheduled");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder targetResourceType(TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            this.__explicitlySet__.add("targetResourceType");
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            this.__explicitlySet__.add("targetResourceId");
            return this;
        }

        public Builder maintenanceType(MaintenanceType maintenanceType) {
            this.maintenanceType = maintenanceType;
            this.__explicitlySet__.add("maintenanceType");
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            this.__explicitlySet__.add("patchId");
            return this;
        }

        public Builder maintenanceSubtype(MaintenanceSubtype maintenanceSubtype) {
            this.maintenanceSubtype = maintenanceSubtype;
            this.__explicitlySet__.add("maintenanceSubtype");
            return this;
        }

        public Builder peerMaintenanceRunId(String peerMaintenanceRunId) {
            this.peerMaintenanceRunId = peerMaintenanceRunId;
            this.__explicitlySet__.add("peerMaintenanceRunId");
            return this;
        }

        public Builder patchingMode(PatchingMode patchingMode) {
            this.patchingMode = patchingMode;
            this.__explicitlySet__.add("patchingMode");
            return this;
        }

        public Builder patchFailureCount(Integer patchFailureCount) {
            this.patchFailureCount = patchFailureCount;
            this.__explicitlySet__.add("patchFailureCount");
            return this;
        }

        public Builder targetDbServerVersion(String targetDbServerVersion) {
            this.targetDbServerVersion = targetDbServerVersion;
            this.__explicitlySet__.add("targetDbServerVersion");
            return this;
        }

        public Builder targetStorageServerVersion(String targetStorageServerVersion) {
            this.targetStorageServerVersion = targetStorageServerVersion;
            this.__explicitlySet__.add("targetStorageServerVersion");
            return this;
        }

        public Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            this.__explicitlySet__.add("isCustomActionTimeoutEnabled");
            return this;
        }

        public Builder customActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
            this.__explicitlySet__.add("customActionTimeoutInMins");
            return this;
        }

        public Builder currentCustomActionTimeoutInMins(Integer currentCustomActionTimeoutInMins) {
            this.currentCustomActionTimeoutInMins = currentCustomActionTimeoutInMins;
            this.__explicitlySet__.add("currentCustomActionTimeoutInMins");
            return this;
        }

        public Builder patchingStatus(PatchingStatus patchingStatus) {
            this.patchingStatus = patchingStatus;
            this.__explicitlySet__.add("patchingStatus");
            return this;
        }

        public Builder patchingStartTime(Date patchingStartTime) {
            this.patchingStartTime = patchingStartTime;
            this.__explicitlySet__.add("patchingStartTime");
            return this;
        }

        public Builder patchingEndTime(Date patchingEndTime) {
            this.patchingEndTime = patchingEndTime;
            this.__explicitlySet__.add("patchingEndTime");
            return this;
        }

        public Builder estimatedPatchingTime(EstimatedPatchingTime estimatedPatchingTime) {
            this.estimatedPatchingTime = estimatedPatchingTime;
            this.__explicitlySet__.add("estimatedPatchingTime");
            return this;
        }

        public Builder currentPatchingComponent(String currentPatchingComponent) {
            this.currentPatchingComponent = currentPatchingComponent;
            this.__explicitlySet__.add("currentPatchingComponent");
            return this;
        }

        public Builder estimatedComponentPatchingStartTime(Date estimatedComponentPatchingStartTime) {
            this.estimatedComponentPatchingStartTime = estimatedComponentPatchingStartTime;
            this.__explicitlySet__.add("estimatedComponentPatchingStartTime");
            return this;
        }

        public MaintenanceRun build() {
            MaintenanceRun model = new MaintenanceRun(this.id, this.compartmentId, this.displayName, this.description, this.lifecycleState, this.lifecycleDetails, this.timeScheduled, this.timeStarted, this.timeEnded, this.targetResourceType, this.targetResourceId, this.maintenanceType, this.patchId, this.maintenanceSubtype, this.peerMaintenanceRunId, this.patchingMode, this.patchFailureCount, this.targetDbServerVersion, this.targetStorageServerVersion, this.isCustomActionTimeoutEnabled, this.customActionTimeoutInMins, this.currentCustomActionTimeoutInMins, this.patchingStatus, this.patchingStartTime, this.patchingEndTime, this.estimatedPatchingTime, this.currentPatchingComponent, this.estimatedComponentPatchingStartTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaintenanceRun model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeScheduled")) {
                this.timeScheduled(model.getTimeScheduled());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("targetResourceType")) {
                this.targetResourceType(model.getTargetResourceType());
            }
            if (model.wasPropertyExplicitlySet("targetResourceId")) {
                this.targetResourceId(model.getTargetResourceId());
            }
            if (model.wasPropertyExplicitlySet("maintenanceType")) {
                this.maintenanceType(model.getMaintenanceType());
            }
            if (model.wasPropertyExplicitlySet("patchId")) {
                this.patchId(model.getPatchId());
            }
            if (model.wasPropertyExplicitlySet("maintenanceSubtype")) {
                this.maintenanceSubtype(model.getMaintenanceSubtype());
            }
            if (model.wasPropertyExplicitlySet("peerMaintenanceRunId")) {
                this.peerMaintenanceRunId(model.getPeerMaintenanceRunId());
            }
            if (model.wasPropertyExplicitlySet("patchingMode")) {
                this.patchingMode(model.getPatchingMode());
            }
            if (model.wasPropertyExplicitlySet("patchFailureCount")) {
                this.patchFailureCount(model.getPatchFailureCount());
            }
            if (model.wasPropertyExplicitlySet("targetDbServerVersion")) {
                this.targetDbServerVersion(model.getTargetDbServerVersion());
            }
            if (model.wasPropertyExplicitlySet("targetStorageServerVersion")) {
                this.targetStorageServerVersion(model.getTargetStorageServerVersion());
            }
            if (model.wasPropertyExplicitlySet("isCustomActionTimeoutEnabled")) {
                this.isCustomActionTimeoutEnabled(model.getIsCustomActionTimeoutEnabled());
            }
            if (model.wasPropertyExplicitlySet("customActionTimeoutInMins")) {
                this.customActionTimeoutInMins(model.getCustomActionTimeoutInMins());
            }
            if (model.wasPropertyExplicitlySet("currentCustomActionTimeoutInMins")) {
                this.currentCustomActionTimeoutInMins(model.getCurrentCustomActionTimeoutInMins());
            }
            if (model.wasPropertyExplicitlySet("patchingStatus")) {
                this.patchingStatus(model.getPatchingStatus());
            }
            if (model.wasPropertyExplicitlySet("patchingStartTime")) {
                this.patchingStartTime(model.getPatchingStartTime());
            }
            if (model.wasPropertyExplicitlySet("patchingEndTime")) {
                this.patchingEndTime(model.getPatchingEndTime());
            }
            if (model.wasPropertyExplicitlySet("estimatedPatchingTime")) {
                this.estimatedPatchingTime(model.getEstimatedPatchingTime());
            }
            if (model.wasPropertyExplicitlySet("currentPatchingComponent")) {
                this.currentPatchingComponent(model.getCurrentPatchingComponent());
            }
            if (model.wasPropertyExplicitlySet("estimatedComponentPatchingStartTime")) {
                this.estimatedComponentPatchingStartTime(model.getEstimatedComponentPatchingStartTime());
            }
            return this;
        }
    }
}

