/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public class VaultItem
extends OCIItem
implements URLProvider {
    private String managementEndpoint;

    public VaultItem(OCID id, String compartment, String name, String managementEndpoint, String tenancyId, String regionCode) {
        super(id, compartment, name, tenancyId, regionCode);
        this.managementEndpoint = managementEndpoint;
    }

    public VaultItem() {
    }

    public String getManagementEndpoint() {
        return this.managementEndpoint;
    }

    @Override
    public int maxInProject() {
        return 1;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/security/kms/vaults/%s?region=%s", this.getKey().getValue(), this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

