/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.compute;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.core.ComputeClient;
import com.oracle.bmc.core.VirtualNetworkClient;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.Vnic;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetVnicRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetVnicResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.compute.Bundle;
import org.netbeans.modules.cloud.oracle.compute.ComputeInstanceItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.Children;

public class ComputeInstanceNode
extends OCINode {
    private static final String COMPUTE_INSTANCE_ICON = "org/netbeans/modules/cloud/oracle/resources/computeinstance.svg";

    public ComputeInstanceNode(ComputeInstanceItem instance) {
        super((OCIItem)instance, Children.LEAF);
        this.setName(instance.getName());
        this.setDisplayName(instance.getName());
        this.setIconBaseWithExtension(COMPUTE_INSTANCE_ICON);
        this.setShortDescription(Bundle.CoputeInstanceDesc(instance.getName(), instance.getPublicIp(), instance.getUsername(), instance.getProcessorDescription()));
    }

    public static NodeProvider<ComputeInstanceItem> createNode() {
        return instance -> {
            ComputeInstanceNode.update(instance);
            return new ComputeInstanceNode((ComputeInstanceItem)instance);
        };
    }

    public static void update(ComputeInstanceItem instance) {
        ComputeClient computeClient = ComputeClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile(instance).getAuthenticationProvider());
        if (instance.getImageId() != null) {
            GetImageRequest request = GetImageRequest.builder().imageId(instance.getImageId()).build();
            GetImageResponse response = computeClient.getImage(request);
            String os = response.getImage().getOperatingSystem();
            if (os.contains("Oracle")) {
                instance.setUsername("opc");
            } else if (os.contains("Ubuntu")) {
                instance.setUsername("ubuntu");
            } else if (os.contains("CentOS")) {
                instance.setUsername("centos");
            } else if (os.contains("Debian")) {
                instance.setUsername("debian");
            } else if (os.contains("Windows")) {
                instance.setUsername("Administrator");
            } else {
                instance.setUsername("opc");
            }
        }
        VirtualNetworkClient virtualNetworkClient = VirtualNetworkClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile(instance).getAuthenticationProvider());
        ListVnicAttachmentsRequest listVnicAttachmentsRequest = ListVnicAttachmentsRequest.builder().compartmentId(instance.getCompartmentId()).instanceId(instance.getKey().getValue()).build();
        ListVnicAttachmentsResponse listVnicAttachmentsResponse = computeClient.listVnicAttachments(listVnicAttachmentsRequest);
        List vnicAttachments = listVnicAttachmentsResponse.getItems();
        for (VnicAttachment vnicAttachment : vnicAttachments) {
            GetVnicRequest getVnicRequest = GetVnicRequest.builder().vnicId(vnicAttachment.getVnicId()).build();
            GetVnicResponse getVnicResponse = virtualNetworkClient.getVnic(getVnicRequest);
            Vnic vnic = getVnicResponse.getVnic();
            if (vnic.getPublicIp() == null) continue;
            instance.setPublicId(vnic.getPublicIp());
        }
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, ComputeInstanceItem> getComputeInstances() {
        return (compartmentId, session) -> {
            ComputeClient client = session.newClient(ComputeClient.class);
            ListInstancesRequest listInstancesRequest = ListInstancesRequest.builder().compartmentId(compartmentId.getKey().getValue()).limit(Integer.valueOf(88)).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            String regionCode = session.getRegion().getRegionCode();
            return client.listInstances(listInstancesRequest).getItems().stream().filter(c -> !c.getLifecycleState().equals((Object)Instance.LifecycleState.Terminated)).filter(c -> !c.getFreeformTags().containsKey("OKEnodePoolName")).map(d -> new ComputeInstanceItem(OCID.of(d.getId(), "ComputeInstance"), compartmentId.getKey().getValue(), d.getDisplayName(), d.getShapeConfig().getProcessorDescription(), d.getImageId(), null, null, tenancyId, regionCode)).collect(Collectors.toList());
        };
    }
}

