/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class ModifiersCheckHintError
extends HintErrorRule {
    private List<Hint> hints;
    private FileObject fileObject;
    private BaseDocument doc;
    private TokenSequence<PHPTokenId> ts;
    private boolean currentClassHasAbstractMethod = false;
    private static final Set<PHPTokenId> MODIFIERS = new HashSet<PHPTokenId>(Arrays.asList(PHPTokenId.PHP_PUBLIC, PHPTokenId.PHP_PROTECTED, PHPTokenId.PHP_PRIVATE, PHPTokenId.PHP_PUBLIC_SET, PHPTokenId.PHP_PROTECTED_SET, PHPTokenId.PHP_PRIVATE_SET, PHPTokenId.PHP_STATIC, PHPTokenId.PHP_READONLY, PHPTokenId.PHP_ABSTRACT, PHPTokenId.PHP_FINAL));

    protected PhpVersion getPhpVersion() {
        return CodeUtils.getPhpVersion(this.fileObject);
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        this.hints = hints;
        this.doc = context.doc;
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        TokenHierarchy tokenHierarchy = phpParseResult.getSnapshot().getTokenHierarchy();
        this.ts = LexUtilities.getPHPTokenSequence(tokenHierarchy, 0);
        if (fileScope != null && this.fileObject != null && this.ts != null) {
            this.ts.moveNext();
            Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(fileScope);
            for (ClassScope classScope : declaredClasses) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processClassScope(classScope);
            }
            for (TraitScope traitScope : ModelUtils.getDeclaredTraits(fileScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTraitScope(traitScope);
            }
            for (EnumScope enumScope : ModelUtils.getDeclaredEnums(fileScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processEnumScope(enumScope);
            }
            Collection<? extends InterfaceScope> declaredInterfaces = ModelUtils.getDeclaredInterfaces(fileScope);
            for (InterfaceScope interfaceScope : declaredInterfaces) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processInterfaceScope(interfaceScope);
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            this.checkReadonlyFieldDeclarationsWithDefaultValue(hints, checkVisitor.getReadonlyFieldDeclarationsWithDefaultValue());
            this.checkDuplicatedClassModifiers(hints, checkVisitor.getDuplicatedClassModifiers());
            this.checkInvalidReadonlyClassAttributes(hints, checkVisitor.getInvalidReadonlyClassAttributes());
        }
    }

    private void checkReadonlyFieldDeclarationsWithDefaultValue(List<Hint> hints, List<SingleFieldDeclaration> fields) {
        for (SingleFieldDeclaration fieldDeclaration : fields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Variable value = fieldDeclaration.getName();
            if (value == null) continue;
            this.addHint(CodeUtils.getOffsetRagne(value), Bundle.ModifiersCheckHintError_realdonlyFieldWithDefaultValue(fieldDeclaration.getName()), hints, Collections.emptyList());
        }
    }

    private void checkDuplicatedClassModifiers(List<Hint> hints, List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> modifiers) {
        for (Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>> modifier : modifiers) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange lastPosition = null;
            for (OffsetRange offsetRange : modifier.getValue()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (lastPosition == null) {
                    lastPosition = offsetRange;
                    continue;
                }
                if (lastPosition.compareTo(offsetRange) > 0) continue;
                lastPosition = offsetRange;
            }
            assert (lastPosition != null);
            this.addHint(lastPosition, Bundle.ModifiersCheckHintError_duplicatedClassModifiers(modifier.getKey().name().toLowerCase()), hints, Collections.singletonList(new RemoveModifierFix(this.doc, modifier.getKey().toString(), lastPosition.getStart(), lastPosition)));
        }
    }

    private void checkInvalidReadonlyClassAttributes(List<Hint> hints, List<Pair<ClassDeclaration, AttributeDeclaration>> invalidReadonlyClassAttributes) {
        for (Pair<ClassDeclaration, AttributeDeclaration> attribute : invalidReadonlyClassAttributes) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addHint(CodeUtils.getOffsetRagne((ASTNode)attribute.second()), Bundle.ModifiersCheckHintError_invalidReadonlyClassAttributes(CodeUtils.extractQualifiedName(((AttributeDeclaration)attribute.second()).getAttributeName()), ((ClassDeclaration)attribute.first()).getName().getName()), hints, Collections.emptyList());
        }
    }

    private void addHint(OffsetRange offsetRange, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, offsetRange, fixes, 500));
    }

    public String getDisplayName() {
        return Bundle.ModifiersCheckHintDispName();
    }

    private void processClassScope(ClassScope classScope) {
        this.processClassModifiers(classScope);
        this.processClassConstants(classScope.getDeclaredConstants());
        this.processFields(classScope.getDeclaredFields(), classScope.isReadonly());
        this.processMethods(classScope.getDeclaredMethods());
        if (this.currentClassHasAbstractMethod) {
            this.processPossibleAbstractClass(classScope);
        }
        this.currentClassHasAbstractMethod = false;
    }

    private void processEnumScope(EnumScope enumScope) {
        this.processClassConstants(enumScope.getDeclaredConstants());
        this.processMethods(enumScope.getDeclaredMethods());
    }

    private void processTraitScope(TraitScope traitScope) {
        if (this.getPhpVersion().hasConstantsInTraits()) {
            this.processClassConstants(traitScope.getDeclaredConstants());
        }
        this.processFields(traitScope.getDeclaredFields());
        this.processMethods(traitScope.getDeclaredMethods());
    }

    private void processClassModifiers(ClassScope classScope) {
        if (classScope.isAbstract() && classScope.isFinal()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "abstract", classScope.getOffset()));
            fixes.add(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidFinalModifierWithAbstractModifier(), classScope.getNameRange(), fixes));
        }
        for (ClassScope classScope2 : classScope.getSuperClasses()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!classScope2.isFinal()) continue;
            this.hints.add(new SimpleHint(Bundle.InvalidClassExtendsFinalClass(classScope.getName(), classScope2.getName()), classScope.getNameRange(), Collections.emptyList()));
            break;
        }
        this.processReadonlyClass(classScope);
    }

    private void processReadonlyClass(ClassScope classScope) {
        if (classScope.isReadonly()) {
            for (ClassScope classScope2 : classScope.getSuperClasses()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (classScope2.isReadonly()) continue;
                List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "readonly", classScope.getOffset()));
                this.hints.add(new SimpleHint(Bundle.InvalidReadonlyClassExtendsNonReadonlyClass(classScope.getName(), classScope2.getName()), classScope.getNameRange(), fixes));
                break;
            }
        } else {
            for (ClassScope classScope3 : classScope.getSuperClasses()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!classScope3.isReadonly()) continue;
                List<HintFix> fixes = Collections.singletonList(new AddModifierFix(this.doc, "readonly", classScope.getOffset()));
                this.hints.add(new SimpleHint(Bundle.InvalidClassExtendsReadonlyClass(classScope.getName(), classScope3.getName()), classScope.getNameRange(), fixes));
                break;
            }
        }
    }

    private void processClassConstants(Collection<? extends ClassConstantElement> declaredConstants) {
        for (ClassConstantElement classConstantElement : declaredConstants) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processClassConstantElement(classConstantElement);
        }
    }

    private void processClassConstantElement(ClassConstantElement constantElement) {
        PhpModifiers phpModifiers = constantElement.getPhpModifiers();
        boolean isFirstConst = this.isFirstConstant(constantElement.getOffset());
        int typeStart = this.getTypeStart(constantElement.getOffset(), constantElement.getDeclaredType());
        if (phpModifiers.isAbstract()) {
            String invalidModifier = "abstract";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidConst(constantElement.getName(), invalidModifier), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (phpModifiers.isFinal() && !this.getPhpVersion().hasFinalConst()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidConst(constantElement.getName(), invalidModifier), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (phpModifiers.isFinal() && phpModifiers.isPrivate()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "final", typeStart));
            fixes.add(new RemoveModifierFix(this.doc, "private", typeStart));
            this.addSimpleHint(Bundle.InvalidPrivateConst(), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (phpModifiers.isStatic()) {
            String invalidModifier = "static";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidConst(constantElement.getName(), invalidModifier), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (phpModifiers.isReadonly()) {
            String invalidModifier = "readonly";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidConst(constantElement.getName(), invalidModifier), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (BodyDeclaration.Modifier.isSetVisibilityModifier(phpModifiers.toFlags())) {
            String invalidModifier = this.getSetVisibility(phpModifiers);
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidConst(constantElement.getName(), invalidModifier), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (this.hasMultipleAccessTypeModifiers(phpModifiers)) {
            List<HintFix> fixes = this.getMultipleAccessTypeModifiersFixes(phpModifiers, typeStart);
            this.addSimpleHint(Bundle.MultipleAccesTypeModifiers(), constantElement.getNameRange(), fixes, isFirstConst);
        } else if (this.hasMultipleSameModifier(typeStart)) {
            String multipleSameModifier = this.getMultipleSameModifiers(this.ts, typeStart);
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, multipleSameModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidMultipleModifiers(multipleSameModifier), constantElement.getNameRange(), fixes, isFirstConst);
        }
    }

    private void addSimpleHint(String description, OffsetRange range, List<HintFix> fixes, boolean isFirstElement) {
        this.hints.add(new SimpleHint(description, range, this.getAvailableFixes(fixes, isFirstElement)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFirstConstant(int startOffset) {
        boolean isFirst = true;
        int originalOffset = this.ts.offset();
        try {
            this.ts.move(startOffset);
            while (this.ts.movePrevious()) {
                if (this.ts.token().id() == PHPTokenId.PHP_CONST) {
                } else {
                    if (this.ts.token().id() != PHPTokenId.PHP_TOKEN || !TokenUtilities.equals((CharSequence)this.ts.token().text(), (Object)",")) continue;
                    isFirst = false;
                }
                break;
            }
        }
        finally {
            this.ts.move(originalOffset);
            this.ts.moveNext();
        }
        return isFirst;
    }

    private List<HintFix> getAvailableFixes(List<HintFix> fixes, boolean isFirstElement) {
        return isFirstElement ? fixes : Collections.emptyList();
    }

    private void processFields(Collection<? extends FieldElement> declaredFields) {
        this.processFields(declaredFields, false);
    }

    private void processFields(Collection<? extends FieldElement> declaredFields, boolean isReadonly) {
        for (FieldElement fieldElement : declaredFields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processFieldElement(fieldElement, isReadonly);
        }
    }

    private void processFieldElement(FieldElement fieldElement, boolean isReadonlyClass) {
        PhpModifiers phpModifiers = fieldElement.getPhpModifiers();
        int typeStart = this.getTypeStart(fieldElement.getOffset() - 1, fieldElement.getDefaultType());
        if (phpModifiers.isAbstract()) {
            String invalidModifier = "abstract";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isFinal() && !this.getPhpVersion().hasFinalProperty()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isFinal() && phpModifiers.isPrivate()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "final", typeStart));
            fixes.add(new RemoveModifierFix(this.doc, "private", typeStart));
            this.hints.add(new SimpleHint(Bundle.InvalidFinalPrivateProperty(), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isStatic() && (phpModifiers.isReadonly() || isReadonlyClass)) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "static", typeStart));
            if (phpModifiers.isReadonly()) {
                fixes.add(new RemoveModifierFix(this.doc, "readonly", typeStart));
            }
            this.hints.add(new SimpleHint(Bundle.InvalidStaticReadonlyProperty(fieldElement.getName()), fieldElement.getNameRange(), fixes));
        } else if ((phpModifiers.isReadonly() || isReadonlyClass) && fieldElement.getDefaultTypeNames().isEmpty()) {
            this.hints.add(new SimpleHint(Bundle.InvalidReadonlyProperty(fieldElement.getName()), fieldElement.getNameRange(), Collections.emptyList()));
        } else if (BodyDeclaration.Modifier.isSetVisibilityModifier(phpModifiers.toFlags()) && fieldElement.getDefaultTypeNames().isEmpty()) {
            this.hints.add(new SimpleHint(Bundle.InvalidEmptyTypeAsymmetricVisiblilityProperty(fieldElement.getName()), fieldElement.getNameRange(), Collections.emptyList()));
        } else if (this.hasMultipleAccessTypeModifiers(phpModifiers)) {
            List<HintFix> fixes = this.getMultipleAccessTypeModifiersFixes(phpModifiers, typeStart);
            this.hints.add(new SimpleHint(Bundle.MultipleAccesTypeModifiers(), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isStatic() && BodyDeclaration.Modifier.isSetVisibilityModifier(phpModifiers.toFlags())) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            String invalidModifier = this.getSetVisibility(phpModifiers);
            fixes.add(new RemoveModifierFix(this.doc, "static", typeStart));
            fixes.add(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.hints.add(new SimpleHint(Bundle.InvalidStaticAsymmetricVisibilityProperty(), fieldElement.getNameRange(), fixes));
        } else if (this.isVisibilityWeakerThanSet(phpModifiers)) {
            String visibility = this.getVisibility(phpModifiers);
            String setVisibility = this.getSetVisibility(phpModifiers);
            this.hints.add(new SimpleHint(Bundle.InvalidAsymmetricProperty(visibility, fieldElement.getName(), setVisibility), fieldElement.getNameRange(), Collections.emptyList()));
        } else if (this.hasMultipleSameModifier(typeStart)) {
            String multipleSameModifier = this.getMultipleSameModifiers(this.ts, typeStart);
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, multipleSameModifier, typeStart));
            this.hints.add(new SimpleHint(Bundle.InvalidMultipleModifiers(multipleSameModifier), fieldElement.getNameRange(), fixes));
        }
    }

    private void processMethods(Collection<? extends MethodScope> declaredMethods) {
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processMethodScope(methodScope);
        }
    }

    private void processMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        Scope inScope = methodScope.getInScope();
        boolean isClass = inScope instanceof ClassScope;
        boolean isAnonClass = isClass && ((ClassScope)inScope).isAnonymous();
        boolean isTrait = inScope instanceof TraitScope;
        boolean isEnum = inScope instanceof EnumScope;
        if (phpModifiers.isAbstract() && isAnonClass) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            if (methodScope.getBlockRange() != null) {
                fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            }
            this.hints.add(new SimpleHint(Bundle.AbstractMethodInAnonymousClass(), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && isEnum) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            if (methodScope.getBlockRange() != null) {
                fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            }
            this.hints.add(new SimpleHint(Bundle.AbstractMethodInEnum(), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && phpModifiers.isFinal()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            if (isClass || isTrait) {
                fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            }
            fixes.add(new RemoveModifierFix(this.doc, "final", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractFinalMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && methodScope.getBlockRange() != null) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.AbstractWithBlockMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && phpModifiers.isPrivate() && !isTrait) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "private", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractPrivateMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isFinal() && phpModifiers.isPrivate()) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "final", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.FinalPrivateMethod(), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isReadonly()) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "readonly", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidMethodModifier(methodScope.getName(), "readonly"), methodScope.getNameRange(), fixes));
        } else if (BodyDeclaration.Modifier.isSetVisibilityModifier(phpModifiers.toFlags())) {
            String invalidModifier = this.getSetVisibility(phpModifiers);
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidMethodModifier(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (this.hasMultipleAccessTypeModifiers(phpModifiers)) {
            List<HintFix> fixes = this.getMultipleAccessTypeModifiersFixes(phpModifiers, methodScope.getOffset());
            this.hints.add(new SimpleHint(Bundle.MultipleAccesTypeModifiers(), methodScope.getNameRange(), fixes));
        } else if (this.hasMultipleSameModifier(methodScope.getOffset())) {
            this.addInvalidMultipleSameModifierHint(methodScope);
        }
        if (phpModifiers.isAbstract() && isClass && !isAnonClass) {
            this.currentClassHasAbstractMethod = true;
        }
    }

    private void addInvalidMultipleSameModifierHint(MethodScope methodScope) {
        String multipleSameModifier = this.getMultipleSameModifiers(this.ts, methodScope.getOffset());
        if (!StringUtils.isEmpty((String)multipleSameModifier)) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, multipleSameModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidMultipleModifiers(multipleSameModifier), methodScope.getNameRange(), fixes));
        }
    }

    private boolean hasMultipleSameModifier(int startOffset) {
        String multipleSameModifier = this.getMultipleSameModifiers(this.ts, startOffset);
        return !StringUtils.isEmpty((String)multipleSameModifier);
    }

    private boolean hasMultipleAccessTypeModifiers(PhpModifiers modifiers) {
        return modifiers.isPublic() && !modifiers.isImplicitPublic() && modifiers.isProtected() || modifiers.isPublic() && !modifiers.isImplicitPublic() && modifiers.isPrivate() || modifiers.isProtected() && modifiers.isPrivate() || modifiers.isPublicSet() && modifiers.isProtectedSet() || modifiers.isPublicSet() && modifiers.isPrivateSet() || modifiers.isProtectedSet() && modifiers.isPrivateSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMultipleSameModifiers(TokenSequence<? extends PHPTokenId> ts, int startOffset) {
        String sameModifier;
        block9: {
            sameModifier = "";
            if (ts != null) {
                int originalOffset = ts.offset();
                try {
                    Token token;
                    ts.move(startOffset);
                    TokenId lastTokenId = null;
                    HashSet<PHPTokenId> tokens = new HashSet<PHPTokenId>();
                    boolean foundModifier = false;
                    while (ts.movePrevious() && (token = ts.token()).id() != PHPTokenId.PHP_SEMICOLON && token.id() != PHPTokenId.PHP_CURLY_CLOSE && token.id() != PHPTokenId.PHP_CURLY_OPEN) {
                        if (!MODIFIERS.contains(token.id()) && token.id() != PHPTokenId.PHP_CLASS && token.id() != PHPTokenId.PHP_FUNCTION && token.id() != PHPTokenId.PHP_CONST) continue;
                        foundModifier = true;
                        ts.moveNext();
                        break;
                    }
                    if (!foundModifier) break block9;
                    while (ts.movePrevious()) {
                        token = ts.token();
                        if (!MODIFIERS.contains(token.id()) && token.id() != PHPTokenId.PHP_CLASS && token.id() != PHPTokenId.PHP_FUNCTION && token.id() != PHPTokenId.PHP_CONST && token.id() != PHPTokenId.WHITESPACE) {
                            ts.moveNext();
                            if (lastTokenId == PHPTokenId.WHITESPACE) {
                                ts.moveNext();
                            }
                            break;
                        }
                        if (token.id() != PHPTokenId.WHITESPACE && !tokens.add((PHPTokenId)token.id())) {
                            sameModifier = token.text().toString();
                            break;
                        }
                        lastTokenId = token.id();
                    }
                }
                finally {
                    ts.move(originalOffset);
                    ts.moveNext();
                }
            }
        }
        return sameModifier;
    }

    private String getVisibility(PhpModifiers phpModifiers) {
        String visibility = "";
        if (phpModifiers.isPublic()) {
            visibility = "public";
        } else if (phpModifiers.isProtected()) {
            visibility = "protected";
        } else if (phpModifiers.isPrivate()) {
            visibility = "private";
        }
        return visibility;
    }

    private String getSetVisibility(PhpModifiers phpModifiers) {
        String visibility = "";
        if (phpModifiers.isPublicSet()) {
            visibility = "public(set)";
        } else if (phpModifiers.isProtectedSet()) {
            visibility = "protected(set)";
        } else if (phpModifiers.isPrivateSet()) {
            visibility = "private(set)";
        }
        return visibility;
    }

    private int getTypeStart(int elementOffset, String declaredType) {
        int offset = elementOffset;
        if (!StringUtils.isEmpty((String)declaredType)) {
            offset -= declaredType.length() + 1;
        }
        return offset;
    }

    private boolean isVisibilityWeakerThanSet(PhpModifiers phpModifiers) {
        return phpModifiers.isPublicSet() && (phpModifiers.isProtected() || phpModifiers.isPrivate()) || phpModifiers.isProtectedSet() && phpModifiers.isPrivate();
    }

    private List<HintFix> getMultipleAccessTypeModifiersFixes(PhpModifiers modifiers, int offset) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        ArrayList<String> visibilities = new ArrayList<String>();
        ArrayList setVisibilities = new ArrayList();
        if (modifiers.isPublic() && !modifiers.isImplicitPublic()) {
            visibilities.add("public");
        }
        if (modifiers.isProtected()) {
            visibilities.add("protected");
        }
        if (modifiers.isPrivate()) {
            visibilities.add("private");
        }
        if (modifiers.isPublicSet()) {
            visibilities.add("public(set)");
        }
        if (modifiers.isProtectedSet()) {
            visibilities.add("protected(set)");
        }
        if (modifiers.isPrivateSet()) {
            visibilities.add("private(set)");
        }
        if (visibilities.size() >= 2) {
            for (String visibility : visibilities) {
                fixes.add(new RemoveModifierFix(this.doc, visibility, offset));
            }
        }
        if (setVisibilities.size() >= 2) {
            for (String visibility : setVisibilities) {
                fixes.add(new RemoveModifierFix(this.doc, visibility, offset));
            }
        }
        return fixes;
    }

    private void processInterfaceScope(InterfaceScope interfaceScope) {
        Collection<? extends MethodScope> declaredMethods = interfaceScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceMethodScope(methodScope);
        }
        Collection<? extends ClassConstantElement> declaredConstants = interfaceScope.getDeclaredConstants();
        for (ClassConstantElement classConstantElement : declaredConstants) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceClassConstant(classConstantElement);
        }
    }

    private void processInterfaceMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (this.hasAbstractModifier(methodScope)) {
            String invalidModifier = "abstract";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isReadonly()) {
            String invalidModifier = "readonly";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (BodyDeclaration.Modifier.isSetVisibilityModifier(phpModifiers.toFlags())) {
            String invalidModifier = this.getSetVisibility(phpModifiers);
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (methodScope.getBlockRange() != null && methodScope.getBlockRange().getLength() != 1) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.IfaceMethodWithBlock(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
        this.addInvalidMultipleSameModifierHint(methodScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAbstractModifier(MethodScope methodScope) {
        boolean hasAbstractModifier = false;
        int startOffset = this.getStartOffset(methodScope.getOffset());
        if (this.ts != null) {
            int originalOffset = this.ts.offset();
            try {
                this.ts.move(methodScope.getOffset());
                while (this.ts.movePrevious() && startOffset <= this.ts.offset()) {
                    if (this.ts.token().id() != PHPTokenId.PHP_ABSTRACT) continue;
                    hasAbstractModifier = true;
                    break;
                }
            }
            finally {
                this.ts.move(originalOffset);
                this.ts.moveNext();
            }
        }
        return hasAbstractModifier;
    }

    private void processInterfaceClassConstant(ClassConstantElement classConstant) {
        PhpModifiers phpModifiers = classConstant.getPhpModifiers();
        boolean isFirstConst = this.isFirstConstant(classConstant.getOffset());
        int typeStart = this.getTypeStart(classConstant.getOffset(), classConstant.getDeclaredType());
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes, isFirstConst);
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, typeStart));
            this.addSimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes, isFirstConst);
        } else {
            this.processClassConstantElement(classConstant);
        }
    }

    private void processPossibleAbstractClass(ClassScope classScope) {
        List<HintFix> fixes;
        if (!classScope.isAbstract()) {
            fixes = Collections.singletonList(new AddModifierFix(this.doc, "abstract", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.PossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
        if (classScope.isFinal()) {
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.FinalPossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStartOffset(int elementOffset) {
        int retval;
        block6: {
            retval = 0;
            int originalOffset = 0;
            try {
                if (this.ts == null) break block6;
                originalOffset = this.ts.offset();
                this.ts.move(elementOffset);
                TokenId lastTokenId = null;
                while (this.ts.movePrevious()) {
                    Token t = this.ts.token();
                    if (!MODIFIERS.contains(t.id()) && t.id() != PHPTokenId.PHP_CLASS && t.id() != PHPTokenId.PHP_FUNCTION && t.id() != PHPTokenId.WHITESPACE && t.id() != PHPTokenId.PHP_CONST) {
                        this.ts.moveNext();
                        if (lastTokenId == PHPTokenId.WHITESPACE) {
                            this.ts.moveNext();
                        }
                        retval = this.ts.offset();
                        break;
                    }
                    lastTokenId = t.id();
                }
            }
            finally {
                this.ts.move(originalOffset);
                this.ts.moveNext();
            }
        }
        return retval;
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<SingleFieldDeclaration> readonlyFieldDeclarationsWithDefaultValue = new ArrayList<SingleFieldDeclaration>();
        private final List<Pair<ClassDeclaration, AttributeDeclaration>> invalidReadonlyClassAttributes = new ArrayList<Pair<ClassDeclaration, AttributeDeclaration>>();
        private final List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> duplicatedClassModifiers = new ArrayList<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>>();

        private CheckVisitor() {
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDuplicatedClassModifiers(node);
            if (node.getModifiers().containsKey((Object)ClassDeclaration.Modifier.READONLY)) {
                this.checkInvalidReadonlyClassAttributes(node);
            }
            super.visit(node);
        }

        private void checkDuplicatedClassModifiers(ClassDeclaration node) {
            for (Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>> entry : node.getModifiers().entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (entry.getValue().size() <= 1) continue;
                this.duplicatedClassModifiers.add(entry);
            }
        }

        private void checkInvalidReadonlyClassAttributes(ClassDeclaration node) {
            block0: for (Attribute attribute : node.getAttributes()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    String attributeName = CodeUtils.extractQualifiedName(attributeDeclaration.getAttributeName());
                    if (!PredefinedSymbols.Attributes.ALLOW_DYNAMIC_PROPERTIES.getName().equals(attributeName)) continue;
                    this.invalidReadonlyClassAttributes.add((Pair<ClassDeclaration, AttributeDeclaration>)Pair.of((Object)node, (Object)attributeDeclaration));
                    continue block0;
                }
            }
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (BodyDeclaration.Modifier.isReadonly(node.getModifier())) {
                for (SingleFieldDeclaration field : node.getFields()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (field.getValue() == null) continue;
                    this.readonlyFieldDeclarationsWithDefaultValue.add(field);
                }
            }
            super.visit(node);
        }

        public List<SingleFieldDeclaration> getReadonlyFieldDeclarationsWithDefaultValue() {
            return Collections.unmodifiableList(this.readonlyFieldDeclarationsWithDefaultValue);
        }

        public List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> getDuplicatedClassModifiers() {
            return Collections.unmodifiableList(this.duplicatedClassModifiers);
        }

        public List<Pair<ClassDeclaration, AttributeDeclaration>> getInvalidReadonlyClassAttributes() {
            return Collections.unmodifiableList(this.invalidReadonlyClassAttributes);
        }
    }

    private class RemoveModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;
        private final OffsetRange offsetRange;

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            this(doc, modifier, elementOffset, null);
        }

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset, OffsetRange offsetRange) {
            super(doc);
            this.offsetRange = offsetRange;
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.RemoveModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            if (this.offsetRange != null) {
                edits.replace(this.offsetRange.getStart(), this.offsetRange.getLength() + 1, "", true, 0);
            } else {
                int length;
                int startOffset = ModifiersCheckHintError.this.getStartOffset(this.elementOffset);
                String text = this.doc.getText(startOffset, length = this.elementOffset - startOffset);
                int lastIndexOfModifier = text.lastIndexOf(this.modifier + " ");
                if (lastIndexOfModifier != -1) {
                    length -= lastIndexOfModifier;
                    startOffset += lastIndexOfModifier;
                    text = text.substring(lastIndexOfModifier);
                }
                String replaceText = text.replace(this.modifier + " ", "").replaceAll("^\\s+", "");
                edits.replace(startOffset, length, replaceText, true, 0);
            }
            edits.apply();
        }
    }

    private class SimpleHint
    extends Hint {
        public SimpleHint(String description, @NullAllowed OffsetRange range, List<HintFix> fixes) {
            super((Rule)ModifiersCheckHintError.this, description, ModifiersCheckHintError.this.fileObject, range, fixes, 500);
        }

        public SimpleHint(String description, OffsetRange range) {
            this(description, range, null);
        }
    }

    private class AddModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public AddModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.AddModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHintError.this.getStartOffset(this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.modifier + " " + this.doc.getText(startOffset, length);
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveBodyFix
    extends AbstractHintFix {
        private final MethodScope methodScope;

        public RemoveBodyFix(BaseDocument doc, MethodScope methodScope) {
            super(doc);
            this.methodScope = methodScope;
        }

        public String getDescription() {
            return Bundle.RemoveBodyFixDesc(this.methodScope.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.methodScope.getBlockRange().getStart(), this.methodScope.getBlockRange().getLength(), ";", true, 0);
            edits.apply();
        }
    }

    private abstract class AbstractHintFix
    implements HintFix {
        protected final BaseDocument doc;

        public AbstractHintFix(BaseDocument doc) {
            this.doc = doc;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

