/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.AddonVersionConfiguration;
import com.oracle.bmc.containerengine.model.KubernetesVersionsFilters;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddonVersions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="versionNumber")
    private final String versionNumber;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="kubernetesVersionFilters")
    private final KubernetesVersionsFilters kubernetesVersionFilters;
    @JsonProperty(value="configurations")
    private final List<AddonVersionConfiguration> configurations;

    @Deprecated
    @ConstructorProperties(value={"status", "versionNumber", "description", "kubernetesVersionFilters", "configurations"})
    public AddonVersions(Status status, String versionNumber, String description, KubernetesVersionsFilters kubernetesVersionFilters, List<AddonVersionConfiguration> configurations) {
        this.status = status;
        this.versionNumber = versionNumber;
        this.description = description;
        this.kubernetesVersionFilters = kubernetesVersionFilters;
        this.configurations = configurations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public KubernetesVersionsFilters getKubernetesVersionFilters() {
        return this.kubernetesVersionFilters;
    }

    public List<AddonVersionConfiguration> getConfigurations() {
        return this.configurations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddonVersions(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", versionNumber=").append(String.valueOf(this.versionNumber));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", kubernetesVersionFilters=").append(String.valueOf((Object)this.kubernetesVersionFilters));
        sb.append(", configurations=").append(String.valueOf(this.configurations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddonVersions)) {
            return false;
        }
        AddonVersions other = (AddonVersions)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.versionNumber, other.versionNumber) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.kubernetesVersionFilters, (Object)other.kubernetesVersionFilters) && Objects.equals(this.configurations, other.configurations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.versionNumber == null ? 43 : this.versionNumber.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.kubernetesVersionFilters == null ? 43 : this.kubernetesVersionFilters.hashCode());
        result = result * 59 + (this.configurations == null ? 43 : this.configurations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Active("ACTIVE"),
        Deprecated("DEPRECATED"),
        Preview("PREVIEW"),
        Recalled("RECALLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="versionNumber")
        private String versionNumber;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="kubernetesVersionFilters")
        private KubernetesVersionsFilters kubernetesVersionFilters;
        @JsonProperty(value="configurations")
        private List<AddonVersionConfiguration> configurations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            this.__explicitlySet__.add("versionNumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder kubernetesVersionFilters(KubernetesVersionsFilters kubernetesVersionFilters) {
            this.kubernetesVersionFilters = kubernetesVersionFilters;
            this.__explicitlySet__.add("kubernetesVersionFilters");
            return this;
        }

        public Builder configurations(List<AddonVersionConfiguration> configurations) {
            this.configurations = configurations;
            this.__explicitlySet__.add("configurations");
            return this;
        }

        public AddonVersions build() {
            AddonVersions model = new AddonVersions(this.status, this.versionNumber, this.description, this.kubernetesVersionFilters, this.configurations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddonVersions model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("versionNumber")) {
                this.versionNumber(model.getVersionNumber());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("kubernetesVersionFilters")) {
                this.kubernetesVersionFilters(model.getKubernetesVersionFilters());
            }
            if (model.wasPropertyExplicitlySet("configurations")) {
                this.configurations(model.getConfigurations());
            }
            return this;
        }
    }
}

