/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.ui.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.ResultDisplayHandler;
import org.netbeans.modules.gsf.testrunner.ui.ResultPanelTree;
import org.netbeans.modules.gsf.testrunner.ui.ResultWindow;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public final class StatisticsPanel
extends JPanel {
    private final ResultPanelTree treePanel;
    private JToggleButton btnShowPassed;
    private JToggleButton btnShowFailed;
    private JToggleButton btnShowError;
    private JToggleButton btnShowPassedWithErrors;
    private JToggleButton btnShowIgnored;
    private JToggleButton btnShowSkipped;
    private JToggleButton btnShowAborted;
    private JToggleButton btnAlwaysOpenTRW;
    private JToggleButton btnAlwaysOpenNewTab;
    private JButton rerunButton;
    private JButton rerunFailedButton;
    private JButton nextFailure;
    private JButton previousFailure;
    private final ResultDisplayHandler displayHandler;
    private static final String KEY_FILTER_MASK = "filterMask";
    private int filterMask = NbPreferences.forModule(StatisticsPanel.class).getInt("filterMask", Status.PASSED.getBitMask());
    public static final String PROP_ALWAYS_OPEN_TRW = "alwaysOpenTRW";
    private static final Icon alwaysOpenTRWIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/ui/resources/testResults.png", (boolean)true);
    public static final String PROP_ALWAYS_OPEN_NEW_TAB = "alwaysOpenNewTab";
    private static final Icon alwaysOpenNewTabIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/newTab.png", (boolean)true);
    private static final Icon rerunIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png", (boolean)true);
    private static final Icon rerunFailedIcon = ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/rerun.png"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/gsf/testrunner/resources/error-badge.gif"), (int)8, (int)8));
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");

    public StatisticsPanel(ResultDisplayHandler displayHandler) {
        super(new BorderLayout(0, 0));
        this.displayHandler = displayHandler;
        JComponent toolbar = this.createToolbar();
        this.treePanel = new ResultPanelTree(displayHandler, this);
        this.treePanel.setFilterMask(this.filterMask);
        this.add((Component)toolbar, "West");
        this.add((Component)this.treePanel, "Center");
        if (isMacLaf) {
            toolbar.setBackground(macBackground);
            this.treePanel.setBackground(macBackground);
        }
    }

    public ResultPanelTree getTreePanel() {
        return this.treePanel;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treePanel.requestFocusInWindow();
    }

    private JComponent createToolbar() {
        this.createShowButtons();
        this.createNextPrevFailureButtons();
        this.createRerunButtons();
        this.createOptionButtons();
        String testingFramework = Manager.getInstance().getTestingFramework();
        ToolbarWithOverflow toolbar = new ToolbarWithOverflow(1);
        toolbar.add(this.rerunButton);
        toolbar.add(this.rerunFailedButton);
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.btnShowPassed);
        if (testingFramework.equals("testng")) {
            toolbar.add(this.btnShowPassedWithErrors);
        }
        toolbar.add(this.btnShowFailed);
        toolbar.add(this.btnShowError);
        toolbar.add(this.btnShowAborted);
        toolbar.add(this.btnShowSkipped);
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.previousFailure);
        toolbar.add(this.nextFailure);
        toolbar.add(new JToolBar.Separator());
        toolbar.add(this.btnAlwaysOpenTRW);
        toolbar.add(this.btnAlwaysOpenNewTab);
        toolbar.setFocusable(false);
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        return toolbar;
    }

    private void createOptionButtons() {
        this.btnAlwaysOpenTRW = this.newOptionButton(alwaysOpenTRWIcon, Bundle.btnAlwaysOpenTRW_tooltip(), Bundle.btnAlwaysOpenTRW_ACSN(), PROP_ALWAYS_OPEN_TRW);
        this.btnAlwaysOpenNewTab = this.newOptionButton(alwaysOpenNewTabIcon, Bundle.btnAlwaysOpenNewTab_tooltip(), Bundle.btnAlwaysOpenNewTab_ACSN(), PROP_ALWAYS_OPEN_NEW_TAB);
    }

    private JToggleButton newOptionButton(Icon icon, String tooltip, String accessibleName, String property) {
        JToggleButton newButton = new JToggleButton(icon);
        newButton.setToolTipText(tooltip);
        newButton.getAccessibleContext().setAccessibleName(accessibleName);
        boolean isSelected = NbPreferences.forModule(StatisticsPanel.class).getBoolean(property, false);
        newButton.setSelected(isSelected);
        newButton.addItemListener(e -> {
            boolean selected;
            switch (e.getStateChange()) {
                case 1: {
                    selected = true;
                    break;
                }
                case 2: {
                    selected = false;
                    break;
                }
                default: {
                    return;
                }
            }
            ResultWindow.getInstance().updateOptionStatus(property, selected);
        });
        return newButton;
    }

    public void updateOptionStatus(String property, boolean selected) {
        if (property.equals(PROP_ALWAYS_OPEN_TRW)) {
            this.btnAlwaysOpenTRW.setSelected(selected);
        } else if (property.equals(PROP_ALWAYS_OPEN_NEW_TAB)) {
            this.btnAlwaysOpenNewTab.setSelected(selected);
        }
    }

    private void createRerunButtons() {
        this.rerunButton = new JButton(rerunIcon);
        this.rerunButton.setEnabled(false);
        this.rerunButton.getAccessibleContext().setAccessibleName(Bundle.ACSN_RerunButton());
        this.rerunButton.setToolTipText(Bundle.MultiviewPanel_rerunButton_tooltip());
        this.rerunFailedButton = new JButton(rerunFailedIcon);
        this.rerunFailedButton.setEnabled(false);
        this.rerunFailedButton.getAccessibleContext().setAccessibleName(Bundle.ACSN_RerunFailedButton());
        this.rerunFailedButton.setToolTipText(Bundle.MultiviewPanel_rerunFailedButton_tooltip());
        RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler != null) {
            this.rerunButton.addActionListener(e -> rerunHandler.rerun());
            this.rerunFailedButton.addActionListener(e -> rerunHandler.rerun(this.treePanel.getFailedTests()));
            rerunHandler.addChangeListener(e -> this.updateButtons());
            this.updateButtons();
        }
    }

    void updateButtons() {
        RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler == null) {
            return;
        }
        this.rerunButton.setEnabled(this.displayHandler.sessionFinished && rerunHandler.enabled(RerunType.ALL));
        this.rerunFailedButton.setEnabled(this.displayHandler.sessionFinished && rerunHandler.enabled(RerunType.CUSTOM) && !this.treePanel.getFailedTests().isEmpty());
        this.btnShowPassed.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowPassedWithErrors.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowFailed.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowError.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowIgnored.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowSkipped.setEnabled(this.displayHandler.sessionFinished);
        this.btnShowAborted.setEnabled(this.displayHandler.sessionFinished);
        this.nextFailure.setEnabled(this.displayHandler.sessionFinished);
        this.previousFailure.setEnabled(this.displayHandler.sessionFinished);
    }

    private void createShowButtons() {
        this.btnShowPassed = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ok_16.png", Bundle.StatisticsPanel_btnShowPassed(), Bundle.ACSN_ShowPassedButton(), Status.PASSED);
        this.btnShowPassedWithErrors = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ok_withErrors_16.png", Bundle.StatisticsPanel_btnShowPassedWithErrors(), Bundle.ACSN_ShowPassedWithErrorsButton(), Status.PASSEDWITHERRORS);
        this.btnShowFailed = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/warning_16.png", Bundle.StatisticsPanel_btnShowFailed(), Bundle.ACSN_ShowFailedButton(), Status.FAILED);
        this.btnShowError = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/error_16.png", Bundle.StatisticsPanel_btnShowError(), Bundle.ACSN_ShowErrorButton(), Status.ERROR);
        this.btnShowAborted = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/aborted.png", Bundle.StatisticsPanel_btnShowAborted(), Bundle.ACSN_ShowAbortedButton(), Status.ABORTED);
        this.btnShowIgnored = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/ignored_16.png", Bundle.StatisticsPanel_btnShowIgnored(), Bundle.ACSN_ShowIgnoredButton(), Status.IGNORED);
        this.btnShowSkipped = this.newShowButton("org/netbeans/modules/gsf/testrunner/resources/skipped_16.png", Bundle.StatisticsPanel_btnShowSkipped(), Bundle.ACSN_ShowSkippedButton(), Status.SKIPPED);
    }

    private JToggleButton newShowButton(String iconId, String tooltip, String accessibleName, Status status) {
        JToggleButton btn = new JToggleButton(ImageUtilities.loadImageIcon((String)iconId, (boolean)true));
        btn.setToolTipText(tooltip);
        btn.getAccessibleContext().setAccessibleName(accessibleName);
        btn.setSelected((this.filterMask & status.getBitMask()) == 0);
        btn.addItemListener(new FilterItemListener(status));
        return btn;
    }

    void copyFilterMask(StatisticsPanel sp) {
        this.filterMask = sp.filterMask;
        this.updateShowButtons();
    }

    private void updateShowButtons() {
        this.btnShowPassed.setSelected((this.filterMask & Status.PASSED.getBitMask()) == 0);
        this.btnShowPassedWithErrors.setSelected((this.filterMask & Status.PASSEDWITHERRORS.getBitMask()) == 0);
        this.btnShowFailed.setSelected((this.filterMask & Status.FAILED.getBitMask()) == 0);
        this.btnShowError.setSelected((this.filterMask & Status.ERROR.getBitMask()) == 0);
        this.btnShowIgnored.setSelected((this.filterMask & Status.IGNORED.getBitMask()) == 0);
        this.btnShowSkipped.setSelected((this.filterMask & Status.SKIPPED.getBitMask()) == 0);
        this.btnShowAborted.setSelected((this.filterMask & Status.ABORTED.getBitMask()) == 0);
    }

    private void createNextPrevFailureButtons() {
        this.nextFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/nextmatch.png", (boolean)true));
        this.nextFailure.setToolTipText(Bundle.MSG_NextFailure());
        this.nextFailure.addActionListener(e -> this.selectNextFailure());
        this.previousFailure = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/gsf/testrunner/resources/prevmatch.png", (boolean)true));
        this.previousFailure.setToolTipText(Bundle.MSG_PreviousFailure());
        this.previousFailure.addActionListener(e -> this.selectPreviousFailure());
    }

    void selectPreviousFailure() {
        this.treePanel.selectPreviousFailure();
    }

    void rerun(boolean rerunFailed) {
        RerunHandler rerunHandler = this.displayHandler.getSession().getRerunHandler();
        if (rerunHandler != null) {
            if (rerunFailed) {
                if (!this.treePanel.getFailedTests().isEmpty()) {
                    rerunHandler.rerun(this.treePanel.getFailedTests());
                }
                return;
            }
            rerunHandler.rerun();
        }
    }

    void selectNextFailure() {
        this.treePanel.selectNextFailure();
    }

    void displayReport(Report report) {
        this.treePanel.displayReport(report);
    }

    void displayReports(List<Report> reports) {
        if (reports.isEmpty()) {
            return;
        }
        this.treePanel.displayReports(reports);
    }

    void displaySuiteRunning(String suiteName) {
        this.treePanel.displaySuiteRunning(suiteName);
    }

    void displayMsg(String msg) {
        this.treePanel.displayMsg(msg);
    }

    private class FilterItemListener
    implements ItemListener {
        private int itemMask;

        public FilterItemListener(Status status) {
            this.itemMask = status.getBitMask();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    StatisticsPanel.this.filterMask &= ~this.itemMask;
                    break;
                }
                case 2: {
                    StatisticsPanel.this.filterMask |= this.itemMask;
                    break;
                }
                default: {
                    return;
                }
            }
            StatisticsPanel.this.treePanel.setFilterMask(StatisticsPanel.this.filterMask);
            NbPreferences.forModule(StatisticsPanel.class).putInt(StatisticsPanel.KEY_FILTER_MASK, StatisticsPanel.this.filterMask);
        }
    }
}

