/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;

class Token
extends ByteArray {
    private static final int MY_TOK_LEN = 8;
    private static final int MAX_TOK_LEN = 64;
    private final long lastSeen;

    public Token(I2PAppContext ctx) {
        super(null);
        byte[] data = new byte[8];
        ctx.random().nextBytes(data);
        this.setData(data);
        this.setValid(8);
        this.lastSeen = ctx.clock().now();
    }

    public Token(I2PAppContext ctx, byte[] data) {
        super(data);
        if (data.length > 64) {
            throw new IllegalArgumentException();
        }
        this.lastSeen = ctx.clock().now();
    }

    public Token(byte[] data) {
        super(data);
        this.lastSeen = 0L;
    }

    public long lastSeen() {
        return this.lastSeen;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[Token: ");
        byte[] bs = this.getData();
        if (bs.length == 0) {
            buf.append("0 bytes");
        } else {
            buf.append(bs.length).append(" bytes: 0x");
            for (int i = 0; i < bs.length; ++i) {
                int b = bs[i] & 0xFF;
                if (b < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(b));
            }
        }
        if (this.lastSeen > 0L) {
            buf.append(" created ").append(new Date(this.lastSeen).toString());
        }
        buf.append(']');
        return buf.toString();
    }
}

