/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.util.introspection.MethodMap;
import org.apache.velocity.util.introspection.TypeConversionHandler;
import org.slf4j.Logger;

public class ClassMap {
    private static final boolean debugReflection = false;
    private final Logger log;
    private final Class<?> clazz;
    private final MethodCache methodCache;

    public ClassMap(Class<?> clazz, Logger log) {
        this(clazz, log, null);
    }

    public ClassMap(Class<?> clazz, Logger log, TypeConversionHandler conversionHandler) {
        this.clazz = clazz;
        this.log = log;
        this.methodCache = this.createMethodCache(conversionHandler);
    }

    public Class<?> getCachedClass() {
        return this.clazz;
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        return this.methodCache.get(name, params);
    }

    private MethodCache createMethodCache(TypeConversionHandler conversionHandler) {
        MethodCache methodCache = new MethodCache(this.log, conversionHandler);
        for (Class<?> classToReflect = this.getCachedClass(); classToReflect != null; classToReflect = classToReflect.getSuperclass()) {
            Class<?>[] interfaces;
            if (Modifier.isPublic(classToReflect.getModifiers())) {
                this.populateMethodCacheWith(methodCache, classToReflect);
            }
            for (Class<?> anInterface : interfaces = classToReflect.getInterfaces()) {
                this.populateMethodCacheWithInterface(methodCache, anInterface);
            }
        }
        return methodCache;
    }

    private void populateMethodCacheWithInterface(MethodCache methodCache, Class<?> iface) {
        Class<?>[] supers;
        if (Modifier.isPublic(iface.getModifiers())) {
            this.populateMethodCacheWith(methodCache, iface);
        }
        for (Class<?> aSuper : supers = iface.getInterfaces()) {
            this.populateMethodCacheWithInterface(methodCache, aSuper);
        }
    }

    private void populateMethodCacheWith(MethodCache methodCache, Class<?> classToReflect) {
        try {
            Method[] methods;
            for (Method method : methods = classToReflect.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers)) continue;
                method = MethodMap.getAccessibleMethodDeclaration(method);
                methodCache.put(method);
            }
        }
        catch (SecurityException se) {
            this.log.debug("While accessing methods of {}:", classToReflect, (Object)se);
        }
    }

    private static final class MethodCache {
        private static final Object CACHE_MISS = new Object();
        private static final String NULL_ARG = Object.class.getName();
        private static final Map<Class<?>, String> convertPrimitives = new HashMap();
        private final Logger log;
        private final Map<Object, Object> cache = new ConcurrentHashMap<Object, Object>();
        private final MethodMap methodMap;

        private MethodCache(Logger log, TypeConversionHandler conversionHandler) {
            this.log = log;
            this.methodMap = new MethodMap(conversionHandler);
        }

        public Method get(String name, Object[] params) throws MethodMap.AmbiguousException {
            String methodKey = this.makeMethodKey(name, params);
            Object cacheEntry = this.cache.get(methodKey);
            if (cacheEntry == CACHE_MISS) {
                return null;
            }
            if (cacheEntry == null) {
                try {
                    cacheEntry = this.methodMap.find(name, params);
                }
                catch (MethodMap.AmbiguousException ae) {
                    this.cache.put(methodKey, CACHE_MISS);
                    throw ae;
                }
                this.cache.put(methodKey, cacheEntry != null ? cacheEntry : CACHE_MISS);
            }
            return (Method)cacheEntry;
        }

        private void put(Method method) {
            String methodKey = this.makeMethodKey(method);
            if (this.cache.get(methodKey) == null) {
                this.cache.put(methodKey, method);
                this.methodMap.add(method);
            }
        }

        private String makeMethodKey(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            int args = parameterTypes.length;
            if (args == 0) {
                return method.getName();
            }
            StringBuilder methodKey = new StringBuilder((args + 1) * 16).append(method.getName());
            for (Class<?> parameterType : parameterTypes) {
                if (parameterType.isPrimitive()) {
                    methodKey.append(convertPrimitives.get(parameterType));
                    continue;
                }
                methodKey.append(parameterType.getName());
            }
            return methodKey.toString();
        }

        private String makeMethodKey(String method, Object[] params) {
            int args = params.length;
            if (args == 0) {
                return method;
            }
            StringBuilder methodKey = new StringBuilder((args + 1) * 16).append(method);
            for (Object arg : params) {
                if (arg == null) {
                    methodKey.append(NULL_ARG);
                    continue;
                }
                methodKey.append(arg.getClass().getName());
            }
            return methodKey.toString();
        }

        static {
            convertPrimitives.put(Boolean.TYPE, Boolean.class.getName());
            convertPrimitives.put(Byte.TYPE, Byte.class.getName());
            convertPrimitives.put(Character.TYPE, Character.class.getName());
            convertPrimitives.put(Double.TYPE, Double.class.getName());
            convertPrimitives.put(Float.TYPE, Float.class.getName());
            convertPrimitives.put(Integer.TYPE, Integer.class.getName());
            convertPrimitives.put(Long.TYPE, Long.class.getName());
            convertPrimitives.put(Short.TYPE, Short.class.getName());
        }
    }
}

