/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ValidationPath {
    public static final int MAX_PATH_LENGTH_BYTES = 768;
    public static final int MAX_PATH_DEPTH = 32;
    private final List<String> parts = new ArrayList<String>();
    private int byteLength = 0;

    private ValidationPath(Path path) throws DatabaseException {
        for (ChildKey key : path) {
            this.parts.add(key.asString());
        }
        this.byteLength = Math.max(1, this.parts.size());
        for (int i = 0; i < this.parts.size(); ++i) {
            this.byteLength += ValidationPath.utf8Bytes(this.parts.get(i));
        }
        this.checkValid();
    }

    public static void validateWithObject(Path path, Object value) throws DatabaseException {
        new ValidationPath(path).withObject(value);
    }

    private static String joinStringList(String delimeter, List<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                sb.append(delimeter);
            }
            sb.append(parts.get(i));
        }
        return sb.toString();
    }

    private static int utf8Bytes(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    private void withObject(Object value) throws DatabaseException {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            for (String key : mapValue.keySet()) {
                if (key.startsWith(".")) continue;
                this.push(key);
                this.withObject(mapValue.get(key));
                this.pop();
            }
            return;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            for (int i = 0; i < listValue.size(); ++i) {
                String key = Integer.toString(i);
                this.push(key);
                this.withObject(listValue.get(i));
                this.pop();
            }
        }
    }

    private void push(String child) throws DatabaseException {
        if (this.parts.size() > 0) {
            ++this.byteLength;
        }
        this.parts.add(child);
        this.byteLength += ValidationPath.utf8Bytes(child);
        this.checkValid();
    }

    private String pop() {
        String last = this.parts.remove(this.parts.size() - 1);
        this.byteLength -= ValidationPath.utf8Bytes(last);
        if (this.parts.size() > 0) {
            --this.byteLength;
        }
        return last;
    }

    private void checkValid() throws DatabaseException {
        if (this.byteLength > 768) {
            throw new DatabaseException("Data has a key path longer than 768 bytes (" + this.byteLength + ").");
        }
        if (this.parts.size() > 32) {
            throw new DatabaseException("Path specified exceeds the maximum depth that can be written (32) or object contains a cycle " + this.toErrorString());
        }
    }

    private String toErrorString() {
        if (this.parts.size() == 0) {
            return "";
        }
        return "in path '" + ValidationPath.joinStringList("/", this.parts) + "'";
    }
}

