/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.google.inject.Injector;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.Map;
import org.traccar.BaseProtocolDecoder;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Main;
import org.traccar.PipelineBuilder;
import org.traccar.ProcessingHandler;
import org.traccar.TrackerConnector;
import org.traccar.WrapperInboundHandler;
import org.traccar.WrapperOutboundHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.network.AcknowledgementHandler;
import org.traccar.handler.network.MainEventHandler;
import org.traccar.handler.network.NetworkForwarderHandler;
import org.traccar.handler.network.NetworkMessageHandler;
import org.traccar.handler.network.OpenChannelHandler;
import org.traccar.handler.network.RemoteAddressHandler;
import org.traccar.handler.network.StandardLoggingHandler;

public abstract class BasePipelineFactory
extends ChannelInitializer<Channel> {
    private final Injector injector = Main.getInjector();
    private final TrackerConnector connector;
    private final Config config;
    private final String protocol;
    private final int timeout;

    public BasePipelineFactory(TrackerConnector connector, Config config, String protocol) {
        this.connector = connector;
        this.config = config;
        this.protocol = protocol;
        int timeout = config.getInteger(Keys.PROTOCOL_TIMEOUT.withPrefix(protocol));
        this.timeout = timeout == 0 ? config.getInteger(Keys.SERVER_TIMEOUT) : timeout;
    }

    protected abstract void addTransportHandlers(PipelineBuilder var1);

    protected abstract void addProtocolHandlers(PipelineBuilder var1);

    public static <T extends ChannelHandler> T getHandler(ChannelPipeline pipeline, Class<T> clazz) {
        for (Map.Entry handlerEntry : pipeline) {
            ChannelHandler handler = (ChannelHandler)handlerEntry.getValue();
            if (handler instanceof WrapperInboundHandler) {
                WrapperInboundHandler wrapperHandler = (WrapperInboundHandler)handler;
                handler = wrapperHandler.getWrappedHandler();
            } else if (handler instanceof WrapperOutboundHandler) {
                WrapperOutboundHandler wrapperHandler = (WrapperOutboundHandler)handler;
                handler = wrapperHandler.getWrappedHandler();
            }
            if (!clazz.isAssignableFrom(handler.getClass())) continue;
            return (T)handler;
        }
        return null;
    }

    private <T> T injectMembers(T object) {
        this.injector.injectMembers(object);
        return object;
    }

    protected void initChannel(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        this.addTransportHandlers(xva$0 -> pipeline.addLast(new ChannelHandler[]{xva$0}));
        if (this.timeout > 0 && !this.connector.isDatagram()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.timeout, 0, 0)});
        }
        pipeline.addLast(new ChannelHandler[]{new OpenChannelHandler(this.connector)});
        if (this.config.hasKey(Keys.SERVER_FORWARD)) {
            int port = this.config.getInteger(Keys.PROTOCOL_PORT.withPrefix(this.protocol));
            pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.injectMembers(new NetworkForwarderHandler(port))});
        }
        pipeline.addLast(new ChannelHandler[]{new NetworkMessageHandler()});
        pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.injectMembers(new StandardLoggingHandler(this.protocol))});
        if (!this.connector.isDatagram() && !this.config.getBoolean(Keys.SERVER_INSTANT_ACKNOWLEDGEMENT)) {
            pipeline.addLast(new ChannelHandler[]{new AcknowledgementHandler()});
        }
        this.addProtocolHandlers(handler -> {
            if (handler instanceof BaseProtocolDecoder || handler instanceof BaseProtocolEncoder) {
                this.injectMembers(handler);
            } else if (handler instanceof ChannelInboundHandler) {
                ChannelInboundHandler channelHandler = (ChannelInboundHandler)handler;
                handler = new WrapperInboundHandler(channelHandler);
            } else if (handler instanceof ChannelOutboundHandler) {
                ChannelOutboundHandler channelHandler = (ChannelOutboundHandler)handler;
                handler = new WrapperOutboundHandler(channelHandler);
            }
            pipeline.addLast(new ChannelHandler[]{handler});
        });
        pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.injector.getInstance(RemoteAddressHandler.class)});
        pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.injector.getInstance(ProcessingHandler.class)});
        pipeline.addLast(new ChannelHandler[]{(ChannelHandler)this.injector.getInstance(MainEventHandler.class)});
    }
}

