/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.exceptions.PreparationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.KeyShareEntryPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareEntrySerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.KeyShareExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareExtensionPreparator
extends ExtensionPreparator<KeyShareExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final KeyShareExtensionMessage msg;
    private ByteArrayOutputStream stream;

    public KeyShareExtensionPreparator(Chooser chooser, KeyShareExtensionMessage message, KeyShareExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing KeyShareExtensionMessage");
        if (this.msg.getKeyShareList() == null) {
            this.msg.setKeyShareList(new LinkedList<KeyShareEntry>());
        }
        this.stream = new ByteArrayOutputStream();
        if (this.chooser.getTalkingConnectionEnd() == ConnectionEndType.SERVER) {
            ArrayList<KeyShareEntry> serverList = new ArrayList<KeyShareEntry>();
            List<KeyShareStoreEntry> clientShares = this.chooser.getClientKeyShares();
            for (KeyShareStoreEntry i : clientShares) {
                if (!this.chooser.getServerSupportedNamedGroups().contains((Object)i.getGroup())) continue;
                KeyShareEntry keyShareEntry = new KeyShareEntry(i.getGroup(), this.chooser.getConfig().getKeySharePrivate());
                serverList.add(keyShareEntry);
                break;
            }
            this.msg.setKeyShareList(serverList);
        }
        if (this.msg.getKeyShareList() != null) {
            for (KeyShareEntry entry : this.msg.getKeyShareList()) {
                KeyShareEntryPreparator preparator = new KeyShareEntryPreparator(this.chooser, entry);
                preparator.prepare();
                KeyShareEntrySerializer serializer = new KeyShareEntrySerializer(entry);
                try {
                    this.stream.write(serializer.serialize());
                }
                catch (IOException ex) {
                    throw new PreparationException("Could not write byte[] from KeySharePair", ex);
                }
            }
        }
        this.prepareKeyShareListBytes(this.msg);
        this.prepareKeyShareListLength(this.msg);
    }

    private void prepareKeyShareListBytes(KeyShareExtensionMessage msg) {
        msg.setKeyShareListBytes(this.stream.toByteArray());
        LOGGER.debug("KeyShareListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getKeyShareListBytes().getValue())));
    }

    private void prepareKeyShareListLength(KeyShareExtensionMessage msg) {
        msg.setKeyShareListLength(((byte[])msg.getKeyShareListBytes().getValue()).length);
        LOGGER.debug("KeyShareListBytesLength: " + msg.getKeyShareListLength().getValue());
    }
}

