/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.filters;

import ca.odell.glazedlists.matchers.Matcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.swing.date.combo.DateItem;
import tr.util.DateUtils;
import tr.view.actions.screens.filters.FilterDate;
import tr.view.filters.FilterComboDate;

public class FilterDateCreatedTo
extends FilterDate
implements PropertyChangeListener {
    public static final byte INDEX = 10;
    private static final DateItem[] dateItems = new DateItem[]{DateItem.DATE_CHOOSER, DateItem.TODAY, DateItem.YESTERDAY, DateItem.WEEKS_AGO_1, DateItem.WEEKS_AGO_2, DateItem.WEEKS_AGO_3, DateItem.WEEKS_AGO_4};

    public FilterDateCreatedTo() {
        this.initialise();
    }

    protected void initialise() {
        this.combo = new FilterComboDate(dateItems, false);
        this.combo.addValueChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        DateItem item = (DateItem)this.combo.getSelectedItem();
        if (item == null) {
            this.fireMatchAll();
        } else {
            this.fireChanged(new ToDateMatcher(FilterComboDate.getDate((DateItem)item), this.excludeNulls));
        }
    }

    public String getLabel() {
        return NbBundle.getMessage(this.getClass(), (String)"filter-created-to");
    }

    public byte getIndex() {
        return 10;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToDateMatcher
    implements Matcher<Action> {
        private final Date matchDate;
        private final boolean excludeNulls;

        public ToDateMatcher(Date date, boolean excludeNulls) {
            this.matchDate = DateUtils.getEnd((Date)date);
            this.excludeNulls = excludeNulls;
        }

        public boolean matches(Action action) {
            if (this.matchDate == null) {
                return true;
            }
            Date date = action.getCreated();
            if (date == null) {
                return !this.excludeNulls;
            }
            return !date.after(this.matchDate);
        }
    }
}

