/*
 * Decompiled with CFR 0.152.
 */
package tr.datastore.xstream;

import au.com.trgtd.tr.calendar.Calendar;
import au.com.trgtd.tr.calendar.prefs.CalendarPrefs;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.datastore.AbstractDataStore;
import tr.datastore.DataStore;
import tr.datastore.xstream.XStreamWrapper;
import tr.model.Data;
import tr.prefs.datafile.DataPrefs;
import tr.util.UtilsFile;
import tr.view.WindowUtils;

public final class XStreamDataStore
extends AbstractDataStore {
    private static final Logger LOG = Logger.getLogger("tr.datastore.xstream");
    public static final String[] FILE_EXTENSIONS = new String[]{"xml", "trx"};
    private static final String PATH = "ThinkingRock/2.2.1/xstream";
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/2.2.1/xstream");
    private static final String KEY_DATAFILE = "data.file";
    private static final String DEF_DATAFILE = "";
    private static final long AUTO_SAVE_INTERVAL = 30000L;
    private static DataStore instance;
    private Thread autoSaveThread;
    private boolean autoSave;
    private String recoveryPath;

    private XStreamDataStore() {
    }

    public static DataStore instance() {
        if (instance == null) {
            instance = new XStreamDataStore();
        }
        return instance;
    }

    public String getPath() {
        return prefs.get(KEY_DATAFILE, DEF_DATAFILE);
    }

    public void setPath(String path) {
        if (path == null || path.trim().equals(DEF_DATAFILE)) {
            prefs.remove(KEY_DATAFILE);
            return;
        }
        File file = new File(path);
        String userdir = System.getProperty("user.dir");
        if (userdir.equals(file.getParent())) {
            prefs.put(KEY_DATAFILE, file.getName());
            XStreamDataStore.flush();
        } else {
            prefs.put(KEY_DATAFILE, path);
            XStreamDataStore.flush();
        }
    }

    private File getDataFile() {
        return new File(this.getPath());
    }

    private String getRecoveryPath() {
        if (this.recoveryPath == null) {
            this.recoveryPath = DataPrefs.getRecoveryPath();
        }
        if (this.recoveryPath == null || this.recoveryPath.trim().equals(DEF_DATAFILE)) {
            return null;
        }
        return this.recoveryPath;
    }

    private String getBackupFilePath() {
        File recFolder;
        String path = this.getPath();
        String recPath = this.getRecoveryPath();
        if (recPath != null && (recFolder = new File(recPath)).isDirectory() && recFolder.canWrite()) {
            String filename = new File(path).getName();
            path = new File(recFolder, filename).getPath();
        }
        String extn = UtilsFile.getExtension((String)path);
        return UtilsFile.removeExtension((String)path) + ".bak." + extn;
    }

    private File getBackupFile() {
        return new File(this.getBackupFilePath());
    }

    private Thread getAutoSaveThread() {
        if (this.autoSaveThread == null) {
            this.autoSaveThread = new AutoSaveThread();
            this.autoSaveThread.setDaemon(true);
        }
        return this.autoSaveThread;
    }

    private void startAutoSaving() {
        Thread thread = this.getAutoSaveThread();
        if (thread.isAlive()) {
            return;
        }
        this.autoSave = true;
        thread.start();
        LOG.fine("Automatic saving started");
    }

    private void stopAutoSaving() {
        this.autoSave = false;
        Thread thread = this.getAutoSaveThread();
        while (thread.isAlive()) {
            thread.interrupt();
        }
        LOG.fine("Automatic saving stopped");
    }

    private void createDataFile() throws Exception {
        File file = this.getDataFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!file.exists() || !file.canWrite()) {
            throw new Exception("Could not create writable data file: " + this.getPath());
        }
    }

    public void load() throws Exception {
        Object[] options;
        this.setData(null);
        if (!this.getDataFile().exists() && !this.getBackupFile().exists()) {
            LOG.info("No data file or recovery file found.");
            return;
        }
        String error = DEF_DATAFILE;
        if (this.getDataFile().exists()) {
            try {
                Data data = XStreamWrapper.instance().load(this.getDataFile());
                data.checkVersion();
                this.setData(data);
                return;
            }
            catch (Exception ex) {
                LOG.severe("Failed to read data file. " + ex.getMessage());
                error = ex.getMessage();
            }
        }
        String m = error.trim().length() > 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"file.read.error") + "\n\n" + error + "\n\n" : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"file.read.error.short") + "\n\n";
        if (!this.getBackupFile().exists()) {
            Object[] options2 = new Object[]{NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ok")};
            Frame p = WindowManager.getDefault().getMainWindow();
            JOptionPane.showOptionDialog(p, m, "ThinkingRock", -1, 2, null, options2, options2[0]);
            return;
        }
        Component p = null;
        int opt = JOptionPane.showOptionDialog(p, m = m + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"restore.from.recovery.file") + "\n\n", "ThinkingRock", -1, 2, null, options = new Object[]{NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ok"), NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"cancel")}, options[0]);
        if (opt == 1) {
            throw new Exception("The data file could not be read.");
        }
        try {
            Data data = XStreamWrapper.instance().load(this.getBackupFile());
            data.checkVersion();
            this.createDataFile();
            this.setData(data);
            this.setChanged(true);
        }
        catch (Exception ex) {
            throw new Exception("The data file could not be recovered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() throws Exception {
        if (!this.isLoaded()) {
            return;
        }
        if (this.getDataFile().exists()) {
            try {
                UtilsFile.renameFile((File)this.getDataFile(), (File)this.getBackupFile());
                LOG.info("Recovery file has been made.");
            }
            catch (Exception ex) {
                LOG.severe("Could not make recovery file. " + ex.getMessage());
            }
        }
        this.setChanged(false);
        try {
            XStreamDataStore ex = this;
            synchronized (ex) {
                XStreamWrapper.instance().store(this.getData(), this.getDataFile());
            }
            LOG.fine("Data has been saved to file. ");
        }
        catch (Exception ex) {
            this.setChanged(true);
            throw ex;
        }
        if (CalendarPrefs.isICalendarRequired()) {
            try {
                LOG.fine("Starting iCalendar export ... ");
                String filename = UtilsFile.removeExtension((String)this.getDataFile().getName()) + ".ics";
                Calendar.syncToCalendar((String)filename);
                LOG.fine("Finished iCalendar export.");
            }
            catch (Exception ex) {
                LOG.severe("iCalendar export failed. " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
    }

    public void startDaemon() {
        this.startAutoSaving();
    }

    public void stopDaemon() {
        this.stopAutoSaving();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("XStream preferences exception. " + ex.getMessage());
        }
    }

    private void reload() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    WindowUtils.closeWindows();
                    XStreamDataStore.this.load();
                    WindowUtils.openInitialWindow();
                }
                catch (Exception ex) {
                    LOG.severe("Could not open updated file. " + ex.getMessage());
                }
            }
        });
    }

    private class AutoSaveThread
    extends Thread {
        private AutoSaveThread() {
        }

        public void run() {
            while (XStreamDataStore.this.autoSave) {
                if (XStreamDataStore.this.hasChanged()) {
                    try {
                        XStreamDataStore.this.store();
                    }
                    catch (Exception ex) {
                        LOG.severe("XStream store exception. " + ex.getMessage());
                    }
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

