/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.shape.Shape;

public class ShapeFieldCache<T extends Shape> {
    private final List<T>[] cache;
    public final int defaultLength;

    public ShapeFieldCache(int length, int defaultLength) {
        this.cache = new List[length];
        this.defaultLength = defaultLength;
    }

    public void add(int docid, T s) {
        List<T> list = this.cache[docid];
        if (list == null) {
            this.cache[docid] = new ArrayList<T>(this.defaultLength);
            list = this.cache[docid];
        }
        list.add(s);
    }

    public List<T> getShapes(int docid) {
        return this.cache[docid];
    }
}

