/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.jvm.SolrJvmMetric;

public class SolrJvmMemoryMetric
extends SolrJvmMetric {
    public static final String JVM_MEMORY_POOL_BYTES = "solr_metrics_jvm_memory_pools_bytes";
    public static final String JVM_MEMORY = "solr_metrics_jvm_heap";

    public SolrJvmMemoryMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        this.labels.put("item", parsedMetric[parsedMetric.length - 1]);
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        String metricType;
        String[] parsedMetric = this.metricName.split("\\.");
        switch (metricType = parsedMetric[1]) {
            case "heap": 
            case "non-heap": 
            case "total": {
                this.labels.put("memory", parsedMetric[1]);
                formatter.exportGauge(JVM_MEMORY, (Gauge)this.dropwizardMetric, this.getLabels());
                break;
            }
            case "pools": {
                this.labels.put("space", parsedMetric[2]);
                formatter.exportGauge(JVM_MEMORY_POOL_BYTES, (Gauge)this.dropwizardMetric, this.getLabels());
            }
        }
    }
}

