/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Reader;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class SolrInfoMBeanHandler
extends RequestHandlerBase {
    private Set<String> arrayToSet(Object[] arr) {
        HashSet<String> r = new HashSet<String>();
        if (null == arr) {
            return r;
        }
        for (Object o : arr) {
            if (null == o) continue;
            r.add(o.toString());
        }
        return r;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        NamedList cats = this.getMBeanInfo(req);
        if (req.getParams().getBool("diff", false)) {
            ContentStream body = null;
            try {
                body = req.getContentStreams().iterator().next();
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content-stream for diff");
            }
            String content = StrUtils.stringFromReader((Reader)body.getReader());
            NamedList<NamedList<NamedList<Object>>> ref = SolrInfoMBeanHandler.fromXML(content);
            SolrQueryResponse wrap = new SolrQueryResponse();
            wrap.add("solr-mbeans", cats);
            cats = (NamedList)BinaryResponseWriter.getParsedResponse(req, wrap).get("solr-mbeans");
            this.normalize(ref);
            this.normalize(cats);
            boolean showAll = req.getParams().getBool("all", false);
            rsp.add("solr-mbeans", this.getDiff(ref, (NamedList<NamedList<NamedList<Object>>>)cats, showAll));
        } else {
            rsp.add("solr-mbeans", cats);
        }
        rsp.setHttpCaching(false);
    }

    static NamedList<NamedList<NamedList<Object>>> fromXML(String content) {
        int idx = content.indexOf("<response>");
        if (idx < 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Body does not appear to be an XML response");
        }
        try {
            XMLResponseParser parser = new XMLResponseParser();
            return (NamedList)parser.processResponse((Reader)new StringReader(content)).get("solr-mbeans");
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to read original XML", (Throwable)ex);
        }
    }

    protected NamedList<NamedList<NamedList<Object>>> getMBeanInfo(SolrQueryRequest req) {
        NamedList cats = new NamedList();
        String[] requestedCats = req.getParams().getParams("cat");
        if (null == requestedCats || 0 == requestedCats.length) {
            for (SolrInfoBean.Category category : SolrInfoBean.Category.values()) {
                cats.add(category.name(), (Object)new SimpleOrderedMap());
            }
        } else {
            for (String string : requestedCats) {
                cats.add(string, (Object)new SimpleOrderedMap());
            }
        }
        Set<String> set = this.arrayToSet(req.getParams().getParams("key"));
        Map<String, SolrInfoBean> reg = req.getCore().getInfoRegistry();
        for (Map.Entry<String, SolrInfoBean> entry : reg.entrySet()) {
            this.addMBean(req, (NamedList<NamedList<NamedList<Object>>>)cats, set, entry.getKey(), entry.getValue());
        }
        for (SolrInfoBean solrInfoBean : req.getCoreContainer().getResourceLoader().getInfoMBeans()) {
            this.addMBean(req, (NamedList<NamedList<NamedList<Object>>>)cats, set, solrInfoBean.getName(), solrInfoBean);
        }
        return cats;
    }

    private void addMBean(SolrQueryRequest req, NamedList<NamedList<NamedList<Object>>> cats, Set<String> requestedKeys, String key, SolrInfoBean m) {
        if (!requestedKeys.isEmpty() && !requestedKeys.contains(key)) {
            return;
        }
        NamedList catInfo = (NamedList)cats.get(m.getCategory().name());
        if (null == catInfo) {
            return;
        }
        SimpleOrderedMap mBeanInfo = new SimpleOrderedMap();
        mBeanInfo.add("class", (Object)m.getName());
        mBeanInfo.add("description", (Object)m.getDescription());
        if (req.getParams().getFieldBool(key, "stats", false) && m.getSolrMetricsContext() != null) {
            mBeanInfo.add("stats", m.getSolrMetricsContext().getMetricsSnapshot());
        }
        catInfo.add(key, (Object)mBeanInfo);
    }

    protected NamedList<NamedList<NamedList<Object>>> getDiff(NamedList<NamedList<NamedList<Object>>> ref, NamedList<NamedList<NamedList<Object>>> now, boolean includeAll) {
        NamedList changed = new NamedList();
        for (int i = 0; i < ref.size(); ++i) {
            String now_txt;
            String category = ref.getName(i);
            NamedList ref_cat = (NamedList)ref.get(category);
            NamedList now_cat = (NamedList)now.get(category);
            if (now_cat == null) continue;
            String ref_txt = "" + ref_cat;
            if (!ref_txt.equals(now_txt = "" + now_cat)) {
                SimpleOrderedMap cat = new SimpleOrderedMap();
                for (int j = 0; j < ref_cat.size(); ++j) {
                    String name = ref_cat.getName(j);
                    NamedList ref_bean = (NamedList)ref_cat.get(name);
                    NamedList now_bean = (NamedList)now_cat.get(name);
                    ref_txt = "" + ref_bean;
                    if (!ref_txt.equals(now_txt = "" + now_bean)) {
                        NamedList<Object> diff = this.diffNamedList(ref_bean, now_bean);
                        diff.add("_changed_", (Object)true);
                        cat.add(name, diff);
                        continue;
                    }
                    if (!includeAll) continue;
                    cat.add(name, (Object)ref_bean);
                }
                if (cat.size() <= 0) continue;
                changed.add(category, (Object)cat);
                continue;
            }
            if (!includeAll) continue;
            changed.add(category, (Object)ref_cat);
        }
        return changed;
    }

    public NamedList<Object> diffNamedList(NamedList<?> ref, NamedList<?> now) {
        String name;
        int i;
        SimpleOrderedMap out = new SimpleOrderedMap();
        for (i = 0; i < ref.size(); ++i) {
            name = ref.getName(i);
            Object r = ref.getVal(i);
            Object n = now.get(name);
            if (n == null) {
                if (r == null) continue;
                out.add("REMOVE " + name, r);
                now.remove(name);
                continue;
            }
            if (r == null) continue;
            out.add(name, this.diffObject(r, n));
            now.remove(name);
        }
        for (i = 0; i < now.size(); ++i) {
            name = now.getName(i);
            Object v = now.getVal(i);
            if (v == null) continue;
            out.add("ADD " + name, v);
        }
        return out;
    }

    public Object diffObject(Object ref, Object now) {
        if (now instanceof Map) {
            now = new NamedList((Map)now);
        }
        if (ref instanceof NamedList) {
            return this.diffNamedList((NamedList)ref, (NamedList)now);
        }
        if (ref.equals(now)) {
            return ref;
        }
        StringBuilder str = new StringBuilder();
        str.append("Was: ").append(ref).append(", Now: ").append(now);
        if (ref instanceof Number) {
            NumberFormat nf = NumberFormat.getIntegerInstance(Locale.ROOT);
            if (ref instanceof Double || ref instanceof Float) {
                nf = NumberFormat.getInstance(Locale.ROOT);
            }
            double dref = ((Number)ref).doubleValue();
            double dnow = ((Number)now).doubleValue();
            double diff = Double.NaN;
            diff = Double.isNaN(dref) ? dnow : (Double.isNaN(dnow) ? dref : dnow - dref);
            str.append(", Delta: ").append(nf.format(diff));
        }
        return str.toString();
    }

    public void normalize(NamedList<?> input) {
        input.remove("avgRequestsPerSecond");
        for (int i = 0; i < input.size(); ++i) {
            Object v = input.getVal(i);
            if (!(v instanceof NamedList)) continue;
            this.normalize((NamedList)v);
        }
    }

    @Override
    public String getDescription() {
        return "Get Info (and statistics) for registered SolrInfoMBeans";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }
}

