/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.llm.texttovector.store.rest;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.jcip.annotations.ThreadSafe;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.llm.texttovector.model.SolrTextToVectorModel;
import org.apache.solr.llm.texttovector.store.TextToVectorModelException;
import org.apache.solr.llm.texttovector.store.TextToVectorModelStore;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.ManagedResource;
import org.apache.solr.rest.ManagedResourceObserver;
import org.apache.solr.rest.ManagedResourceStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ManagedTextToVectorModelStore
extends ManagedResource
implements ManagedResource.ChildResourceSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String REST_END_POINT = "/schema/text-to-vector-model-store";
    private static final String MODELS_JSON_FIELD = "models";
    static final String CLASS_KEY = "class";
    static final String NAME_KEY = "name";
    static final String PARAMS_KEY = "params";
    private final TextToVectorModelStore store = new TextToVectorModelStore();
    private Object managedData;

    public static void registerManagedTextToVectorModelStore(SolrResourceLoader solrResourceLoader, ManagedResourceObserver managedResourceObserver) {
        solrResourceLoader.getManagedResourceRegistry().registerManagedResource(REST_END_POINT, ManagedTextToVectorModelStore.class, managedResourceObserver);
    }

    public static ManagedTextToVectorModelStore getManagedModelStore(SolrCore core) {
        return (ManagedTextToVectorModelStore)core.getRestManager().getManagedResource(REST_END_POINT);
    }

    private static List<Object> modelsAsManagedResources(List<SolrTextToVectorModel> models) {
        return models.stream().map(ManagedTextToVectorModelStore::toModelMap).collect(Collectors.toList());
    }

    public static SolrTextToVectorModel fromModelMap(SolrResourceLoader solrResourceLoader, Map<String, Object> embeddingModel) {
        return SolrTextToVectorModel.getInstance(solrResourceLoader, (String)embeddingModel.get(CLASS_KEY), (String)embeddingModel.get(NAME_KEY), (Map)embeddingModel.get(PARAMS_KEY));
    }

    private static LinkedHashMap<String, Object> toModelMap(SolrTextToVectorModel model) {
        LinkedHashMap<String, Object> modelMap = new LinkedHashMap<String, Object>(5, 1.0f);
        modelMap.put(NAME_KEY, model.getName());
        modelMap.put(CLASS_KEY, model.getEmbeddingModelClassName());
        modelMap.put(PARAMS_KEY, model.getParams());
        return modelMap;
    }

    public ManagedTextToVectorModelStore(String resourceId, SolrResourceLoader loader, ManagedResourceStorage.StorageIO storageIO) throws SolrException {
        super(resourceId, loader, storageIO);
    }

    protected ManagedResourceStorage createStorage(ManagedResourceStorage.StorageIO storageIO, SolrResourceLoader loader) throws SolrException {
        return new ManagedResourceStorage.JsonStorage(storageIO, loader, -1);
    }

    protected void onManagedDataLoadedFromStorage(NamedList<?> managedInitArgs, Object managedData) throws SolrException {
        this.store.clear();
        this.managedData = managedData;
    }

    public void loadStoredModels() {
        log.info("------ managed models ~ loading ------");
        if (this.managedData != null && this.managedData instanceof List) {
            List textToVectorModels = (List)this.managedData;
            for (Map textToVectorModel : textToVectorModels) {
                this.addModelFromMap(textToVectorModel);
            }
        }
    }

    private void addModelFromMap(Map<String, Object> modelMap) {
        try {
            this.addModel(ManagedTextToVectorModelStore.fromModelMap(this.solrResourceLoader, modelMap));
        }
        catch (TextToVectorModelException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    public void addModel(SolrTextToVectorModel model) throws TextToVectorModelException {
        try {
            if (log.isInfoEnabled()) {
                log.info("adding model {}", (Object)model.getName());
            }
            this.store.addModel(model);
        }
        catch (TextToVectorModelException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    protected Object applyUpdatesToManagedData(Object updates) {
        if (updates instanceof List) {
            List textToVectorModels = (List)updates;
            for (Map textToVectorModel : textToVectorModels) {
                this.addModelFromMap(textToVectorModel);
            }
        }
        if (updates instanceof Map) {
            Map map = (Map)updates;
            this.addModelFromMap(map);
        }
        return ManagedTextToVectorModelStore.modelsAsManagedResources(this.store.getModels());
    }

    public void doDeleteChild(BaseSolrResource endpoint, String childId) {
        this.store.delete(childId);
        this.storeManagedData(this.applyUpdatesToManagedData(null));
    }

    public void doGet(BaseSolrResource endpoint, String childId) {
        SolrQueryResponse response = endpoint.getSolrResponse();
        response.add(MODELS_JSON_FIELD, ManagedTextToVectorModelStore.modelsAsManagedResources(this.store.getModels()));
    }

    public SolrTextToVectorModel getModel(String modelName) {
        return this.store.getModel(modelName);
    }

    public String toString() {
        return "ManagedModelStore [store=" + this.store + "]";
    }
}

