"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addDetectorMethods = addDetectorMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addDetectorMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.CREATE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.SEARCH_DETECTORS] = createAction({
    url: {
      fmt: `${_constants.API.SEARCH_DETECTORS}`
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_DETECTOR] = createAction({
    url: {
      fmt: `${_constants.API.DETECTORS_BASE}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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