"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricsRoute = registerMetricsRoute;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerMetricsRoute(router) {
  router.get({
    path: _common.ServiceEndpoints.GetStats,
    validate: false
  }, async (context, _, response) => {
    try {
      const metrics = context.searchRelevance.metricsService.getStats();
      return response.ok({
        body: JSON.stringify(metrics, null, 2)
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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